#pragma once

#include <atlstr.h>

#define GS_TXT_GREEK 1
#define GS_SUPERSCRIPT_GREEK 2
#define GS_SUBSCRIPT_GREEK 4
#define GS_TXT_UNDERLINE 8

class GreekSymbol
{
public:
	CString _mainText;
	CString _superScript;
	CString _subScript;
	CString _upperText;

	short _styleBitCode;

public:
	GreekSymbol()
	{
		_styleBitCode = 0;
	}

	GreekSymbol(const CString& txt)
	{
		_mainText = txt;
		_styleBitCode = 0;
	}

	GreekSymbol(const CString& txt, short code)
	{
		_mainText = txt;
		_styleBitCode = code;
	}

	GreekSymbol(const CString& txt, const CString& superScript, const CString& subScript, short code)
	{
		_mainText = txt;
		_superScript = superScript;
		_subScript = subScript;
		_styleBitCode = code;
	}

	void Set(const CString& txt, short code = 0)
	{
		_mainText = txt;
		_styleBitCode = code;
	}

	void Set(const CString& txt, const CString& superScript, const CString& subScript, short code = 0)
	{
		_mainText = txt;
		_superScript = superScript;
		_subScript = subScript;
		_styleBitCode = code;
	}

	void SetAsLatex(const CString& txt, short code = 0)
	{
		_mainText = txt; // TODO
		_styleBitCode = code;
	}


	bool IsDefined() {	return !_mainText.IsEmpty(); }
	bool IsSuperScript() { return !_superScript.IsEmpty(); }
	bool IsSubScript() { return !_subScript.IsEmpty(); }

	bool IsGreek() { return ((_styleBitCode & GS_TXT_GREEK) == GS_TXT_GREEK); }
	bool IsTopTxtGreek() { return ((_styleBitCode & GS_SUPERSCRIPT_GREEK) == GS_SUPERSCRIPT_GREEK); }
	bool IsBottomTxtGreek() { return ((_styleBitCode & GS_SUBSCRIPT_GREEK) == GS_SUBSCRIPT_GREEK); }
	bool IsUnderline() { return ((_styleBitCode & GS_TXT_UNDERLINE) == GS_TXT_UNDERLINE); }
};
