#pragma once

#include <atlstr.h>
#include <vector>
#include <utility>
#include <string>
#include "GreekSymbol.h"

using std::string;

//typedef void GridClickCB(void* gridData, int row, int col);


class UNIT_fieldBase
{
public:
	enum eValType { TYPE_DOUBLE, TYPE_INT };
	enum eIntValType { TYPE_VALUE, TYPE_COMBOBOX, TYPE_CHECKBOX };

public:
	double value;
	int    IntValue;
	int    Lf;
	int    Sdata;
	int    EvolFun;
	CString ValueName;
	enum eValType DataType;
	enum eIntValType intDataType;
	std::vector<std::pair<CString, int>> comboStringToInt;
	GreekSymbol symbol;
	double minVal;
	double maxVal;
	bool resizeHeaderColToFit;
	bool isReadOnly;

protected:
	bool minDefined;
	bool maxDefined;

public:
	UNIT_fieldBase()
	{
		value = 0.0;
		Lf = 0;
		Sdata = 0;
		EvolFun = 0;
		IntValue = 0;
		minVal = -1.0e38;
		maxVal =  1.0e38;

		ValueName = "No name";
		DataType = TYPE_DOUBLE;
		intDataType = TYPE_VALUE;

		minDefined = false;
		maxDefined = false;
		resizeHeaderColToFit = false;
		isReadOnly = false;
	}

	UNIT_fieldBase(int intVal, const CString& valName)
	{
		value = 0.0;
		Lf = 0;
		Sdata = 0;
		EvolFun = 0;
		IntValue = intVal;
		minVal = -1.0e38;
		maxVal = 1.0e38;

		DataType = TYPE_INT;
		intDataType = TYPE_CHECKBOX;
		ValueName = valName;

		minDefined = false;
		maxDefined = false;
		resizeHeaderColToFit = false;
		isReadOnly = false;
	}


	virtual ~UNIT_fieldBase() {}

	UNIT_fieldBase& UNIT_fieldBase::operator = (const UNIT_fieldBase& val)
	{
		value = val.value;
		Lf = val.Lf;
		Sdata = val.Sdata;
		EvolFun = val.EvolFun;
		IntValue = val.IntValue;
		minVal = val.minVal;
		maxVal = val.maxVal;

		ValueName = val.ValueName;
		DataType = val.DataType;
		intDataType = val.intDataType;
		comboStringToInt = val.comboStringToInt;
		symbol = val.symbol;

		minDefined = val.minDefined;
		maxDefined = val.maxDefined;
		resizeHeaderColToFit = val.resizeHeaderColToFit;
		isReadOnly = val.isReadOnly;

		return *this;
	}

	void SetIntValue(int val) noexcept
	{
		DataType = TYPE_INT;
		IntValue = val;
	}

	int  GetIntValue() { return IntValue; }

	void SetReadOnly(bool b = true) { isReadOnly = b; }
	bool IsReadOnly() const { return isReadOnly; }

	// min max verification
	void SetMax(double maxV) noexcept 
	{
		maxVal = maxV; 
		maxDefined = true;
	}

	void SetMin(double minV) noexcept 
	{
		minVal = minV; 
		minDefined = true;
	}

	void SetMinMax(double minV, double maxV) noexcept 
	{ 
		minVal = minV;  
		maxVal = maxV; 
		minDefined = true;
		maxDefined = true;
	}

	int  CheckValueRange() noexcept { return (value >= minVal && value <= maxVal); }
	int  CheckValueRange(double valTocheck) noexcept { return (valTocheck >= minVal && valTocheck <= maxVal); }
	int  CheckIntRange() noexcept { return (IntValue >= minVal && IntValue <= maxVal); }
	int  CheckIntRange(int valTocheck) noexcept { return (valTocheck >= minVal && valTocheck <= maxVal); }
	void GetValidateString(CString& txt) 
	{ 
		if (minDefined && maxDefined)
			txt.Format("Please enter number between %g and %g.", minVal, maxVal); 
		else if (minDefined)
			txt.Format("Please enter number greater than %g.", minVal);
		else
			txt.Format("Please enter number smaller than %g.", maxVal);
	}

	virtual int  operator > (double val) noexcept { return (value > val); }
	virtual int  operator < (double val) noexcept { return (value < val); }

	virtual double operator + (double val) noexcept { return (value + val); }
	virtual double operator - (double val) noexcept { return (value - val); }
	virtual double operator / (double val) noexcept { return (value / val); }
	virtual double operator * (double val) noexcept { return (value * val); }

	operator double(void)  noexcept	{ return value;	}

	void SetComboBox(int iniVal, const CString& valName, std::vector<std::pair<CString, int>>& comboStrings) 
	{
		SetIntValue(iniVal);
		intDataType = TYPE_COMBOBOX;
		ValueName = valName;
		comboStringToInt = comboStrings;
	}

	int GetComboBoxValue(const CString& selectedText) const
	{
		for (int i = 0; i < comboStringToInt.size(); i++)
		{
			if (comboStringToInt[i].first == selectedText)
				return comboStringToInt[i].second;
		}
		
		return -1;
	}

	CString GetComboBoxString() const
	{
		for (int i = 0; i < comboStringToInt.size(); i++)
		{
			if (comboStringToInt[i].second == IntValue)
				return comboStringToInt[i].first;
		}

		return CString();
	}


	bool SetComboBoxValue(CString& selectedText)
	{
		int sel = GetComboBoxValue(selectedText);
		if (sel == -1)
			return false;

		IntValue = sel;
		return true;
	}

	void SetCheckBox(int iniVal, const CString& valName)
	{
		SetIntValue(iniVal);
		intDataType = TYPE_CHECKBOX;
		ValueName = valName;
	}

	bool IsDouble() const {	return DataType == TYPE_DOUBLE;	}
	bool IsInt() const { return (DataType == TYPE_INT && intDataType == TYPE_VALUE); }

	bool IsComboBox() const { return (DataType == TYPE_INT && intDataType == TYPE_COMBOBOX); }
	bool IsCheckBox() const { return (DataType == TYPE_INT && intDataType == TYPE_CHECKBOX); }

	// greek symbol initialization
	void SetGreekSymbol(const CString& txt, short code = 0) { symbol.Set(txt, code); }
	void SetGreekSymbol(const CString& txt, const CString& superScript, const CString& subScript, short code = 0) { symbol.Set(txt, superScript, subScript, code); }
	void SetGreekSymbolAsLatex(const CString& txt, short code = 0) { symbol.SetAsLatex(txt, code); }

	string GetValueName() { string s((LPCTSTR)ValueName); return s; }
	void SetValueName(string s) { ValueName = s.c_str(); }
	//string GetValueName() { return ValueName; }
	//void SetValueName(string s) { ValueName = s; }

	string GetValueAsStr() 
	{ 
		if (DataType == TYPE_DOUBLE)
		{
			CString txt;
			txt.Format("%g", value);
			string s((LPCTSTR)txt); 
			return s;
		}
		else
		{
			if (IsCheckBox())
			{
				string s;
				if (IntValue)
					s = "ON";
				else
					s = "OFF";

				return s;
			}
			else if (IsComboBox())
			{
				CString txt = GetComboBoxString();
				string s((LPCTSTR)txt);
				return s;
			}
			else
			{
				CString txt;
				txt.Format("%ld", IntValue);
				string s((LPCTSTR)txt);
				return s;
			}
		}

		string s = "";
		return s;
	}

};
