//////////////////////////////////////////////////////////////////////////
//
//	File :	Bag.h
//
//	Object  :  template class for a bag (container of same objects)
//		
//
// David Alvarez Debrot (@ZACE)
// 17.8.95
//
//		Trois classes :
//
//		Bag ->		Bag a taille variable (elle peut changer en cours d'utilisation)
//
//		BagFixed ->	Bag a taille fixe (ell NE peut pas changer)
//					( comme en new  X[20] ou X et une classe)
//
//		BagFixedPoli -> Bag a taille fixe, permets le polymorphisme
//						(inserer de elements de taille variable )
//
//		Utilisation :
//			class Bidon {};
//				Bag<Bidon>
//				int m = Bag.InsertElement(1)
//				Bag[m] est maintenant un instance de Bidon !!
//				Bag[m].FonctionSurBidon();
//
//				delete toute seule !! (a moin de la definir comme un pointeur !!)
//////////////////////////////////////////////////////////////////////////
#ifndef INCLUDE_BAG
#define INCLUDE_BAG
#include <stdarg.h>

template <class T> inline T Min(const T& t1,const T& t2) { return ( t1 < t2 ? t1 : t2 ); } 
template <class T> inline T Max(const T& t1,const T& t2) { return ( t1 > t2 ? t1 : t2 ); }

template <class T> class Bag
{
protected :
	Bag*	Next;
	T*	Elem;
	int NumElem;
	Bag* SearchBag;
private :
	T* InsertNElem(int);
public :
	Bag()
	{
		Next	= NULL;
		Elem	= NULL;
		NumElem = 0;
	}
	Bag(Bag&);
	~Bag() 
	{ 	
		if ( Next ) delete Next;
		if ( Elem ) delete Elem;
	}
	// utiliser seulement le premier parametre (position)
	// le second est interne
	void* Remove(int = 0,int =1);
	void  RemoveLastElement(void) ; 
	void  RemoveLastElement(int n) ; 
	int   RemoveEle(const T&);
// CB Added by SC-PB 19/06/97 (LSC-EPFL)
	void RemoveAllElements(void) ;
	int IsEmpty() { return (NumElem ? 0 : 1) ; }
// CE Added by SC-PB 19/06/97 (LSC-EPFL)

// inserer 1 element si il n'existe pas dans le bag
// on teste si il existe toujours
	int InsertElem(const T&);
	T* QInsertElem(const T&);
// inserer l'element toujours
	T* InsertAllwaysElem(const T&);
// CB Added by SC-PB 19/06/97 (LSC-EPFL)
	void InsertAllwaysElemPtr(T*) ;
// CE Added by SC-PB 19/06/97 (LSC-EPFL)
	 
// if i != 1 returns the FIRST element inserted !!!
	int InsertElem(int i) { InsertNElem(i); return NumElem-i; }
// inserer 1 element et retourne un pointeur su lui
	T* InsertOneElem(void) { return InsertNElem(1); }
	int GiveNumElem(void) const { return NumElem; }
	T*	GiveElem(void) const { return Elem; }
// give the elements from the end (the last on is 0)
	T&	GiveLastElement(int n = 0)  const ;
	Bag* GiveNextBag() const { return Next; }
// pour vider le Bag
	void ViderBag()	;
	inline T& operator[] (int) const;
	void ResizeBag(int);
	Bag<T>& operator=(const Bag&);
	int operator==(const T&) const;
	int operator==(const Bag<T>&) const;
	// trois fonctions pour la recherche rapide dans le bag
	void InitializeSearch(void) { SearchBag = this;  }
	inline T* GiveNextElement(void);
	int GiveNumElemSearch() const{ return ( NumElem - 1 - ( (SearchBag == NULL) ?  0 : SearchBag->GiveNumElem() ) ); }
};


//////////////////////////////////////////////////////////////////////////
template <class T> void Bag<T>::RemoveLastElement(void) 
//////////////////////////////////////////////////////////////////////////
{	ASSERT(NumElem ); 
	if ( NumElem) Remove(NumElem-1); 
}

//////////////////////////////////////////////////////////////////////////
template <class T> void Bag<T>::RemoveLastElement(int n)
//////////////////////////////////////////////////////////////////////////
{	ASSERT(n); 
	while ( n-- ) RemoveLastElement(); 
}

// CB Added by SC-PB 20/06/97 (LSC-EPFL)
//////////////////////////////////////////////////////////////////////////
template <class T> void Bag<T>::RemoveAllElements(void) 
//////////////////////////////////////////////////////////////////////////
{	if ( NumElem ) RemoveLastElement(NumElem); 
}
// CE Added by SC-PB 20/06/97 (LSC-EPFL)

//////////////////////////////////////////////////////////////////////////
template <class T> T & Bag<T>::GiveLastElement(int n)  const 
//////////////////////////////////////////////////////////////////////////
{	ASSERT(NumElem && n >= 0 && (NumElem-n-1) >= 0 ); 
	return this->operator[](NumElem-n-1); 
}

//////////////////////////////////////////////////////////////////////////
template <class T> T* Bag<T>::GiveNextElement(void)
//////////////////////////////////////////////////////////////////////////
{
	if ( SearchBag == NULL ) return NULL;
	T* temp = SearchBag->Elem;
	SearchBag = SearchBag->Next;
	return temp;
}

//////////////////////////////////////////////////////////////////////////
template <class T> void Bag<T>::ViderBag()
//////////////////////////////////////////////////////////////////////////
{	if ( Next )	delete Next;
	Next = NULL;
	if ( Elem ) delete Elem; 
	Elem = NULL;
	NumElem = 0;
}

//////////////////////////////////////////////////////////////////////////
template <class T> T* Bag<T>::QInsertElem(const T& elem)
//////////////////////////////////////////////////////////////////////////
{
	T *elem2;
	InitializeSearch();
	while ( (elem2 = GiveNextElement()) != NULL ) {
		if ( *elem2 ==elem ) return elem2;
	}
	return InsertAllwaysElem(elem);
}
//////////////////////////////////////////////////////////////////////////
template <class T> int Bag<T>::InsertElem(const T& elem)
//////////////////////////////////////////////////////////////////////////
{
	T *elem2;
	InitializeSearch();
	while ( (elem2 = GiveNextElement()) != NULL ) {
		if ( *elem2 ==elem ) return GiveNumElemSearch();
	}
	elem2 = InsertOneElem();
	*elem2 = elem;
	return (GiveNumElem()-1);
}
//////////////////////////////////////////////////////////////////////////
template <class T> T* Bag<T>::InsertAllwaysElem(const T& elem)
//////////////////////////////////////////////////////////////////////////
{
	NumElem ++;
	if ( Next )				// si existe un prochain passer insert a prochain
	{
		return Next->InsertAllwaysElem(elem);
	}
	if ( Elem == NULL )		// si pas d'element dans ce noeud enmagasiner un noeud
	{
		Elem = new T(elem);
		return Elem;
	}
	Next = new Bag;	// creer une nouveau noeud pour mettre des el.
	if ( !Next || !Elem )
	{
		NumElem = 0;
		MessageBox(NULL,"Bag::InsertNElem"," Not enough memory to run application",MB_ICONINFORMATION);
	}
	return Next->InsertAllwaysElem(elem);
}

// CB Added by SC-PB 19/06/97 (LSC-EPFL)
//////////////////////////////////////////////////////////////////////////
template <class T> void Bag<T>::InsertAllwaysElemPtr(T * elem)
//////////////////////////////////////////////////////////////////////////
{
	NumElem ++;
	if ( Next )				// si existe un prochain passer insert a prochain
	{
		Next->InsertAllwaysElemPtr(elem);
		return ;
	}
	if ( Elem == NULL )		// si pas d'element dans ce noeud enmagasiner un noeud
	{
		Elem = elem ;
		return ;
	}
	Next = new Bag;	// creer une nouveau noeud pour mettre des el.
	if ( !Next || !Elem )
	{
		NumElem = 0;
		MessageBox(NULL,"Bag::InsertNElem"," Not enough memory to run application",MB_ICONINFORMATION );
	}
	Next->InsertAllwaysElemPtr(elem);
}
// CE Added by SC-PB 19/06/97 (LSC-EPFL)

//////////////////////////////////////////////////////////////////////////
template <class T> void Bag<T>::ResizeBag(int newtam)
//////////////////////////////////////////////////////////////////////////
{
	if ( newtam < 0 )
	{
		MessageBox(NULL,"Bag::ResizeBag" , " n could be less than zero",MB_ICONINFORMATION);
		return;
	}
	if ( newtam == NumElem ) return;
	if ( newtam > NumElem ) InsertNElem(newtam-NumElem);
	else
	{
		int m = NumElem-newtam; 		// NumElem change !!!
		for ( int n=0; n < m; n++ )
			Remove(NumElem-1);		// effacer le dernier
	}
}

//////////////////////////////////////////////////////////////////////////
template <class T> T* Bag<T>::InsertNElem(int n)
//////////////////////////////////////////////////////////////////////////
{
	if ( n == 0 ) return NULL;
	if ( n < 0 )
	{
		MessageBox(NULL,"Bag::InsertNElem" , " n less than 0\nplease call ZACE S.A",MB_ICONINFORMATION);
		return NULL;
	}
	NumElem += n;
	if ( Next )				// si existe un prochain passer insert a prochain
	{
		return Next->InsertNElem(n);
	}
	if ( Elem == NULL )		// si pas d'element dans ce noeud enmagasiner un noeud
	{
		Elem = new T;
		if ( n == 1 ) return Elem;
		n--;
	}
	Next	= new Bag;	// creer une nouveau noeud pour mettre des el.
	if ( !Next || !Elem )
	{
		NumElem = 0;
			MessageBox(NULL,"Bag::InsertNElem"," Not enough memory to run application",MB_ICONINFORMATION);
	}
	if ( n ) 
		return Next->InsertNElem(n);
	return Elem;
}

//////////////////////////////////////////////////////////////////////////
//
template <class T> T& Bag<T>::operator[] (int n) const
//
//	surdefinir l'operateur () pour pouvoir faire
//	
//	bagElem(3) 		== un DataMaterial (ex. le numero 3)
//
//////////////////////////////////////////////////////////////////////////
{
#ifdef DADDEBUGBAG
	if ( n < 0 || n >= NumElem )
	{
		if ( Elem )
			MessageBox(NULL,"Bag::operator()" , " n out of range",MB_ICONINFORMATION);
		else
			MessageBox(NULL,"Bag::operator()" , " n out of range",MB_ICONINFORMATION);
		return *Elem;
	}
#endif
 	if (n) 
 		return (*Next)[--n];
	return *Elem;
} 

//////////////////////////////////////////////////////////////////////////
template <class T> Bag<T>::Bag(Bag& bag) 
//////////////////////////////////////////////////////////////////////////
{
	Next	= NULL;
	Elem	= NULL;
	NumElem = 0;
	InsertNElem(bag.NumElem);

	T *elem,*elem2;
	InitializeSearch();
	bag.InitializeSearch();
	while ( (elem = GiveNextElement()) != NULL ) {
		VERIFY( elem2 = bag.GiveNextElement() );
		*elem = *elem2;
	}
}
//////////////////////////////////////////////////////////////////////////
template <class T> Bag<T>& Bag<T>::operator = (const Bag& bag) 
//////////////////////////////////////////////////////////////////////////
{
	if ( bag.NumElem != NumElem )
	{
		const Bag<T> *pbag = &bag;

		this->ViderBag();
		for ( int i = 0; i < bag.NumElem; i++) {
			ASSERT(pbag);
			this->InsertAllwaysElem( *(pbag->Elem) );
			pbag = pbag->Next;
		}
	}
	else {
		T *elem;
		const Bag<T> *pbag = &bag;

		InitializeSearch();
		while ( (elem = GiveNextElement() ) != NULL ) {
			ASSERT( pbag && pbag->Elem );
			*elem = *(pbag->Elem);
			pbag = pbag->Next;
		}
	}
	return *this;
}

//////////////////////////////////////////////////////////////////////////
template <class T> int Bag<T>::operator==(const T& elem) const
//////////////////////////////////////////////////////////////////////////
{
	const Bag<T> *pbag = this;
	for ( int i = 0; i < NumElem; i++) {
		ASSERT(pbag);
		if ( *(pbag->Elem) == elem ) return i+1;
		pbag = pbag->Next;
	}
	return 0;
}
//////////////////////////////////////////////////////////////////////////
template <class T> int Bag<T>::operator==(const Bag<T>& elem) const
//////////////////////////////////////////////////////////////////////////
{
	if ( NumElem != elem.NumElem ) return 0;
	const Bag<T> *pbag = this;
	const Bag<T> *tbag = &elem;
	for ( int i = 0; i < NumElem; i++) {
		ASSERT(pbag);		
		ASSERT(tbag);
		if ( !(*(pbag->Elem) == *(tbag->Elem)) )  return 0;
		pbag = pbag->Next;
		tbag = tbag->Next;
	}
	return 1;
}
//////////////////////////////////////////////////////////////////////////
template <class T> int Bag<T>::RemoveEle(const T& elem)
//////////////////////////////////////////////////////////////////////////
{
	T *elem2;
	InitializeSearch();
	while ( (elem2 = GiveNextElement()) != NULL ) {
		if ( *elem2 == elem ) {
			Remove( GiveNumElemSearch() );
			return 1;
		}
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////////
template <class T> void* Bag<T>::Remove(int n ,int First )
//////////////////////////////////////////////////////////////////////////
{
if ( n < 0 )
	{
		MessageBox(NULL,"Bag::Remove" , " n can be less than 0",MB_ICONINFORMATION);
		return NULL;
	}
NumElem--;

// On ne peut pas effacer le premier element facilement
if ( First && n == 0 )
{
	if ( Next == NULL )			// si pas prochain
	{
		delete Elem;
		Elem = NULL;
		return NULL;
	}
	*Elem = *(Next->Elem);			// copier prochain dans celui-ci
	n = 1;
}

if ( n == 0 )
{
	Bag *temp = Next;
	Next = NULL;  // pour permettre delete cette classe sans effacer
				  // tous le reste
	return temp;
}

if ( n == 1 )
{
	Bag *temp = (Bag *)Next->Remove(0,0);
	delete Next;
	Next = temp;
	return Next;
}
n--;
return Next->Remove(n,0);
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//
//	class BagFixed
//
//	use delete []
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

template <class T> class BagFixed
{
protected :
	T*	Elem;
	int NumElem;
	// for the search routine
	int ActualPos;	     // the actual elem pos
private :
public :
	BagFixed()
	{
		NumElem = 0;
		Elem = NULL;
	}
	BagFixed(const BagFixed&);
	~BagFixed()
	{
		delete [] Elem;
	}
// utiliser Remove(n) le deuxieme est interne !!!
	int InsertElem(int);
	int GiveNumElem(void) const { return NumElem; }
	int GiveTam(void) { return (int)sizeof(T)*NumElem; }
	T* GivePointer(void);
	void operator=(const BagFixed&);
	int operator==(const BagFixed&) const;
	void ViderBag()
	{
		delete [] Elem;
		NumElem = 0; Elem = NULL;
	}
	inline T& operator[] (int) const;
	// three functions to search
	void InitializeSearch(void) { ActualPos = -1; }
	inline T* GiveNextElement(void);
	int GiveNumElemSearch(void) const { return ActualPos; }
};
//////////////////////////////////////////////////////////////////////////
template <class T>	BagFixed<T>::BagFixed(const BagFixed& bag)
//////////////////////////////////////////////////////////////////////////
{
	int numEl = bag.GiveNumElem();
	NumElem = 0; Elem = NULL;
	InsertElem(numEl);
	for ( int n = 0; n < numEl; n++ )
		(*this)[n] = bag[n];
}
//////////////////////////////////////////////////////////////////////////
template <class T> int BagFixed<T>::operator==(const BagFixed<T>& elem) const
//////////////////////////////////////////////////////////////////////////
{
	if ( NumElem != elem.NumElem ) return 0;
	for ( int i = 0; i < NumElem; i++) {
		if ( !( (*this)[i] == elem[i] ) )  return 0;
	}
	return 1;
}
//////////////////////////////////////////////////////////////////////////
template <class T> T* BagFixed<T>::GiveNextElement(void)
//////////////////////////////////////////////////////////////////////////
{
	ActualPos++;
	if ( ActualPos >= NumElem ) return NULL;
	return &Elem[ActualPos];
}

//////////////////////////////////////////////////////////////////////////
template <class T> int BagFixed<T>::InsertElem(int n)
//////////////////////////////////////////////////////////////////////////
{
  	if ( n < 0 )
	{
		MessageBox(NULL,"Bag::operator()" , " n out of range",MB_ICONINFORMATION);
		return 0;
	}
	if ( NumElem )
	{
		MessageBox(NULL,"Bag::operator()" , " Can't modify tam of bag!!",MB_ICONINFORMATION);
		return 0;
	}
	Elem = new T[n];
	if ( Elem == NULL ) {
		MessageBox(NULL,"Bag::operator()" , " Not enough memory to run application",MB_ICONINFORMATION);
		return 0;
	}
	NumElem = n;		
	return 0;
}

//////////////////////////////////////////////////////////////////////////
template <class T> T& BagFixed<T>::operator[] (int n) const
//////////////////////////////////////////////////////////////////////////
{
#ifdef DADDEBUGBAG
	if ( n < 0 || n >= NumElem )
	{
		MessageBox(NULL,"Bag::operator()" , " n out of range",MB_ICONINFORMATION);
		return  Elem[n];
	}
#endif
	return Elem[n];
}

//////////////////////////////////////////////////////////////////////////
template <class T> void BagFixed<T>::operator=(const BagFixed& bag)
//////////////////////////////////////////////////////////////////////////
{
	ViderBag();
	int numEl = bag.GiveNumElem();
	InsertElem(numEl);
	for ( int n = 0; n < numEl; n++ )
		(*this)[n] = bag[n];
}

//////////////////////////////////////////////////////////////////////////
template <class T>T*  BagFixed<T>::GivePointer(void)
//////////////////////////////////////////////////////////////////////////
{
#ifdef DADDEBUGBAG
	if ( Elem == NULL )
	{
		MessageBox(NULL,"BagFixed::GivePointer()" , " there are no data in the Bag",MB_ICONINFORMATION);
	}
#endif
	return Elem;
}


#endif

