/************************************************************************
* Projet	:							*
* Fichier 	:	constant.h					*
* Fonctions 	:							*
* Auteur	:	Patricia BOMME				*
* Historique	:	Version C++ 0.0					*
*************************************************************************/
#ifndef CONSTANT_H
#define CONSTANT_H

#include <string.h>

enum eParType
{
T3D_PARAM_MAT1,
T3D_PARAM_MAT2,
T3D_PARAM_MAT3,
T3D_PARAM_EF,
T3D_PARAM_UNLFCT,
T3D_PARAM_NUM,
}; 

#define T3D_PARAM_CUR_TIME  T3D_PARAM_NUM

#define CODE_PARAM_MAT1 1
#define CODE_PARAM_MAT2 2
#define CODE_PARAM_MAT3 4
#define CODE_PARAM_EF   8
#define CODE_PARAM_UNLFCT 16
#define CODE_PARAM_EF_GAP_CONT 32
#define CODE_PARAM_EF_GAP_POS 64
#define CODE_PARAM_EF_GAP_NEG 128
#define CODE_PARAM_NAIL 256

#define CODE_PARAM_ALL (CODE_PARAM_MAT1 | CODE_PARAM_MAT2 | CODE_PARAM_MAT3 | CODE_PARAM_EF | CODE_PARAM_UNLFCT)
#define CODE_PARAM_INTERFACE (CODE_PARAM_MAT1 | CODE_PARAM_EF | CODE_PARAM_UNLFCT)
#define CODE_PARAM_SEEPAGE (CODE_PARAM_MAT1 | CODE_PARAM_EF | CODE_PARAM_UNLFCT)
#define CODE_PARAM_INI_GAP (CODE_PARAM_EF_GAP_CONT | CODE_PARAM_EF_GAP_POS | CODE_PARAM_EF_GAP_NEG)
#define CODE_PARAM_NAIL_ELE (CODE_PARAM_MAT1 | CODE_PARAM_MAT2 | CODE_PARAM_EF | CODE_PARAM_NAIL)



#define	null	(char *) 0
#define ANGLE	10.0
#define MOVE	0.05
#define EPSILON 0.0001
const double EPSILON2 = 1.0e-8;
#define streq(a,b) (strcmp(a,b) == 0)
#define T3D_beep() printf("%c\n",07);
#define T3D_MAT_PARAM_NUM 3

extern char FILENAME_G[];

/*----------------------------------------------------------------------------*/
/*                          DEFINITION DU TYPE Vector                         */
/*----------------------------------------------------------------------------*/
typedef struct
{
    	double    x, y, z;
} Vector;

/*----------------------------------------------------------------------------*/
/*                   DEFINITION DU TYPE Straight_Line                         */
/*----------------------------------------------------------------------------*/
typedef struct
{	Vector p,u;
} Straight_Line;
/*----------------------------------------------------------------------------*/
/*                DEFINITION DU TYPE Straight_Segment                         */
/*----------------------------------------------------------------------------*/
typedef struct
{	Vector p1,p2;
} Straight_Segment;

/*----------------------------------------------------------------------------*/ 
/*                      DEFINITION DU TYPE Plan                               */
/*----------------------------------------------------------------------------*/
typedef struct 
{	double a,b,c,d;
} Plan;

/*----------------------------------------------------------------------------*/ 
/*                      DEFINITION DU TYPE Sphere           WadahF                  */
/*----------------------------------------------------------------------------*/
typedef struct 
{	Vector center;
	double radius;
} Sphere;

/*----------------------------------------------------------------------------*/ 
/*                      DEFINITION DU TYPE Circle dans l'espace   WadahF            */
/*----------------------------------------------------------------------------*/
typedef struct 
{	Plan plan;
	Sphere sphere;
} Circle;


typedef struct 
{	double a,b;
} Straight_Line_2D;
#endif /*CONSTANT_H*/ 
