!MS$IF DEFINED (__ANAL_ENU_INC)
!MS$ELSE

      ! enumerators for analysis module
      integer*4 
     &         IANA_DEF_SWTT     ,
     &         IANA_DEF_FLOW     ,
     &         IANA_____FLOW     ,
     &         IANA_____HEAT     ,
     &         IANA____HUMID     ,
     &         IANA_NROF_TYPES   
      parameter(
     &         IANA_DEF_SWTT     = 1,
     &         IANA_DEF_FLOW     = 2,
     &         IANA_____FLOW     = 3,
     &         IANA_____HEAT     = 4,
     &         IANA____HUMID     = 5,
     &         IANA_NROF_TYPES   = 5)


      integer*4, parameter::
     &         IANA_INI_STATE    = 1,
     &         IANA_STABILITY    = 2,
     &         IANA_TIME_DPNT    = 3,
     &         IANA_P_DELTA      = 4,
     &         IANA_DYNAMIC_T    = 5, 
     &         IANA_S_PUSHOVER   = 6, 
     &         IANA_EIGENMODES   = 7, 
     &         IANA_NROF_PROCESS = 7  


      integer*4 
     &          IANA_P1      ,
     &          IANA_P2      ,
     &          IANA_DP0     ,
     &          IANA_DPMULT  ,
     &          IANA_FTOL    ,  
     &          IANA_ESTOL   ,  
     &          IANA_QTOL    ,  
     &          IANA_EFTOL   ,  
     
     &          IANA_AUTO_RED_FLAG       ,
     &          IANA_AUTO_RED_MAX_TRIALS ,
     &          IANA_AUTO_RED_FACTOR     ,
     &          IANA_AUTO_RED_INC_DT_FLAG,
     &          IANA_AUTO_RED_INC_DT_P1  ,
     &          IANA_AUTO_RED_INC_DT_FAC ,
     &          IANA_SHARPEN_NORMS_KIN_LOAD,
     &          IANA_SHARPEN_RHS_FACT      ,
     &          IANA_SHARPEN_ENE_FACT      ,
     &          IANA_AMPLF_RHS_LACK_CONV   ,
     &          IANA_TRY_NL_SOLVERS_FLAG   ,
     &          IANA_USE_LINE_SEARCH       ,
     &          IANA_MAKE_RST_DIR          ,
     &          IANA_SKIP_DIV_STEPS        ,
     &          IANA_NL_SOLVERS_BIT_CODE   ,
     &          IANA_NL_SOLVERS_USE_LAST_SUCCESS_FLAG,
     &          IANA_PARAMRECSIZE
      parameter(                        ! positions in parameter record:
     &          IANA_P1      = 1,
     &          IANA_P2      = 2,
     &          IANA_DP0     = 3,
     &          IANA_DPMULT  = 4,
     &          IANA_FTOL    = 5,  ! rhs force tol
     &          IANA_ESTOL   = 6,  ! energy for solid
     &          IANA_QTOL    = 7,  ! flux tol
     &          IANA_EFTOL   = 8,  ! energy for fluid
     &          IANA_AUTO_RED_FLAG       =  9, ! automatic reduction of time/sf step flag
     &          IANA_AUTO_RED_MAX_TRIALS = 10, ! max trials during automatic reduction of time/sf step flag
     &          IANA_AUTO_RED_FACTOR     = 11, ! reduction factor 
     &          IANA_AUTO_RED_INC_DT_FLAG= 12, ! [x] increase dt when niter/maxiter < .... flag
     &          IANA_AUTO_RED_INC_DT_P1  = 13, ! increase dt when niter/maxiter < [   ]
     &          IANA_AUTO_RED_INC_DT_FAC = 14, ! increase dt when niter/maxiter < ....  by factor [    ]     
     &          IANA_SHARPEN_NORMS_KIN_LOAD = 15, ! flag whether to sharpen norms for kinematic loading programs
     &          IANA_SHARPEN_RHS_FACT       = 16, ! factor to be used to sharpen RHS norm for kinematic loading    
     &          IANA_SHARPEN_ENE_FACT       = 17, ! factor to be used to sharpen ENERGY norm for kinematic loading    
     &          IANA_AMPLF_RHS_LACK_CONV    = 18, ! amplification factor for RHS norm in case of lack of convergence
     &          IANA_TRY_NL_SOLVERS_FLAG    = 19, ! flag whether to try nonlinear solvers in case of divergence
     &          IANA_USE_LINE_SEARCH        = 20, ! flag for line searches for NR and BFGS solvers
     &          IANA_MAKE_RST_DIR           = 21, ! enforce storing all files in subdirectory at end of the driver
     &          IANA_SKIP_DIV_STEPS         = 22, ! skip divergent steps flag
     &          IANA_NL_SOLVERS_BIT_CODE    = 23, ! bit code for nopnlinear solvers to be used in automatic solvers application
     &          IANA_NL_SOLVERS_USE_LAST_SUCCESS_FLAG = 24, ! flag whether we should keep last successfull nonlinear solver
     &          IANA_PARAMRECSIZE           = 24  ) ! size of real parameters record

      ! position in dynamic analysis setup line 
      integer*4,parameter::IANA_DYN_PARAM_OFFS   =IANA_PARAMRECSIZE
      integer*4,parameter::IANA_DYN_MASS_TYPE    =1, ! 1 lumped 2 consistent 
     &                     IANA_DYN_ROT_MASS_FLAG=2, ! 0 No, 1 Yes      
     &                     IANA_DYN_ALPHA_DAMP   =3, ! Raylegh dumping factors
     &                     IANA_DYN_BETA_DAMP    =4, ! C = alphaD*M+BetaD*K        
     &                     IANA_DYN_INTEG_PROC   =5, ! 1 Impl.Newmark dD . 2 New     
     &                     IANA_DYN_ALPHA_INTEG  =6, ! time integration algoritm constants      
     &                     IANA_DYN_BETA_INTEG   =7, !       
     &                     IANA_DYN_GAMMA_INTEG  =8,    
     &                     IANA_DYN_MASS_FILTER_FLAG     = 9,
     &                     IANA_DYN_MASS_FILTER_LOC_BASE =10,
     &                     IANA_DYN_MASS_FILTER_FLAG_X   =11,
     &                     IANA_DYN_MASS_FILTER_FLAG_Y   =12,
     &                     IANA_DYN_MASS_FILTER_FLAG_Z   =13,
     &                     IANA_DYN_DRM_LIST_B_INDEX     =14,
     &                     IANA_DYN_DRM_LIST_E_INDEX     =15,
     &                     IANA_DYN_THETA_FLUID          =16,
     &                     IANA_DYN_FLUID_ACC_DARCY_FLAG =17,
c    &                     IANA_DYN_ALPHA_FLUID          =18,
     &                     IANA_DYN_PARAMRECSIZE         =17

      ! position in pushover analysis setup line (pushover requires dynamic data as well)
      integer*4,parameter::IANA_PSH_PARAM_OFFS   =IANA_PARAMRECSIZE

      integer*4, parameter::IANA_PSH_CTRL_NODE        = 1,
     &                      IANA_PSH_F_PATTERN_TYPE   = 2,
     &                      IANA_PSH_F_PATTERN_GRAD_X = 3,
     &                      IANA_PSH_F_PATTERN_GRAD_Y = 4,
     &                      IANA_PSH_F_PATTERN_GRAD_Z = 5,
     &                      IANA_PSH_F_PATTERN_PT_X   = 6,
     &                      IANA_PSH_F_PATTERN_PT_Y   = 7,
     &                      IANA_PSH_F_PATTERN_PT_Z   = 8,
     &                      IANA_PSH_F_DIR_X          = 9,
     &                      IANA_PSH_F_DIR_Y          =10,
     &                      IANA_PSH_F_DIR_Z          =11,
     &                      IANA_PSH_MASS_FILTER_FLAG =12,
     &                      IANA_PSH_MASS_TYPE        =13,
     &                      IANA_PSH_ROT_MASS_FLAG    =14,
     &                      IANA_PSH_PARAMRECSIZE     =14

      integer*4, parameter::IANA_DYN_PSH_PARAMRECSIZE = 17 ! max(IANA_DYN_PARAMRECSIZE,IANA_PSH_PARAMRECSIZE)

      integer*4, parameter::IANA_PARAMRECSIZE_MAX = IANA_PARAMRECSIZE +
     &                                        IANA_DYN_PSH_PARAMRECSIZE

      integer*4 
     &           IANA_SOLV_FLOW          ,
     &           IANA_SOLV_DEFO          ,
     &           IANA_SOLV_NORMAL        

      parameter (
     &           IANA_SOLV_FLOW          = 1,
     &           IANA_SOLV_DEFO          = 2,
     &           IANA_SOLV_NORMAL        = 3 )

      integer*4 IANA_INS_APPRO_WITH_SIG0_CORR, 
     &            IANA_INS_APPRO_WITHOUT_CORR

      parameter ( IANA_INS_APPRO_WITH_SIG0_CORR = 1 ,
     &            IANA_INS_APPRO_WITHOUT_CORR   = 2 )


cAT 31.09.1999
      integer*4 IANA_NL_SOLVER_NEWTON_RAPHSON 
      integer*4 IANA_NL_SOLVER_BFGS           
      integer*4 IANA_NL_SOLVER_INIT_STIFF           
      integer*4 IANA_NL_SOLVER_NEWTON_RAPHSON_MODIFIED
      integer*4 IANA_NL_SOLVER_INIT_STIFF_ACCEL
      integer*4 IANA_NL_SOLVER_MAX 

      parameter( IANA_NL_SOLVER_NEWTON_RAPHSON = 1)
      parameter( IANA_NL_SOLVER_BFGS           = 2)
      parameter( IANA_NL_SOLVER_INIT_STIFF     = 3)
      parameter( IANA_NL_SOLVER_NEWTON_RAPHSON_MODIFIED  = 4)
      parameter( IANA_NL_SOLVER_INIT_STIFF_ACCEL=5)
      parameter( IANA_NL_SOLVER_MAX             =5)
	  
c    constant analysis info. local pointers

  
      integer*4, parameter :: IANA_FIRST_SUB_DRIVER = 1,
     &                        IANA_DRIV_LOAD  = 1,
     &                        IANA_CONS       = 2,
     &                        IANA_STEAD_FLO  = 3,
     &                        IANA_TRANS_FLO  = 4,
     &                        IANA_SF_STRLEV  = 5,
     &                        IANA_SF_TGPHIC  = 6,
     &                        IANA_SF_COHES   = 7,
     &                        IANA_DRIV_LSSF  = 8,
     &                        IANA_DRIV_LTRF  = 9,
     &                        IANA_DRIV_LNOF  = 10,
     &                        IANA_DRIV_LUND  = 11,     
     &                        IANA_LAST_SUB_DRIVER = 11

      integer*4, parameter ::
     &          IANA_DRIVER_TYPE     = 1,
     &          IANA_SUB_DRIVER_TYPE = 2, 
     &          IANA_ALGOR_ID        = 3,
     &          IANA_MAXITER         = 4,
     &          IANA_IRFSTE          = 5, ! which time step reform stiffness
     &          IANA_IRFITE          = 6, ! which iteration reform stiffness
     &          IANA_RESTART         = 7, ! which step store to restart
     &          IANA_PRINTSTEP       = 8, ! print
     &          IANA_PLOTSTEP        = 9, ! plot
     &          IANA_MAXMAX_ITER     = 10,! absolutely maximum nr of iter.
     &          IANA_AUTO_INC_MAXIT  = 11,! automaticaly add iterations when lack of convergence is detected (default TRUE)
     &          IANA_ADD_ITER_VALUE  = 12,! number of iterations to be added when lack of convergence is detected (default 5)
     &          IANA_PARAM           = 13,! ptr to parameters  data
     &          IANA_CONST_INFO_SIZE = IANA_PARAM              +
     &                                 2*IANA_PARAMRECSIZE     + ! standard data
     &                                 2*IANA_DYN_PARAMRECSIZE + ! dynamics driver
     &                                 2*IANA_PSH_PARAMRECSIZE   ! pushover driver

      ! enums for logical flags

      integer*4 
     &           IANA_RESTART_MODE       ,
     &           IANA_NEW_LHS_REQUESTED  ,
     &           IANA_INS_FIRST_ESTIM    ,
     &           IANA_SYSTEM_IS_SYMMETRIC,
     &           IANA_INCOMPRESS_POSSIBLE,
     &           IANA_LAST_INS_STEP
c    &           IANA_MODIFY_FLOATING_ELE


      parameter (
     &           IANA_RESTART_MODE       = 101,
     &           IANA_NEW_LHS_REQUESTED  = 102,
     &           IANA_INS_FIRST_ESTIM    = 103,
     &           IANA_SYSTEM_IS_SYMMETRIC= 107,
     &           IANA_INCOMPRESS_POSSIBLE= 108,
     &           IANA_LAST_INS_STEP      = 109)
c    &           IANA_MODIFY_FLOATING_ELE= 110)



      ! enums for real*8 data information
      integer*4 
     &           IANA_SAFETY_ACT ,
     &           IANA_SAFETY_BEG ,
     &           IANA_SAFETY_END ,

     &           IANA_GRAV_ACT   ,
     &           IANA_GRAV_END   ,
     &           IANA_GRAV_INC   ,

     &           IANA_DTIME_ACT  ,
     &           IANA_DTIME_BEG  ,
     &           IANA_TIME_FINAL ,
     &           IANA_DT_MULT    ,
     &           IANA_TIME_ACT   ,
     &           IANA_TIME_BEG   ,
     &           IANA_TIME_NEXT_LHS_REF,
     &           IANA_TIME_MAX,
     &           IANA_TIME_MIN
  


      parameter (
     &           IANA_SAFETY_ACT = 131,
     &           IANA_SAFETY_BEG = 132,
     &           IANA_SAFETY_END = 133,

     &           IANA_GRAV_ACT   = 134,
     &           IANA_GRAV_END   = 135,
     &           IANA_GRAV_INC   = 136,

     &           IANA_DTIME_ACT  = 137,
     &           IANA_DTIME_BEG  = 138,
     &           IANA_TIME_FINAL = 139,
     &           IANA_DT_MULT    = 140,
     &           IANA_TIME_ACT   = 141,
     &           IANA_TIME_BEG   = 142,
     &           IANA_TIME_NEXT_LHS_REF = 143,
     &           IANA_TIME_MAX   = 144,
     &           IANA_TIME_MIN   = 145)


      ! enums for int*4 data information

      integer*4 
     &           IANA_STEP_NR         ,
     &           IANA_ITER_NR         ,
     &           IANA_PATTERN_TO_KEEP ,
     &           IANA_INS_APPROACH    ,
     &           IANA_COUNT_NR        ,
     &           IANA_DRIVER_ACT      ,
     &           IANA_PROCESS_ACT     ,	 
     &           IANA_CURR_MAX_ITER   ,
     &           IANA_LOA_ACTIVATE_FLAG,
     &           IANA_ITYP             ,
     &           IANA_IS_SOLVING       ,
     &           IANA_SUB_DRIVER_ACT   ,
     &           IANA_NROF             ,
     &           IANA_PROCESS_NEXT     ,
     &           IANA_PROCESS_PREV     ,
     &           IANA_MAX_GLO_DOF_PATTERN,
     &           IANA_CORROTATIONS_ACTIVE,
     &           IANA_UPDATE_COORD_ACTIVE,
     &           IANA_ITER_NR_EX       ,
     &           IANA_STABILITY_MODE,
     &           IANA_STABILITY_DIV_STEP,
     &           IANA_NONL_SOLVER_TYPE  ,
     &           IANA_KIN_LOADING_FLAG  ,
     &           IANA_LARGE_STRAINS_CONTINUUM

      parameter (
     &           IANA_STEP_NR         = 161,
     &           IANA_ITER_NR         = 162,
     &           IANA_PATTERN_TO_KEEP = 163,
     &           IANA_INS_APPROACH    = 164,
     &           IANA_COUNT_NR        = 165,
     &           IANA_DRIVER_ACT      = 166,
     &           IANA_PROCESS_ACT     = 166,! same as driver_act for back compatibility in user models	 
     &           IANA_CURR_MAX_ITER   = 167,
     &           IANA_LOA_ACTIVATE_FLAG=168,
     &           IANA_ITYP             =169,
     &           IANA_IS_SOLVING       =170,
     &           IANA_SUB_DRIVER_ACT   =171,
     &           IANA_NROF             =172,
     &           IANA_PROCESS_NEXT     =173,
     &           IANA_PROCESS_PREV     =174,
     &           IANA_MAX_GLO_DOF_PATTERN = 175,
     &           IANA_CORROTATIONS_ACTIVE=176,
     &           IANA_UPDATE_COORD_ACTIVE=177,
     &           IANA_ITER_NR_EX       =178,
     &           IANA_STABILITY_MODE   =179,
     &           IANA_STABILITY_DIV_STEP=180,
     &           IANA_NONL_SOLVER_TYPE =181,
     &           IANA_KIN_LOADING_FLAG = 182,
     &           IANA_LARGE_STRAINS_CONTINUUM = 183 )

      ! computational mode
      ! to be set to enforce elastic constitutive behavior for inelastic models
      ! (stress state will stay in the trial stress state for instance)

      integer*4, parameter :: IANA_ELASTIC_COMP_MODE  = 1
      integer*4, parameter :: IANA_STANDARD_COMP_MODE = 2


      integer*4,parameter:: IANA_LOA_ACTIVATE_TYPICAL      = 1,
     &                      IANA_LOA_ACTIVATE_EXCAVATION   = 2, 
     &                      IANA_LOA_ACTIVATE_PREVIOUSSTEP = 2  ! identical as IANA_LOA_ACTIVATE_EXCAVATION
                                                                ! for better clearity  

!MS$DEFINE __ANAL_ENU_INC
!MS$ENDIF
