!MS$IF DEFINED (__BEAM_INC)
!MS$ELSE
      include 'maxlay.inc'


      integer*4,parameter::
     &           IBEA_MAX_NODES   = 3, ! L3
     &           IBEA_REL_MAX     = 2, ! relaxations only on both ends
     &           IBEA_TOT_NDISP   = 6, ! total D.O.F. nr (u,v,w,rx,ry,rz)
     &           IBEA_MAX_STRESS  = 12, ! total (output) stress size
     &           IBEA_MAX_OUT     = 5 , ! max nr. of output points
     &           IBEA_MAX_POINT_LONG=5,! max nr of longitudal integ.point 
     &           IBEA_MAX_LAY_RES   =7 ! for axisymmetry: 1+2+2+1+1=7, 3D: 2+1+1+1+1=5

      real*8,parameter :: BEA_AXI_EPS_RADIUS = 1.0d-8 ! minimum acceptable radius
      real*8,parameter :: BEA_SHEAR_PENALTY = 1.0d2

      integer*4 ,parameter ::
     &           IBEA_GPGEO_SHORT=1,
     &           IBEA_GPGEO_FULL =2
     

      ! nr of integration p. in cross  section
      integer*4, parameter :: IBEA_NLAYER_BEND = 1,   
     &                        IBEA_NLAYER_SHEA = 1   

      ! position of absolute/local/global flag in GRAVITY load record
      integer*4, parameter :: IBEA_GRAV_LOAD_FLAG = 4,
     &                        IBEA_LOAD_GLO       = 1, ! load given as global
     &                        IBEA_LOAD_LOC       = 2  ! load given as element local

	  integer*4, parameter :: IBEA_CURRENT_SETTING  = 0,
     &                        IBEA_WHOLEJOB_SETTING = 1

      ! for layered BEAM elements
      integer*4, parameter ::
     &  IBEA_MAX_LAYER_NUM = MAX_LAYER_NUM, ! max. number of layers 
          ! position in main property recods:
     &  IBEA_MAIN_NLAYER  =1,    ! of actual  number of layers
          ! position in geom property recods:
     &  IBEA_GEOM_Y      =1,     ! of int. point Y local coordinate
     &  IBEA_GEOM_Z      =2,     ! of int. point Z local coordinate
     &  IBEA_GEOM_AREAYZ =3,     ! of int. point area
     &  IBEA_GEOM_MATNR  =4,     ! of int. point material number
     &  IBEA_GEOM_DENSTOT=5,     ! 
     &  IBEA_GEOM_PRESTRESS = 6,
     &  IBEA_GEOM_INFOSIZE = 6 

      integer*4, parameter :: IBEA_CS_MAX_INTPOINT =
     &                 IBEA_MAX_LAYER_NUM + IBEA_NLAYER_SHEA + 1 ! plus 1 for padding

      integer*4, parameter :: IBEA_MAX_INTPOINT= 2*IBEA_CS_MAX_INTPOINT

      integer*4, parameter ::LR_BEA= -IBEA_GEOM_INFOSIZE  ! minus means dynamic size
                                                          ! of data in group
      integer*4, parameter :: 
     &           NL_BEA= IBEA_GEOM_INFOSIZE*IBEA_MAX_LAYER_NUM-2*LR_BEA
                           ! as LR_BE is negative this is used to reserve
                           ! space for 2 additional records for
                           ! areas and inertia moments

      integer*4, parameter :: IBEA_GEOM_AX = 1
      integer*4, parameter :: IBEA_GEOM_AY = 2
      integer*4, parameter :: IBEA_GEOM_AZ = 3
      integer*4, parameter :: IBEA_GEOM_DIST=4
c empty position to align record size to IBEA_GEOM_INFO_SIZE
      integer*4, parameter :: IBEA_GEOM_IX = 7
      integer*4, parameter :: IBEA_GEOM_IY = 8
      integer*4, parameter :: IBEA_GEOM_IZ = 9
      integer*4, parameter :: IBEA_GEOM_H  = 10

c suplementary models ids for internal use in beams,
c see blockdata prop.for:

      integer*4 , parameter :: IBEA_MODEL_QY     = 20,  ! 2 D shear
     &                         IBEA_MODEL_QYQZMX = 21,  ! 3 D shear+torsion
     &                         IBEA_MODEL_NXMZ   = 22,  ! 2 D bending+normal
     &                         IBEA_MODEL_NXMYMZ = 23   ! 3 D bending+normal

c id of used Bmatrix routine
      integer*4, parameter :: IBEA_B_QY     = 1,  ! 2 D shear
     &                        IBEA_B_QYQZMX = 2,  ! 3 D shear+torsion
     &                        IBEA_B_NXMZ   = 3,  ! 2 D bending+normal
     &                        IBEA_B_NXMYMZ = 4,  ! 3 D bending+normal
     &                        IBEA_B_2DSX   = 5,  ! 2D normal stress
     &                        IBEA_B_3DSX   = 6,  ! 3D normal stress
     &                        IBEA_B_25DSXSZSXZ =  7, ! 2.5D , {SxLSxL,Szz,SxLz} shell type
     &                        IBEA_B_AXI_QY     =  8, ! uncoupled transversal shear
     &                        IBEA_B_AXI_SXSY   =  9, ! stress in layer
     &                        IBEA_B_AXI_NXMZSY = 10,
     &                        IBEA_B_AXI_SY     = 11 !  circumferential stress in

      enum, bind(C)
      enumerator::
c    &   BEA_GP_ptr = 1,
     &   BEA_strNew_ptr=1,
     &   BEA_strOld_ptr,
     &   BEA_enum_max = BEA_strOld_ptr
      end enum


      type BEA_cross_section_type
        SEQUENCE
        integer*4 :: models    (IBEA_CS_MAX_INTPOINT) = 0 ! mat.model id for layer/process
        integer*4 :: mats      (IBEA_CS_MAX_INTPOINT) = 0 ! mat. nr  for layer/process
        integer*4 :: mat_ptrs  (IBEA_CS_MAX_INTPOINT) = 0 ! mat. pointer for layer/process
        integer*4 :: pos       (IBEA_CS_MAX_INTPOINT) = 0 ! positions of layer g. data
        integer*4 :: iform     (IBEA_CS_MAX_INTPOINT) = 0
        real*8    :: TotalArea = 0.0d0 ! total cross-sectional area
        integer*4 :: nstre     (IBEA_CS_MAX_INTPOINT) = 0 ! nr of generalized stress comp.
        integer*4 :: IdBmat    (IBEA_CS_MAX_INTPOINT) = 0 ! B-matrix ID
        integer*4 :: IDensTot  (IBEA_CS_MAX_INTPOINT) = 0  ! flag if area is total(0) or density(1) 
        integer*4 :: padding(16)
      end type BEA_cross_section_type

      type BEA_aux_objs_type
        SEQUENCE
        real*8 :: xc   (3*IBEA_MAX_NODES) = 0.0d0 ! nodal coordinates of central p.
        real*8 :: dir  (3,IBEA_MAX_NODES) = 0.0d0 ! nodal XZ plane direction vectors
        real*8 :: dx   (3*IBEA_MAX_NODES) = 0.0d0 ! nodal offsets
        ! longitudal GP data: ( valid for the whole section)
        real*8 :: q (3,3) = 0.0d0      ! current long. GP base
        real*8 :: dq(3,3) = 0.0d0      ! current long. GP base deriv
        reaL*8 :: q_t(3,3)= 0.0d0      ! current long. GP base transposed
        real*8 :: dq_t(3,3) = 0.0d0      ! current long. GP base deriv transposed
c        real*8 :: Dx0Dxsi(3)    ! current GP tangent vect. at (0,0) layer
c        real*8 :: XLJ0          ! current GP Longitudal jacobian at (0,0)
        real*8 :: xgp_c (3) = 0.0d0

        ! current layer data:

        real*8 :: dxi_dx_l    = 0.0d0    ! current GP dxsi/dxL operator
        real*8 :: dx_dxi_l(3) = 0.0d0    ! current GP/layer tangent vect. at (0,0) layer
        real*8 :: J_l         = 0.0d0    ! current GP/layer Longitudal jacobian
        real*8 :: ro_l (3)    = 0.0d0    ! current GP/layer local position vector
        real*8 :: dro_dxi_l(3)= 0.0d0    ! current GP/layer local position derivative
        real*8 :: r           = 0.0d0    ! current GP radius (for AXISYM only) at centroid axis
        real*8 :: r_l         = 0.0d0    ! current GP/layer radius (for AXISYM only) 
        real*8 :: xgp_l (3)   = 0.0d0    ! current GP/layer global coord.

        real*8 :: dist        = 0.0d0    ! distance for Planestrain & 2.5 D 
        integer*4 :: Ndisp    = 0        ! current nr of displacement component
        integer*4 :: nint_cross = 0      ! nr of intpoints / process on cross section
        real*8    :: YZ (2)     = 0.0d0  ! cross sect.layer position
        real*8    :: Area       = 0.0d0  ! cross sect.layer area
        real*8    :: TotalArea  = 0.0d0  ! total cross-sectional area
        real*8    :: Prestress  = 0.0d0   
      end type BEA_aux_objs_type


!MS$DEFINE __BEAM_INC
!MS$ENDIF      