!MS$IF DEFINED (__CONTACT_INC)
!MS$ELSE

      integer*4, parameter :: IELE_CNT_MAX_NODES=8

      integer*4, parameter :: iEhMIN_CNT    = 1,
     &                        ikhMIN_CNT    = 2,
     &                        ilhMIN_CNT    = 3,
     &                        PENALTY_LAST_CNT  = 3 

      integer*4,parameter :: iLTime_ADD_INFO_PTR_CNT     =  1, ! time at which the add info was set
     &                       iEhMIN_ADD_INFO_PTR_CNT     =  3, ! E * h
     &                       ikhMIN_ADD_INFO_PTR_CNT     =  5, ! k * h ( for flow )
     &                       ilhMIN_ADD_INFO_PTR_CNT     =  7, ! lambda * h (for heat/humid)
     &                       iADjCon_ADD_INFO_PTR_CNT    = 15, ! adjacent continuum elements
     &                       iADjStr_ADD_INFO_PTR_CNT    = 17, ! adjacent continuum elements
c    &                       iCurrUnlF_ADD_INFO_PTR_CNT  = 19, ! curent unloading function that is inherited
     &                       itgPhi_ADD_INFO_PTR_CNT     = 19, ! 
     &                       itgPsi_ADD_INFO_PTR_CNT     = 21, ! 
     &                       iCoh_ADD_INFO_PTR_CNT       = 23, ! 
     &                       ift_ADD_INFO_PTR_CNT        = 25, ! 
     &                       ifc_ADD_INFO_PTR_CNT        = 27, ! 
     &                       i_kn_Amplification_CNT      = 29, ! 
     &                       iNodVN_ADD_INFO_PTR_CNT     =     ! nodal normals after smoothing
     &                                    29 + 2 * IELE_CNT_MAX_NODES 
c     &                       IADD_INFO_SIZE_CNT2=iNodVN_ADD_INFO_PTR_CNT
c     &                                    + 2 * 3 * IELE_CNT_MAX_NODES-1 

      type CNT_add_info_struct_type
      sequence
      real*8 :: estimation_time
      real*8 :: penalties (PENALTY_LAST_CNT,2)
      integer*4 :: adj_contin_ele (2)
      integer*4 :: adj_struct_ele (2)
      real*8    :: tgphi
      real*8    :: tgpsi
      real*8    :: cohesion
      real*8    :: ft
      real*8    :: fc
      real*8    :: kn_ampl_facs (IELE_CNT_MAX_NODES)
      real*8    :: vn_nodal (3,IELE_CNT_MAX_NODES)
      integer*4 :: padding (4)
      end type CNT_add_info_struct_type

      integer*4, parameter :: CNT_add_info_struct_size_int4 = 
     &                        1 * 2 + 
     &                        2 * PENALTY_LAST_CNT * 2 +
     &                        2 +
     &                        2 +
     &                        5 * 2 + 
     &                        IELE_CNT_MAX_NODES * 2 +
     &                        IELE_CNT_MAX_NODES * 3 * 2

      integer*4, parameter :: ICNT_TYPE_STD_INTERFACE  = 0
      integer*4, parameter :: ICNT_TYPE_BOND_INTERFACE = 1
      integer*4, parameter :: ICNT_TYPE_FTFC_INTERFACE = 2
c17.01.2010
      integer*4, parameter :: ICNT_TYPE_BOND_EX_INTERFACE = 3

      integer*4, parameter :: ICNT_ELE_STD_INTERFACE  = 1
      integer*4, parameter :: ICNT_ELE_BOND_INTERFACE = 2
      integer*4, parameter :: ICNT_ELE_NNP_INTERFACE  = 3 ! node-node foot pile interface

c      real*8 INIT_OPENING_CNT
c      parameter ( INIT_OPENING_CNT = 0.05d0 )

      integer*4 , parameter :: ICNT_STRESS =3 
      integer*4 , parameter :: ICNT_MAX_BINELE_ITEM=4     ! nr of items in binary element
                                                          ! result record

      integer*4 , parameter :: ICNT_AUG_LAGR_ADD_MODE_NULL   = 0,
     &                         ICNT_AUG_LAGR_ADD_MODE_INIT   = 1,
     &                         ICNT_AUG_LAGR_ADD_MODE_UPDATE = 2 

      integer*4 
     &           ICNT_NrOfStressComp
        

      real*8     
     &           AllowMaxOverpenetration_CNT,
     &           AugLagrStiffMult_CNT,
     &           AugLagrMaxValueForStiffMult_CNT,
C     &           ActMaxOverpenetration_CNT,
     &           MinCosBetweenNormalsForSmoothing_CNT

      integer*4 
     &           AugLagrangeActive_CNT,
     &           AugLagrangeStep_CNT,
     &           MaxAugLagrangeSteps_CNT,
     &           AugLagrangeAddMode_CNT,
     &           ViscoPlasticRegActive_CNT,
     &           iterShiftForViscoPlasticReg_CNT,
     &           AugLagrExtendedFlag_CNT

      integer*4  CntInterfaceVspDampingFlag_CNT,
     &           i_1DInterfaceVspDampingFlag_CNT
      real*8     CntInterfaceDampingExp_CNT,
     &           C1DInterfaceDampingExp_CNT


      integer*4 :: 
     &             iContinuityMode_CNT
c    &             rsl_cfg_ctrl_CNT

      type CNT_trace_type
        SEQUENCE
        integer*4 :: GapStickRegisterFlag
        integer*4 :: GapStdRegisterFlag
        real*8    :: MaxStickGapN
        real*8    :: MaxStickGapT
        real*8    :: MaxGapN
        real*8    :: MaxGapT
        real*8    :: ActMaxOverpenetration
        integer*4 :: padding (4)
      end type CNT_trace_type

       
      type (CNT_trace_type) :: global_trace_info_CNT 
      integer*4 :: paddingb1_CNT, paddinge1_CNT

      common /CNT_/ 
     &           ICNT_NrOfStressComp(5), ! =  JOB_MAXTYP
     &           AllowMaxOverpenetration_CNT,
c     &           ActMaxOverpenetration_CNT,
     &           AugLagrStiffMult_CNT,
     &           AugLagrMaxValueForStiffMult_CNT,
     &           AugLagrangeActive_CNT,
     &           AugLagrangeStep_CNT,
     &           MaxAugLagrangeSteps_CNT,
     &           AugLagrangeAddMode_CNT,
     &           ViscoPlasticRegActive_CNT,
     &           iterShiftForViscoPlasticReg_CNT,
     &           MinCosBetweenNormalsForSmoothing_CNT,
     &           CntInterfaceVspDampingFlag_CNT,
     &           i_1DInterfaceVspDampingFlag_CNT,
     &           CntInterfaceDampingExp_CNT,
     &           C1DInterfaceDampingExp_CNT,
     &           iContinuityMode_CNT,
     &           AugLagrExtendedFlag_CNT,
c    &           rsl_cfg_ctrl_CNT,
     &           global_trace_info_CNT,
     &           paddinge1_CNT(3)

      save /CNT_/

      ! data order in NONL part of property record

      integer*4, parameter ::
     &           ICNT_PHI   = 1,!  friction angle
     &           ICNT_PSI   = 2,!  dilatancy angle
     &           ICNT_COH   = 3,!  cohesion or shear ultimate stress for nails/anchor heads
     &           ICNT_TYPE  = 4,! 0 - std contact 1 - bond reinforcement 2-node-node ft/fc interface 3-nail/anchor head interface
cAT 18.08.2008
     &           ICNT_EFFS_MODE    = 5, ! 0 - do not handle that 1 - handle eff. stress for impermeable material
     &           ICNT_INHERIT_FLAG = 6, ! 0 - do not inherit 1 - inherit
     &           ICNT_FT = 7,
     &           ICNT_FC = 8,
     &           ICNT_DIAMETER = 7 ! for nails and for anchor heads overlaps with ft DATA

c data order in ELAS part of property record
      integer*4, parameter :: ICNT_KNMULT = 1, !  normal  penalty stiffness multiplier
     &                        ICNT_KTbyKN = 2, !  ks/kn ratio
     &                        ICNT_REAL_STIFF_FLAG = 3 ! flag if kn,kt/kn values are real ones

c data order in MAIN part of property record
      integer*4, parameter :: ICNT_MAIN_PROP_STICKING_FLAG = 1 ! full sticking / friction flag

      integer*4, parameter :: ICNT_STATUS_STICKING   = 0,
     &                        ICNT_STATUS_SLIDING    = 1,
     &                        ICNT_STATUS_SEPARATION = 2 


      integer*4, parameter :: ICNT_PROP_FLOW_FLAG_FULL_PEARM   = 0,
     &                        ICNT_PROP_FLOW_FLAG_ISOTROPIC    = 1,
     &                        ICNT_PROP_FLOW_FLAG_ANISOTROPIC  = 2 

cAT 19.11.2014
      integer*4, parameter :: ICNT_CONTINUITY_PENALTY   = 1
      integer*4, parameter :: ICNT_CONTINUITY_DOFS_RED  = 2

      enum, bind(C) 
      enumerator::    
     &        CNT_stress_nx1 = 1,
     &        CNT_stress_n ,
     &        CNT_plast_code_nx1,
     &        CNT_plast_code_n ,
     &        CNT_p_ex_nx1 ,
c    &        CNT_p_ex_n,
     &        CNT_strain_nx1,
     &        CNT_strain_n,
     &        CNT_gap,
     &        CNT_gap_pl_n,
     &        CNT_gap_pl_nx1,
     &        CNT_dLagrVal,
     &        CNT_LastAugStr,
     &        CNT_SigInitState, 
     &        CNT_Tau_nx1, 
     &        CNT_Tau_n,
     &        CNT_enum_max = CNT_Tau_n
      end enum



!MS$DEFINE __CONTACT_INC
!MS$ENDIF

