!MS$IF DEFINED (__ELEM_INC)
!MS$ELSE


      ! constant element info. local pointers

      integer*4,parameter ::
     &           IELE_TYPE           = 1,
     &           IELE_IMAT           = 2,
     &           IELE_LNODE          = 3,
     &           IELE_LOAD           = 4, !  for contact e. only
     &           IELE_SURF           = 4, ! use the same position
     &           IELE_RPOS           = 5, ! position in *.s0i file
     &           IELE_RLPOS          = 6, ! position in *.l0i file AU 09.09.1998
     &           IELE_ADDINFO        = 7, ! ptr to additional element data
     &           IELE_SL_ON_FACE     = 8, ! fla is faces are loaded AU_05.05.99 
     &           IELE_IMAT_PARENT    = 9, ! original material nr defined in .dat
     &           IELE_IS_FLOATING    =10, ! flag for cnt/nscnt/seep/convection whether they are attached to anything
     &           IELE_WAS_FLOATING   =11, ! flag for cnt/nscnt/seep/convection whether they are attached to anything
     &           IELE_IS_IN_DRM_BZONE=12, ! flag whether the element(continuum only) is the transition DRM (dynamics) zone
     &           IELE_UNUSED_1       =13,
     &           IELE_UNUSED_2       =14,
     &           IELE_UNUSED_3       =15,
     &           IELE_UNUSED_4       =16,
     &           IELE_CONST_INFO_SIZE=16  ! just for 64 byte cacheline                       

      integer*4, parameter :: IELE_FLOAT_UNDEF = 0,
     &                        IELE_FLOAT_TRUE  = 1,
     &                        IELE_FLOAT_FALSE = 2

      ! element general class formulation types to set stress /strain
      ! component numbers


      integer*4,parameter ::
     &           IELE_FORM_UNCHANGED =0, !like general analysis type for
                                         !continual elements
     &           IELE_FORM_1D = 1,       !beams & trusses
     &           IELE_FORM_PLSTRAIN=2,
     &           IELE_FORM_PLSTRESS=3,
     &           IELE_FORM_AXISYMM =4,
     &           IELE_FORM_3D      =5,
     &           IELE_FORM_SHELL   =6,      !
     &           IELE_FORM_SHELL_5 =7,      !
     &           IELE_FORM_AXIBEAM =8       !



      integer*4, parameter::IELE_MAX_NODES               = 21
      integer*4, parameter::IELE_NR_OF_IMPLEMENTED_TYPES = 116

      ! element processing orders

      integer*4,parameter::
     &            IELE_STIFF        =    1,
     &            IELE_FORCE        =    2,
     &            IELE_SETLOAD      =    4,
     &            IELE_UPDSTATUS    =    8,
     &            IELE_INITBUFF     =   16,

     &            IELE_GP_SIZE      =   32,
     &            IELE_TOT_SIZE     =   64,
     &            IELE_EXC_FORC     =  128,
     &            IELE_PRINTSTR     =  256,
     &            IELE_GETBINRESULT =  512,

     &            IELE_GETNOUT      = 1024,
     &            IELE_ADD_SIZE     = 2048,
     &            IELE_ADD_FILL     = 4096,
     &            IELE_SETDOFCODE   = 8192,
     &            IELE_ESTIMATE_SIG0   =  16384,

     &            IELE_IS_LAY_STORAGE  =  32768,  ! AU_9.09.1998
     &            IELE_GET_LAY_STORAGE =  65536,  ! AU_9.09.1998           
     &            IELE_GRAV_CENTRE     = 131072,  ! AU_07.05.1999    
     &            IELE_COMPATIBLE_EQ   = 262144,       
     &            IELE_PROJECT_DATA    = 524288,  ! AT 16.01.200

     &            IELE_TRANS_DISP      =1048576,  ! AU_21.01.2001         
     &            IELE_MASS            =2097152,  ! AU_07.01.2005
     &            IELE_INERT_FORC      =4194304,  ! AU_07.01.2005
     &            IELE_DAMP            =8388608,  ! AU_07.01.2005  
     &            IELE_DAMP_FORC       =16777216, ! AU_07.01.2005
     &            IELE_CONSTRUCTION_SIG0=33554432,! AT 21-03-2005
c    &            IELE_RESET_ITER      = 67108864,! AT 18.01.2011
     &            IELE_REGISTER_SIG_K0 = 67108864,
     &            IELE_VERIFY_DISTORSION=134217728, !AT 20.06.2017
     &            IELE_SET_BAROTROPY   = 268435456, !AT 14.08.2019
     &            IELE_NR_OF_ORDERS    =     29   ! update while adding  ! AU_07.01.2005
 
      ! principal element classes

      integer*4,parameter::
     &           IELE_GR_VOLUM = 1, ! volumics in 2&3D
     &           IELE_GR_SHELL = 2, ! shells
     &           IELE_GR_TRUSS = 3, !rods without rotational D.O.F (2&3D)
     &           IELE_GR_BEAMS = 4, !rods with rotational D.O.F (2&3D)
     &           IELE_GR_DSC   = 5, !penalty node to node element  !AU111198 
     &           IELE_GR_SURF  = 6, !surface elements
     &           IELE_GR_CNTC  = 7, !contact elements
     &           IELE_GR_SEEP  = 8, !contact lements-seepage surface
     &           IELE_GR_CONV  = 9, !surface elements-convective surface
     &           IELE_GR_FLVOL =10, !fluid volumics
     &           IELE_GR__VOL  =11, !negative stiffness volumics in 2&3D
     &           IELE_GR_PVOL  =12, !penalty volumics in 2&3D

c     &           IELE_GR_WOLF  =13, !single infinite of WOLF type
c     &           IELE_GR_BOUND =14, !superelements of  WOLF type

     &           IELE_GR_INFINITE  = 14,
     &           IELE_GR_MEMB      = 15,  ! membrane
     &           IELE_GR_RING      = 16,  ! ring (axisymmetry only)
     &           IELE_GR_NSCNT     = 17,  ! node-segment contact large deformation
     &           IELE_GR_MASS      = 18,  ! pure mass  ! AU_07.01.2005
     &           IELE_GR_VISC_DAMP = 19,  ! viscous dampers
     &           IELE_GR_MESH_TYING= 20,  ! mesh tying via mortar method
     &           IELE_GR_LIN_HING  = 21,  ! linear hinges
     &           IELE_GR_HEXCH     = 22,  ! heat exchangers 1D in 3D
     &           IELE_GR_MAXNR     = 22 


      ! formulation types for elements (enums designed for bit coding)
      integer*4,parameter :: 
     &            IELE_FORM_NULL    = 0,
     &            IELE_STANDARD_U   = 1,
     &            IELE_MIXED_EAS    = 2,
     &            IELE_MIXED_UP     = 4 

      ! binary flags anabling enhancemets for different element types
      integer*4,parameter ::
     &            IELE_B_STANDARD = 0,
     &            IELE_BBAR_MEAN  = 1,
     &            IELE_BBAR_ASS   = 2 

      ! modes of evaluation of element nodes number and array
      ! in functions IELE_NodesGet


      integer*4,parameter :: 
     &           IELE_ALLINIT = 1,! initial nr of nodes, size of node storage
                                  ! for element geometry
                                  ! AT comment !!!!
                                  ! all nodes those for RENUM+SETEQNRS
                                  ! and geometrical ones (which do not have
                                  ! active d.o.f.)
     &           IELE_CONECTED= 2,! all nodes wchich describe conectivity
                                  ! to be used in RENUM, SETEQNRS
     &           IELE_MASTER  = 4,! all nodes for which D.O.F s are attached
                                  ! to be use in  AGREG
                                  ! NOTE for SHELLs CONECTED != MASTER
     &           IELE_FICTIOUS =8,! fictitious nodes for Lagrange multipliers for instance
     &           IELE_DISPATCH =16 ! nodes which are dependent on others without merging duplicated after dispatching
c    &           IELE_DISPATCH_MERGE =32! as above but with merging


      character *5   ELE_TypeCharIdArray (IELE_NR_OF_IMPLEMENTED_TYPES)
      character *10  ELE_GrName          (IELE_GR_MAXNR )

      integer*4 IConsPtr_ELE,
     &          NrOf_ELE,    
     &          MaxNenAct_ELE,
     &          NewSeq_Gptr_ELE, 
     &          NewNrs_Gptr_ELE,
     &          IELE_NrOfEleNodes,
     &          IELE_DofPatternCode,
     &          IELE_BBarPossible,
     &          IELE_FluidPossible    ,
     &          IELE_SolidPossible    ,
     &          IELE_PUM_Possible     ,
     &          IELE_HeatHumidPossible,
     &          IELE_Group            ,
     &          IELE_AddInfoSize      ,
     &          IELE_Formulation      ,
     &          IELE_NrInType         ,
     &          IELE_SlaveMasterKinDOF,
     &          IELE_TypOfFaces       ,
     &          inullxx,
     &          IELE_GroupLayPos      ,
     &          IELE_NrInGroup        ,
     &          IELE_BinResRecNrInGroup,
     &          IELE_LayeredActive     ,
     &          IELE_BinResRecNrInGroupLay

      integer*4 :: paddingb_ELE, paddinge_ELE

      common / ELE_common / 
     &        paddingb_ELE(32),  
     &        IConsPtr_ELE,!start ptr. to constant e.memory
     &        NrOf_ELE,    ! total nr of elements in the job
     &        MaxNenAct_ELE,! max. Nen
     &        NewSeq_Gptr_ELE, ! oldele = array [newele]
     &        NewNrs_Gptr_ELE, ! newele = array [oldele]
     &        IELE_NrOfEleNodes     (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_DofPatternCode   (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_BBarPossible     (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_FluidPossible    (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_SolidPossible    (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_PUM_Possible     (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_HeatHumidPossible(IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_Group            (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_AddInfoSize      (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_Formulation      (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_NrInType         (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_SlaveMasterKinDOF(IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_TypOfFaces       (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        inullxx,
c    &         ELE_CnsStabFactors   (IELE_NR_OF_IMPLEMENTED_TYPES),
     &        IELE_GroupLayPos        (IELE_GR_MAXNR ), 
     &        IELE_NrInGroup          (IELE_GR_MAXNR ),
     &        IELE_BinResRecNrInGroup (IELE_GR_MAXNR ),
     &        IELE_LayeredActive         (IELE_GR_MAXNR ), 
     &        IELE_BinResRecNrInGroupLay (IELE_GR_MAXNR ),
     &        ELE_GrName                ,
     &        ELE_TypeCharIdArray,
     &        paddinge_ELE(32) 

      save /ELE_common/




!MS$DEFINE __ELEM_INC
!MS$ENDIF