!MS$IF DEFINED (__HEAT_INC)
!MS$ELSE

      include 'elem.inc'
      include 'qs.inc'

      integer*4,parameter :: IHEA_MAX_NODES = IELE_MAX_NODES  ! increase if necessary
                                        ! this max nr nodes is
                                        ! max ( GR_VOLUM,GR_CNTC,GR_CONV,
                                        !       GR__VOL  )

      ! heat parameters for volumics


      integer*4, parameter :: IPRO_HEAT_LAMBDA   =  2,
     &                        IPRO_HEAT_CAPACITY =  3,
     &                        IPRO_HEAT_SOURCE   =  4,
     &                        IPRO_HEAT_Hinf     =  5,
     &                        IPRO_HEAT_a        =  6,
     &                        IPRO_HEAT_td       =  7,
     &                        IPRO_HEAT_QbyR     =  8,
     &                        IPRO_HEAT_Tf       =  9,
     &                        IPRO_HEAT_DILATANCY_F = 10,
     &                        IPRO_HEAT_b        = 11,
     &                        IPRO_HEAT_ADVECTION_FLAG = 12,
     &                        IPRO_HEAT_LAMBDA_FLUID   = 13,             
     &                        IPRO_HEAT_CAPACITY_FLUID = 14,
     &                        IPRO_HEAT_MAX      = 14

c      integer*4, parameter :: IPRO_HEAT_LAMBDA   =  3,
c     &                        IPRO_HEAT_CAPACITY =  4,
c     &                        IPRO_HEAT_SOURCE   =  5,
c     &                        IPRO_HEAT_Hinf     =  6,
c     &                        IPRO_HEAT_a        =  7,
c     &                        IPRO_HEAT_td       =  8,
c     &                        IPRO_HEAT_QbyR     =  9,
c     &                        IPRO_HEAT_Tf       = 10
cc 11-th position is reserved for alphaFT - source term due to fluid dilatancy change
c      integer*4, parameter :: IPRO_HEAT_MAX      = 10

      integer*4, parameter :: IPRO_HEAT_DILATANCY=  1
c    &                        IPRO_HEAT_FIRE_MODEL= 2

      ! humidity parameters for volumics
      integer*4, parameter :: IPRO_HUMI_aD       =  2,
     &                        IPRO_HUMI_wL       =  3,
     &                        IPRO_HUMI_DL       =  4,
     &                        IPRO_HUMI_KAPPA    =  5,
     &                        IPRO_HUMI_DILATANCY=  1
      integer*4, parameter :: IPRO_HUMI_MAX      =  5

      ! heat     parameters for convection surface
      integer*4, parameter :: IPRO_HEAT_hCONVEC  =  1 

      ! heat     parameters for radiation surface 
      integer*4, parameter :: IPRO_HEAT_RAD_CFG_FACTOR = 1 
      integer*4, parameter :: IPRO_HEAT_RAD_EMISS_MEMB = 2 
      integer*4, parameter :: IPRO_HEAT_RAD_EMISS_FIRE = 3
      integer*4, parameter :: IPRO_HEAT_RAD_BOLTZ_CONS = 4


      ! humidity parameters for convection surface
      integer*4, parameter :: IPRO_HUMI_hCONVEC  =  1 

      ! heat     parameters for interface elements
      integer*4, parameter :: IPRO_HEAT_CNT_PENAL=  1 

      ! humidity parameters for interface elements
      integer*4, parameter :: IPRO_HUMI_CNT_PENAL=  1

      integer*4, parameter :: IHEA_BC_CONVECTION = 1
      integer*4, parameter :: IHEA_BC_RADIATION  = 2

      ! parameters for heat exchangers
      integer*4, parameter :: IPRO_HEXCH_LAMBDA_L   =  2,
     &                        IPRO_HEXCH_CAPACITY_L =  3,
     &                        IPRO_HEXCH_VELOCITY_L =  4,
     &                        IPRO_HEXCH_CONVECTION =  5,
     &                        IPRO_HEXCH_PIPE_DIAMETER = 6,
     &                        IPRO_HEXCH_MAX        = 6


c      integer*4, parameter :: IHUM_STOR_MAX      =  2 ! store 2 doubles for 1 g.p.
c                                                      ! Mn,Mnx1
c      integer*4, parameter :: IHEA_STOR_MAX      =  4 ! store 4 doubles for 1 g.p.
c                                                      ! Mn,Mnx1,dMdTn,dMdTnx1

c      integer*4, parameter :: L_HEAT = 1, 
c     &                        L_HUMI = 2, 
c     &                        L_HMAX = L_HUMI 

c      integer*4, parameter :: MAX_STOR_DESCR = 50

      real*8                 alpha_thermal_HEA,
     &                       alpha_hygral_HEA,
c    &                       Alpha_HEA,
     &                       PenaltyMultPVol_HEA,
     &                       TimeAtLHSdtSetting_HEA, ! time at which was taken decision
c                                                    ! which value of dt to take into
c                                                    ! current LHS
     &                       dtInCurrLHS_HEA

      integer*4 :: paddingb_HEA, paddinge_HEA
      common /heatx/         
     &                       alpha_thermal_HEA,
     &                       alpha_hygral_HEA,
     &                       PenaltyMultPVol_HEA,
     &                       TimeAtLHSdtSetting_HEA, ! time at which was taken decision
                                                    ! which value of dt to take into
                                                    ! current LHS
     &                       dtInCurrLHS_HEA,
     &                       paddinge_HEA(6)

      save /heatx/

      enum, bind(C) 
      enumerator::    
     &        HEA_maturity_n = 1,
     &        HEA_maturity_nx1,
     &        HEA_d_maturity_dT_n,
     &        HEA_d_maturity_dT_nx1,
     &        HEA_enum_max = HEA_d_maturity_dT_nx1
      end enum

       integer*4, parameter :: max_K_dim  = IHEA_MAX_NODES * 
     &                                      IHEA_MAX_NODES 
       integer*4, parameter :: max_C_dim  = 
     &                                      IHEA_MAX_NODES * 
     &                                      IHEA_MAX_NODES
       integer*4, parameter :: max_Hx_dim = max_C_dim

       type HEA_FIELD_type
         SEQUENCE
         real*8 :: begin_material_time ! time of first existance of material
         real*8 :: A_nx1    (IHEA_MAX_NODES) ! T   at t_N+1
         real*8 :: A_n      (IHEA_MAX_NODES) ! T   at t_N
         real*8 :: dA_nx1   (IHEA_MAX_NODES) ! dT  at last iteration
         real*8 :: Aamb_nx1 (IHEA_MAX_NODES) ! ambient temp. at t_N+1
         real*8 :: Aamb_n   (IHEA_MAX_NODES) ! ambient temp. at t_N
         real*8 :: Av_nx1   (IHEA_MAX_NODES)
         real*8 :: T_for_hygral   (IHEA_MAX_NODES) ! only for humid analysis
         real*8 :: dT_for_hygral  (IHEA_MAX_NODES) ! only for humid analysis
         integer*4 :: data_def_thermal
         integer*4 :: data_def_hygral
         integer*4 :: pattern
         integer*4 :: padding1
         real*8 :: ke     ( max_K_dim  )
         real*8 :: ke_ex  ( max_K_dim  )
         real*8 :: ke_adv ( max_K_dim  )
         real*8 :: ce     ( max_C_dim  )
         real*8 :: he_ex  ( max_Hx_dim )
         real*8 :: T_gp   ( IQS_MAX_INTPOINT )
         real*8 :: Ta_gp  ( IQS_MAX_INTPOINT )
       end type HEA_FIELD_type


!MS$DEFINE __HEAT_INC
!MS$ENDIF