!MS$IF DEFINED (__PROP_INC)
!MS$ELSE

c     general material processing
c----------------------------------------------------------------------

      include 'elem.inc'


      integer*4   IPRO_FORM_LIN_ELAST    ,
     &            IPRO_FORM_HYPOELAST    ,
     &            IPRO_FORM_ELASTO_PLAST ,
     &            IPRO_FORM_AGING_CONCR  ,
     &            IPRO_FORM_VISCOPLASTIC_RELAXATION,
     &            IPRO_FORM_VISCOPLASTICITY,
     &            IPRO_FORM_HYPERELASTICITY,
     &            IPRO_FORM_PLASTIC_DAMAGE

      parameter ( IPRO_FORM_LIN_ELAST    = 1,
     &            IPRO_FORM_HYPOELAST    = 2,
     &            IPRO_FORM_ELASTO_PLAST = 3,
     &            IPRO_FORM_AGING_CONCR  = 4,
     &            IPRO_FORM_VISCOPLASTIC_RELAXATION = 5,
     &            IPRO_FORM_VISCOPLASTICITY         = 6,
     &            IPRO_FORM_HYPERELASTICITY         = 7,
     &            IPRO_FORM_PLASTIC_DAMAGE          = 8)

      ! array structure for description of elastic\elasto-plastic models

      integer*4   IPRO_FORMULATION ,
     &            IPRO_EP_MAX_MECH ,
     &            IPRO_EP_NR_HARD  ,
     &            IPRO_EP_ACT_MECH ,
     &            IPRO_DESCR_MAX   

      parameter ( IPRO_FORMULATION = 1,
     &            IPRO_EP_MAX_MECH = 2,
     &            IPRO_EP_NR_HARD  = 3,
     &            IPRO_EP_ACT_MECH = 4,
     &            IPRO_DESCR_MAX   = 4 )

      ! flags for fill algorithm
      ! during fill newly added continuum gets poisson=0.5 and psi=0.5
      ! later on it is switched to the original properties
      ! 
      integer*4, parameter :: IPRO_FILL_PROP_SET     = 1,
     &                        IPRO_FILL_PROP_RESTORE = 2


      ! additional treatment of material subgroups
      ! load time functions and data superelements
      integer*4, parameter :: IPRO_GR_LTF_DEF_BIT_CODE  = 1
      integer*4, parameter :: IPRO_GR_LREC_DEF_BIT_CODE = 2
cAT 3.05.2013      
      integer*4, parameter :: IPRO_GR_THM_DEF_BIT_CODE  = 4


c property group identyfiers:

      integer*4 
     &           IPRO_GR_MAIN    ,
     &           IPRO_GR_DENS    ,
     &           IPRO_GR_ELAS    ,
     &           IPRO_GR_GEOM    ,
     &           IPRO_GR_FLOW    ,
     &           IPRO_GR_CREEP   ,
     &           IPRO_GR_NONL    ,
     &           IPRO_GR_HEAT    ,
     &           IPRO_GR_HUMI    ,
     &           IPRO_GR_INIS    ,
     &           IPRO_GR_STAB    ,
     &           IPRO_GR_DAMP    ,
     &           IPRO_GR_DISC    ,
     &           IPRO_GR_MAXSIZE 

      parameter (
     &           IPRO_GR_MAIN    = 1,
     &           IPRO_GR_DENS    = 2,
     &           IPRO_GR_ELAS    = 3,
     &           IPRO_GR_GEOM    = 4,
     &           IPRO_GR_FLOW    = 5,
     &           IPRO_GR_CREEP   = 6,
     &           IPRO_GR_NONL    = 7,
     &           IPRO_GR_HEAT    = 8,
     &           IPRO_GR_HUMI    = 9,
     &           IPRO_GR_INIS    =10,
     &           IPRO_GR_STAB    =11,
     &           IPRO_GR_DAMP    =12,
     &           IPRO_GR_DISC    =13,
     &           IPRO_GR_MAXSIZE =14 )

c    constant material info. local pointers

      integer*4 
     &          IPRO_TYPE            ,
     &          IPRO_DATPTR          ,
     &          IPRO_ADDPTR          ,
     &          IPRO_EXF             ,
     &          IPRO_EXCUNLF         ,
     &          IPRO_MATNR_PREPRO    ,
     &          IPRO_PHASE           ,
     &          IPRO_MATNR           ,
     &          IPRO_LAYNR           ,
     &          IPRO_GR_FLAGS        ,
     &          IPRO_GR_LTF          ,
     &          IPRO_GR_LREC         ,
cAT 3.05.2013     
     &          IPRO_GR_THM          ,
     &          IPRO_CONST_INFO_SIZE 

      parameter(
     &          IPRO_TYPE            = 1, ! model ideftyfier
     &          IPRO_DATPTR          = 2, ! ptr to external data properties
     &          IPRO_ADDPTR          = 3, ! ptr to additional properties
     &          IPRO_EXF             = 4, ! nr of existence function
     &          IPRO_EXCUNLF         = 5, ! excavation unloading function nr
     &          IPRO_MATNR_PREPRO    = 6, ! flag if current material is multi phaze
     &          IPRO_PHASE           = 7, ! flag if current material is multi phaze
     &          IPRO_MATNR           = 8, ! index of material data set
     &          IPRO_LAYNR           = 9, ! layer number (overlayed meshes)
     &          IPRO_GR_FLAGS        = 9, ! position of property group activity flag
                               ! position of property group time variability flag:
     &          IPRO_GR_LTF          = IPRO_GR_FLAGS  + IPRO_GR_MAXSIZE,
     &          IPRO_GR_LREC         = IPRO_GR_LTF    + IPRO_GR_MAXSIZE,
cAT 3.05.2013     
     &          IPRO_GR_THM          = IPRO_GR_LREC   + IPRO_GR_MAXSIZE,
     &          IPRO_CONST_INFO_SIZE = IPRO_GR_THM    + IPRO_GR_MAXSIZE)


      integer*4  IPRO_MODEL_ID ,
     &           IPRO_MATERIAL ,
     &           IPRO_PARENT_MATERIAL,
     &           IPRO_DATA_GR_ACT,
     &           IPRO_EXTRA_LAST

      parameter( IPRO_MODEL_ID =  1, ! position of model idetyfier contained
     &           IPRO_MATERIAL =  2, ! in property record (additional)2
     &           IPRO_PARENT_MATERIAL = 3,
     &           IPRO_DATA_GR_ACT=IPRO_PARENT_MATERIAL, ! space for activity flags in prop record 
     &           IPRO_EXTRA_LAST=IPRO_DATA_GR_ACT+IPRO_GR_MAXSIZE)
                 !^^^  update while adding new extra information to properties array

c  common positions for all models
c  in group MAIN:

      integer*4 
     &          IPRO_MAIN_BBAR ,  
     &          IPRO_MAIN_INCO ,  
     &          IPRO_MAIN_NGEO ,  
     &          IPRO_MAIN_STAB1,  
     &          IPRO_MAIN_STAB2,  
     &          IPRO_MAIN_STCNS

      parameter(
     &          IPRO_MAIN_BBAR = 1,  ! Bbar flag
     &          IPRO_MAIN_INCO = 2,  ! incompressibility flag
     &          IPRO_MAIN_NGEO = 3,  ! nonlinear geometry flag
     &          IPRO_MAIN_STAB1= 4,  ! Huges-Franca stabilization delta 1
     &          IPRO_MAIN_STAB2= 5,  ! Huges-Franca stabilization delta 1
     &          IPRO_MAIN_STCNS= 6)  ! stabilization of continuity equation
                                     ! for consolidation

      integer*4  IPRO_MAIN_EAS  
      parameter (IPRO_MAIN_EAS  = 1)  ! EAS type of Q4/B8 element

c  in group DENS:

      integer*4,parameter::
     &          IPRO_DENS_SOLID = 1,    ! solid phase density
     &          IPRO_DENS_FLUID = 2,    ! fluid phase density
     &          IPRO_DENS_VOIDR = 3,    ! initial  void ratio
     &          IPRO_DENS_MASS  = 4     ! mass density

c  in group ELAS:

      integer*4 
     &          IPRO_ELAS_DAT_YOUNG  ,
     &          IPRO_ELAS_DAT_POISS  ,
     &          IPRO_ELAS_DAT_INHERIT  

      parameter(                       
     &          IPRO_ELAS_DAT_YOUNG  =1,
     &          IPRO_ELAS_DAT_POISS  =2,
     &          IPRO_ELAS_DAT_INHERIT=3)

c in group INIS

      integer*4 
     &          IPRO_INIS_KOX     ,
     &          IPRO_INIS_KOZ     ,
     &          IPRO_INIS_THETA   ,
     &          IPRO_INIS_ANISO_X ,
     &          IPRO_INIS_ANISO_Y ,
     &          IPRO_INIS_ANISO_Z ,
cAT 25.09.2016
     &          IPRO_INIS_AUTO_KO,
cAT 23.06.2023
     &          IPRO_INIS_AUTO_KO_LIM_FLAG


      parameter (
     &          IPRO_INIS_KOX     = 1,
     &          IPRO_INIS_KOZ     = 2,
     &          IPRO_INIS_THETA   = 3,
     &          IPRO_INIS_ANISO_X = 4,
     &          IPRO_INIS_ANISO_Y = 5,
     &          IPRO_INIS_ANISO_Z = 6,
cAT 25.09.2016
     &          IPRO_INIS_AUTO_KO = 7,
cAT 23.06.2023
     &          IPRO_INIS_AUTO_KO_LIM_FLAG = 8)


      integer*4 
     &          IPRO_ELAS_ADD_D_DONE  ,
     &          IPRO_ELAS_ADD_DMATR   ,
     &          IPRO_ELAS_ADD_C_DONE  ,
     &          IPRO_ELAS_ADD_CMATR   ,
     &          IPRO_ELAS_ADD_DINC_DONE,
     &          IPRO_ELAS_ADD_DINCMATR ,
     &          IPRO_ELAS_ADD_CINC_DONE,
     &          IPRO_ELAS_ADD_CINCMATR  

      parameter(                        ! in additional data record
     &          IPRO_ELAS_ADD_D_DONE  =     1,
     &          IPRO_ELAS_ADD_DMATR   =     2,
     &          IPRO_ELAS_ADD_C_DONE  =    38,
     &          IPRO_ELAS_ADD_CMATR   =    39,
     &          IPRO_ELAS_ADD_DINC_DONE =  75,
     &          IPRO_ELAS_ADD_DINCMATR  =  76,
     &          IPRO_ELAS_ADD_CINC_DONE = 112,
     &          IPRO_ELAS_ADD_CINCMATR  = 113 )

      real*8 PRO_POISS_LIMIT 
      parameter( PRO_POISS_LIMIT = 0.50d0 - 1.0d-6)


c   in group GEOM:

      integer*4 
     &          IPRO_GEOM_DAT_THICK ,
     &          IPRO_GEOM_DAT_AREA  ,
     &          IPRO_GEOM_DAT_BETA  

      parameter(                            ! in data
     &          IPRO_GEOM_DAT_THICK = 1,    ! for plane stress & shell
     &          IPRO_GEOM_DAT_AREA  = 1,    ! for truss & beam
     &          IPRO_GEOM_DAT_BETA  = 2   ) ! for beams & 2_5d truss

c   in group FLOW for volumics

      integer*4 
     &          IPRO_FLOW_KX        ,
     &          IPRO_FLOW_KY        ,
     &          IPRO_FLOW_KZ        ,
     &          IPRO_FLOW_THETA     ,
     &          IPRO_FLOW_ANISO_X   ,
     &          IPRO_FLOW_ANISO_Y   ,
     &          IPRO_FLOW_ANISO_Z   ,
     &          IPRO_FLOW_BULK_MOD  ,
     &          IPRO_FLOW_Sr        ,
     &          IPRO_FLOW_ALPHA     ,
     &          IPRO_FLOW_SKIP_GRAV ,  
     &          IPRO_FLOW_UNDR_FLAG ,
     &          IPRO_FLOW_UNDR_EPS  ,
     &          IPRO_FLOW_UNDR_PLIM ,     
     &          IPRO_FLOW_n,
     &          IPRO_FLOW_krf_type,
     &          IPRO_FLOW_use_Bishop_global_flag,
     &          IPRO_FLOW_Bishop_mode,
     &          IPRO_FLOW_use_K_air_flag,
     &          IPRO_FLOW_K_air,
     &          IPRO_FLOW_use_Biot_coeff_flag,
     &          IPRO_FLOW_Biot_Ks,
     &          IPRO_FLOW_Biot_enforced,
     &          IPRO_FLOW_MAX

      parameter(                        ! in data
     &          IPRO_FLOW_KX        = 1,
     &          IPRO_FLOW_KY        = 2,
     &          IPRO_FLOW_KZ        = 3,
     &          IPRO_FLOW_THETA     = 4,
     &          IPRO_FLOW_ANISO_X   = 5,
     &          IPRO_FLOW_ANISO_Y   = 6,
     &          IPRO_FLOW_ANISO_Z   = 7,
     &          IPRO_FLOW_BULK_MOD  = 8,
     &          IPRO_FLOW_Sr        = 9,
     &          IPRO_FLOW_ALPHA     =10,
     &          IPRO_FLOW_SKIP_GRAV =11,
     &          IPRO_FLOW_UNDR_FLAG =12,
     &          IPRO_FLOW_UNDR_EPS  =13,
     &          IPRO_FLOW_UNDR_PLIM =14,
     &          IPRO_FLOW_n         =15,
     &          IPRO_FLOW_krf_type  =16,
     &          IPRO_FLOW_use_Bishop_global_flag=17,
     &          IPRO_FLOW_Bishop_mode=18,
     &          IPRO_FLOW_use_K_air_flag =19,
     &          IPRO_FLOW_K_air     =20,
     &          IPRO_FLOW_use_Biot_coeff_flag=21,
     &          IPRO_FLOW_Biot_Ks   =22,
     &          IPRO_FLOW_Biot_enforced = 23, ! only trated for contact elements
     &          IPRO_FLOW_MAX       =23 )

c   in group FLOW for seepage surface
      integer*4, parameter :: IPRO_FLOW_KV = 1,
     &                        IPRO_FLOW_KV_DEF = 2

c   in group FLOW for contact (it should be overlapped with 
c                     enums for volumics )

      integer*4  IPRO_FLOW_FLAG       
      parameter( IPRO_FLOW_FLAG       =  4) 

c   in group CREEP for volumics

      integer*4 
     &          IPRO_CREEP_TYPE     ,
     &          IPRO_CREEP_VEXFNR   ,
     &          IPRO_CREEP_VAMPL    ,
     &          IPRO_CREEP_VRATE    ,
     &          IPRO_CREEP_DEXFNR   ,
     &          IPRO_CREEP_DAMPL    ,
     &          IPRO_CREEP_DRATE    ,
     &          IPRO_CREEP_ALPHA    ,
     &          IPRO_CREEP_KAPPA    ,
     &          IPRO_CREEP_SWELL_SIG0, 
     &          IPRO_CREEP_PNONL,
     &          IPRO_CREEP_SWELL_SIGC,
     &          IPRO_CREEP_SWELL_ALPHAS,
     &          IPRO_CREEP_SWELL_K0_REF,
     
     &          IPRO_CREEP_PERMAFROST_pL,
     &          IPRO_CREEP_PERMAFROST_C1,
     &          IPRO_CREEP_PERMAFROST_f1_FUN,

cAT 2.04.2015
     &          IPRO_CREEP_NORTON_SIG_REF,
     &          IPRO_CREEP_NORTON_SIG0_FLAG,
     &          IPRO_CREEP_NORTON_A1,
     &          IPRO_CREEP_NORTON_N1,
     &          IPRO_CREEP_NORTON_QREF_1,
     &          IPRO_CREEP_NORTON_A2,
     &          IPRO_CREEP_NORTON_N2,
     &          IPRO_CREEP_NORTON_QREF_2,

     &          IPRO_CREEP_AGINGC_A,
     &          IPRO_CREEP_AGINGC_B,
     &          IPRO_CREEP_AGINGC_AGING_FLAG,
     &          IPRO_CREEP_AGINGC_AGE_INIT,
     &          IPRO_CREEP_AGINGC_T_REF,
     &          IPRO_CREEP_AGINGC_Q_BY_R,
     &          IPRO_CREEP_AGINGC_S,
     &          IPRO_CREEP_AGINGC_T_28,
     &          IPRO_CREEP_AGINGC_EQ_TIME_FLAG,
     &          IPRO_CREEP_AGINGC_STIFF_POW,
     &          IPRO_CREEP_AGINGC_VISC_FLOW_FLAG,
     &          IPRO_CREEP_AGINGC_VISC_FLOW_Q4,
     &          IPRO_CREEP_AGINGC_VISC_FLOW_XI,
     &          IPRO_CREEP_AGINGC_N,

     &          IPRO_CREEP_C_SWELL_SIG_L,
     &          IPRO_CREEP_C_SWELL_EPS_RATE_MAX,

     &          IPRO_CREEP_FIRE_PHI

      parameter(                    
     &          IPRO_CREEP_TYPE     = 1,
     &          IPRO_CREEP_VEXFNR   = 2,
     &          IPRO_CREEP_VAMPL    = 3,
     &          IPRO_CREEP_VRATE    = 4,
     &          IPRO_CREEP_DEXFNR   = 5,
     &          IPRO_CREEP_DAMPL    = 6,
     &          IPRO_CREEP_DRATE    = 7,
     &          IPRO_CREEP_ALPHA    = 8,
     &          IPRO_CREEP_KAPPA    = 8,
     &          IPRO_CREEP_PNONL    = 9,
     &          IPRO_CREEP_SWELL_SIG0=9,      
     &          IPRO_CREEP_SWELL_SIGC=10,
     &          IPRO_CREEP_SWELL_ALPHAS = 11,
     &          IPRO_CREEP_SWELL_K0_REF = 12,     
     
     &          IPRO_CREEP_PERMAFROST_pL = 8,
     &          IPRO_CREEP_PERMAFROST_C1 = 9,
     &          IPRO_CREEP_PERMAFROST_f1_FUN =10,

     &          IPRO_CREEP_NORTON_SIG_REF  = 3,
     &          IPRO_CREEP_NORTON_SIG0_FLAG= 4,
     &          IPRO_CREEP_NORTON_A1       = 6,
     &          IPRO_CREEP_NORTON_N1       = 7,
     &          IPRO_CREEP_NORTON_QREF_1   = 8,
     &          IPRO_CREEP_NORTON_A2       = 9,
     &          IPRO_CREEP_NORTON_N2       =10,
     &          IPRO_CREEP_NORTON_QREF_2   =11,

      ! dedicated creep for concrete including aging effects
     &          IPRO_CREEP_AGINGC_EQ_TIME_FLAG    = 2,
     &          IPRO_CREEP_AGINGC_AGING_FLAG= 3,
     &          IPRO_CREEP_AGINGC_AGE_INIT  = 4,
      ! fifth position remains as in standard models --> EXF 
     &          IPRO_CREEP_AGINGC_A         = 6,
     &          IPRO_CREEP_AGINGC_B         = 7,
     &          IPRO_CREEP_AGINGC_T_REF     = 8,
     &          IPRO_CREEP_AGINGC_Q_BY_R    = 9,
     &          IPRO_CREEP_AGINGC_S         =10,
     &          IPRO_CREEP_AGINGC_T_28      =11,
     &          IPRO_CREEP_AGINGC_STIFF_POW =12,
     &          IPRO_CREEP_AGINGC_VISC_FLOW_FLAG = 13,
     &          IPRO_CREEP_AGINGC_VISC_FLOW_Q4   = 14,
     &          IPRO_CREEP_AGINGC_VISC_FLOW_XI   = 15,
     &          IPRO_CREEP_AGINGC_N        = 16,

     &          IPRO_CREEP_C_SWELL_SIG_L   = 2,
     &          IPRO_CREEP_C_SWELL_EPS_RATE_MAX = 3,

     &          IPRO_CREEP_FIRE_PHI        = 2 )

      integer*4, parameter :: IPRO_STAB_TYPE    = 1
      integer*4, parameter :: IPRO_STAB_SFM1_V1 = 2 
      integer*4, parameter :: IPRO_STAB_SFM1_V2 = 3 
      integer*4, parameter :: IPRO_STAB_SFM1_DV = 4 

      integer*4, parameter :: IPRO_STAB_SFM2_V1 = 5 
      integer*4, parameter :: IPRO_STAB_SFM2_V2 = 6 
      integer*4, parameter :: IPRO_STAB_SFM2_DV = 7 


      integer*4, parameter :: IPRO_DAMP_ALPHA = 1,
     &                        IPRO_DAMP_BETA  = 2

      integer*4, parameter :: IPRO_DISC_FT    = 1,
     &                        IPRO_DISC_Gf    = 2,
     &                        IPRO_DISC_ALPHA = 3,
     &                        IPRO_DISC_DK1   = 4,
     &                        IPRO_DISC_DINT  = 5


      integer*4, parameter :: IPRO_FIRE_MODEL_EC2_STEEL    = 1
      integer*4, parameter :: IPRO_FIRE_MODEL_EC2_CONCRETE = 2


c   model operation identyfiers :
      integer*4 
     &      L_GP_UPD_STATE ,
     &      L_GP_NEW_STATE ,
     &      L_GP_INI_STATE ,
     &      L_GP_SIZE      ,
     &      L_GP_IFSYM     ,
     &      L_GP_SETCELA   ,
     &      L_GP_SETDELA   ,
     &      L_GP_PRINTPARAM,
     &      L_GP_GET_INFO  ,
     &      L_GP_MODIFPARAM,
     &      L_GP_SET_INCOMP,
     &      L_GP_SETDATASIZE,
     &      L_GP_FORM_DESCR ,
     &      L_GP_SET_ADDDATA,
     &      L_GP_SET_FILL_PROP,
     &      L_GP_GET_FRICT_PAR,
     &      L_GP_GET_LVARS_NNL,
cAT 12.01.20122
     &      L_GP_FREEZE_EL_STIFF_IN_DRM_EB_ZONE,     
     &      L_GP_SOFT_FLAG,
     &      L_GP_AUTO_KO,
c     &      L_GP_AGING_FLAG,
     &      L_GP_NEW_LHS_FLAG,
cAT 14.08.2019
     &      L_GP_SET_BAROTROPY,
     &      L_GP_NR_OF_ORDERS


      parameter(
     &      L_GP_UPD_STATE =    1 ,! update N+1 --> N equlibrium configuration
                                   ! return :
                                   ! (a) true stress increment through array
                                   !      dStr_TRA (.) from common trans.inc
                                   ! Note : InfoIn == M array
     &      L_GP_NEW_STATE =    2 ,! set new stress state, new constitutive
                                   ! matrix and new internal variables
                                   ! return :
                                   ! (a) Dep through array Dep_TRA (trans.inc)
                                   ! (b) Stresses through array Sact_TRA
                                   !     (trans.inc)
                                   ! Note : InfoIn == M array
     &      L_GP_INI_STATE =    4 ,! initialize g.p. internal parameters
                                   ! return : NOTHING
                                   ! Note : InfoIn == M array
     &      L_GP_SIZE      =    8 ,! evaluate g.p. internal storage volume
                                   ! expressed in int*4 words
                                   ! return :
                                   ! (a) storage volume in InfOut (1)
     &      L_GP_IFSYM     =   16 ,! answer whether model gives symmetric
                                   ! constitutive matrix
                                   ! return :
                                   ! (a) if symmetric    InfOut(1)=1
                                   !     if nonsymmetric InfOut(1)=0
     &      L_GP_SETCELA   =   32 ,! evaluate elastic compliance matrix Ce
                                   ! return:
                                   ! (a) Ce by array InfOut (.)
     &      L_GP_SETDELA   =   64 ,! evaluate elastic stiffness matrix De
                                   ! return:
                                   ! (a) De by array InfOut (.)
     &      L_GP_PRINTPARAM=  128 ,! print model parameters
                                   ! return : NOTHING
     &      L_GP_GET_INFO  =  256 ,! return some g.p. information according
                                   ! to specification given in InfoIn(1)
                                   ! the specification can be done with OR bit
                                   ! operation of items ITRA_GP_....
                                   ! taken from trans.inc
     &      L_GP_MODIFPARAM=  512 ,! perform c,phi  modification in properties
                                   ! array due to SF2 type of stability driver
     &      L_GP_SET_INCOMP= 1024 ,! set internal g.p. poisson parameter

     &      L_GP_SETDATASIZE=2048 ,!set size of data to be read in specyfied
                                   !group
     &      L_GP_FORM_DESCR =4096 ,! return type of constitutive formulation

     &      L_GP_SET_ADDDATA =8192,! set additional internal model data 

     &      L_GP_SET_FILL_PROP=16384, ! set or restore properties for filling (v=0.5, psi=0)

     &      L_GP_GET_FRICT_PAR=32768, ! extract fi,psi and c from model data and return in iNFOOUT flag(has this data),pgi,psi,c
     
     &      L_GP_GET_LVARS_NNL=65536, ! return local varoables for nonlocal averaging
     
     &      L_GP_FREEZE_EL_STIFF_IN_DRM_EB_ZONE = 131072, ! save stress state as reference for stiffness in DRM domain
                                                          ! gauss point must set flag freeze = TRUE and save stress state as reference
     &      L_GP_SOFT_FLAG   =262144,
     &      L_GP_AUTO_KO     =524288, 
c     &      L_GP_AGING_FLAG  =1048576,
     &      L_GP_NEW_LHS_FLAG =1048576,

     &      L_GP_SET_BAROTROPY = 2097152,
     &      L_GP_NR_OF_ORDERS = 22 )  ! actualize if changed above


      integer*4  IPRO_NR_OF_DATA_IN_LINE 
      parameter( IPRO_NR_OF_DATA_IN_LINE = 8)

      integer*4  IPRO_NROF_IMPLEMENTED_TYPES 
      parameter( IPRO_NROF_IMPLEMENTED_TYPES = 132) !  this number must cover all
	                                                   !  models build -in and user
												                                        !  defined 

      integer*4, parameter :: TMP_SIZE_PRO = IELE_GR_MAXNR*2

      character *10 PRO_TypeCharIdArray
      character *5 PRO_GroupCharIdArray
     	character *(TMP_SIZE_PRO) PRO_GroupOK         ! that is 32= IELE_GR_MAXNR*2 

c     logical*4 GeoNonStorage_PRO, GeoNonOK_PRO, GeoNonStorageOK_PRO !AU2000_02_10
      logical*4 :: SomeDataIsDefinedViaLREC_PRO

      integer*4 IConsPtr_PRO,
     &          NrOf_PRO,     
     &          IproAct_PRO   

      integer*4 :: NrOfParent_PRO,iConsPtrParent_PRO 
      
      integer*8 :: domain_handle_PRO
      integer*8 :: dummy_domain_handle_PRO

      type MaterialLabelType_PRO
        character*256 :: label
      end type MaterialLabelType_PRO

      type (MaterialLabelType_PRO), pointer :: MaterialLabels_PRO(:)
      integer*4 :: paddingb1_PRO
      integer*4 :: paddinge1_PRO

      common /PRO_common/
     &   paddingb1_PRO(32),
     &   IConsPtr_PRO, !start ptr. to constant e.memory
     &   NrOf_PRO,     ! total nr of materials in the job
     &   IproAct_PRO,  ! nr of currently proceed material set
     &   NrOfParent_PRO,
     &   iConsPtrParent_PRO, 
     &   SomeDataIsDefinedViaLREC_PRO,
     &   domain_handle_PRO,
     &   dummy_domain_handle_PRO,
     &   MaterialLabels_PRO,
     &   paddinge1_PRO(32)


      integer*4 IPRO_ContPossibleFormulation,
     &          IPRO_DatPosOf,
     &          IPRO_AddPosOf,
     &          IPRO_RecSizeOf,
     &          IPRO_DatPosOf_ORG,
     &          IPRO_AddPosOf_ORG,
     &          IPRO_RecSizeOf_ORG,
     &          IPRO_FreezeElasticStiffForDRM

      integer*4 :: paddingb2_PRO
      integer*4 :: paddinge2_PRO

      common /PRO_models_common/
     &  paddingb2_PRO (32),
     &  PRO_TypeCharIdArray (IPRO_NROF_IMPLEMENTED_TYPES),
     &  PRO_GroupOK         (IPRO_NROF_IMPLEMENTED_TYPES),
     &  IPRO_ContPossibleFormulation(IPRO_NROF_IMPLEMENTED_TYPES),
     & IPRO_DatPosOf_ORG (IPRO_GR_MAXSIZE,IPRO_NROF_IMPLEMENTED_TYPES),
     & IPRO_AddPosOf_ORG (IPRO_GR_MAXSIZE,IPRO_NROF_IMPLEMENTED_TYPES),
     & IPRO_RecSizeOf_ORG(IPRO_GR_MAXSIZE,IPRO_NROF_IMPLEMENTED_TYPES),

     &  IPRO_DatPosOf (IPRO_GR_MAXSIZE,IPRO_NROF_IMPLEMENTED_TYPES),
     &  IPRO_AddPosOf (IPRO_GR_MAXSIZE,IPRO_NROF_IMPLEMENTED_TYPES),
     &  IPRO_RecSizeOf(IPRO_GR_MAXSIZE,IPRO_NROF_IMPLEMENTED_TYPES),
     &  IPRO_FreezeElasticStiffForDRM (IPRO_NROF_IMPLEMENTED_TYPES),
     &  paddinge2_PRO (32)
       
      integer*4 :: paddingb3_PRO
      integer*4 :: paddinge3_PRO
      common /PRO_groups_common/
     &   paddingb3_PRO (32),
     &   PRO_GroupCharIdArray(IPRO_GR_MAXSIZE),
     &   paddinge3_PRO (32)


      save  /PRO_common/
      save  /PRO_groups_common/
      save  /PRO_models_common/


!MS$DEFINE __PROP_INC
!MS$ENDIF