!MS$IF DEFINED (__QS_INC)
!MS$ELSE

c   this module stores and controls the whole shape function
c   and numerical integration processing for all types of element

c  positions in iqs_adr_array:

      integer*4 
     &   IQS_ADR_N ,
     &   IQS_ADR_DN,
     &   IQS_ADR_D2N,
     &   IQS_ADR_MAX

      parameter (
     &   IQS_ADR_N  = 1,  ! adress to first int.point shape function array
     &   IQS_ADR_DN = 2,  !  "         "     "   "    sh.fun   deriv. array
     &   IQS_ADR_D2N =3,  !  "         "     "   "    sh.fun 2 deriv. array
     &   IQS_ADR_MAX =3  )


c  positions in quadrature describing array:
      integer*4 
     &           IQS_QUA_NPOIN , 
     &           IQS_QUA_DIM   , 
     &           IQS_QUA_INFO_MAX

      parameter (
     &           IQS_QUA_NPOIN = 1,   ! number of integration point
     &           IQS_QUA_DIM   = 2,   ! dimension of local coord space
     &           IQS_QUA_INFO_MAX =2 )

c  positions in shape function describing array:

      integer*4 
     &           IQS_SHF_NPOIN , 
     &           IQS_SHF_DIM   , 
     &           IQS_SHF_INFO_MAX

      parameter (
     &           IQS_SHF_NPOIN = 1,    ! number of nodal point
     &           IQS_SHF_DIM   = 2,    ! dimension of local coord space
     &           IQS_SHF_INFO_MAX =2 )

      enum, bind(C) 
      enumerator::   
     &  IQS_SHF_L2 = 1 , 
     &  IQS_SHF_L3, 
     &  IQS_SHF_L4,
     &  IQS_SHF_Q4,
     &  IQS_SHF_Q6  , 
     &  IQS_SHF_Q8  , 
     &  IQS_SHF_Q9  , 
     &  IQS_SHF_Q4I , 
     &  IQS_SHF_Q6I , 
     &  IQS_SHF_Q9I , 
     &  IQS_SHF_Q4IC, 
     &  IQS_SHF_Q4TANH,
     &  IQS_SHF_T3  ,
     &  IQS_SHF_T6  ,
     &  IQS_SHF_T15 ,
     &  IQS_SHF_T3B ,
     &  IQS_SHF_B8  ,
     &  IQS_SHF_B20 ,
     &  IQS_SHF_B8I ,
     &  IQS_SHF_B8IC,
     &  IQS_SHF_W6 ,
     &  IQS_SHF_W15,
     &  IQS_SHF_W6I,
     &  IQS_SHF_P4,
     &  IQS_SHF_P10,
     &  IQS_SHF_MAX = IQS_SHF_P10
      end enum 


      enum, bind(C) 
      enumerator::  
     &  IQS_QUA_L1  = 1 ,  ! 1-point
     &  IQS_QUA_L2   ,  ! 2-point
     &  IQS_QUA_L3   ,  ! 3-point
     &  IQS_QUA_LN2  ,  ! 2node 1D elements, nodal points quad
     &  IQS_QUA_LN3  ,  ! 3node 1D elements, nodal points quad
     &  IQS_QUA_L1X  ,  
     &  IQS_QUA_L4   ,  ! 4 point 
     &  IQS_QUA_GL5  ,  ! Gauss-Lobatto 5 
     &  IQS_QUA_Q1   , ! quad,   1x1 - point
     &  IQS_QUA_Q2   , ! quad,   2x2 - point
     &  IQS_QUA_Q3   , ! quad,   3x3 - point
     &  IQS_QUA_QN4  , ! quad,   4 nodal points
     &  IQS_QUA_QN8  , ! quad,   8 nodal points
     &  IQS_QUA_Q32  , ! quad,   3 point along xi dir and 2 pts along eta
     &  IQS_QUA_Q42  , ! quad,   4 point along xi dir and 2 pts along eta
     &  IQS_QUA_Q62  , ! quad,   4 point along xi dir and 2 pts along eta
     &  IQS_QUA_Q3XSI ,! quad,   4 point along xi dir and 2 pts along eta
     &  IQS_QUA_T1 ,   ! triangle, 1 - point
     &  IQS_QUA_T3 ,   ! triangle, 3 - point
     &  IQS_QUA_T7 ,   ! triangle, 7 - point
     &  IQS_QUA_T13,   ! triangle,13 - point
     &  IQS_QUA_TN3,   ! triangle, 3 nodal points
     &  IQS_QUA_TN6,   ! triangle, 6 nodal points
     &  IQS_QUA_B1 ,  ! brick,  1x1x1  point
     &  IQS_QUA_B2 ,  ! brick,  2x2x2
     &  IQS_QUA_B3 ,  ! brick,  3x3x3
     &  IQS_QUA_W1 ,  ! wedge , 1x1
     &  IQS_QUA_W2 ,  ! wedge , 3x2
     &  IQS_QUA_W3 ,  ! wedge , 7x3
     &  IQS_QUA_P1 ,  ! pyramid   1
     &  IQS_QUA_P2 ,  ! pyramid   4
     &  IQS_QUA_P3 ,  ! pyramid   5
     &  IQS_QUA_MAX = IQS_QUA_P3 
      end enum


      integer*4, parameter :: IQS_MAX_INTPOINT    =     16
      integer*4, parameter :: IQS_SHAPE_BUFF_SIZE =   4000  ! check it when adding new shape functions or quadratures
      integer*4, parameter :: IQS_DERIV_BUFF_SIZE =  10000
      integer*4, parameter :: IQS_DERIV2_BUFF_SIZE = 20000

      integer*4, parameter :: IQS_ADR_ARR_SIZE = 
     &                        IQS_ADR_MAX*IQS_QUA_MAX*IQS_SHF_MAX

      real*8, target:: QS_ShapeFun,
     &                 QS_ShFunDer,
     &                 QS_ShF2Der 
      integer*4 
     &       IQS_AdrArray,
     &       iShapeLocPtr_IQS,
     &       iDerivLocPtr_IQS,
     &       iDeriv2LocPtr_IQS,
     &       IQS_Quad,
     &       IQS_Shape

      integer*4 ::   iqs_nullmiss

      real*8,target:: T_L2_IQS_QUA_L1 
      real*8,target:: T_L2_IQS_QUA_L2 
      real*8,target:: T_Q4_IQS_QUA_Q1 
      real*8,target:: T_Q4_IQS_QUA_Q2 
      real*8,target:: T_T3_IQS_QUA_T1 
      real*8,target:: T_T3_IQS_QUA_T3 
      real*8,target:: T_W6_IQS_QUA_W1 
      real*8,target:: T_W6_IQS_QUA_W2 
      real*8,target:: T_B8_IQS_QUA_B1 
      real*8,target:: T_B8_IQS_QUA_B2 
      real*8,target:: T_P4_IQS_QUA_P1
      real*8,target:: T_P4_IQS_QUA_P2

      integer*4 :: paddingb1_QS, paddinge1_QS

      common / QS_common /
     &  paddingb1_QS (32),
     &  QS_ShapeFun(IQS_SHAPE_BUFF_SIZE),  ! shape fun. values
     &  QS_ShFunDer(IQS_DERIV_BUFF_SIZE),  ! shape fun derivatives
     &  QS_ShF2Der (IQS_DERIV2_BUFF_SIZE),  ! shape fun 2 derivatives
     &  IQS_AdrArray(IQS_ADR_MAX,IQS_SHF_MAX,IQS_QUA_MAX), ! store adresses
     &  iShapeLocPtr_IQS,     ! last pointer in shape function buffer
     &  iDerivLocPtr_IQS,     ! last pointer in sh.fun derivative buffe
     &  iDeriv2LocPtr_IQS,    ! last pointer in sh.fun 2 derivative buffe
     &  IQS_Quad (IQS_QUA_INFO_MAX,IQS_QUA_MAX), ! quadrature description array
     &  IQS_Shape(IQS_SHF_INFO_MAX,IQS_SHF_MAX), ! shape fun description array
     &  iqs_nullmiss,
     &   T_L2_IQS_QUA_L1 (2,1),
     &   T_L2_IQS_QUA_L2 (2,2),
     &   T_Q4_IQS_QUA_Q1 (4,1),
     &   T_Q4_IQS_QUA_Q2 (4,4),
     &   T_T3_IQS_QUA_T1 (3,1),
     &   T_T3_IQS_QUA_T3 (3,3),
     &   T_W6_IQS_QUA_W1 (6,1),
     &   T_W6_IQS_QUA_W2 (6,6),
     &   T_B8_IQS_QUA_B1 (8,1),
     &   T_B8_IQS_QUA_B2 (8,8),
     &   T_P4_IQS_QUA_P1 (4,1),
     &   T_P4_IQS_QUA_P2 (4,4),
     &   paddinge1_QS (32)

       save /QS_common/


      real*8 
     &           Xsi_L1_QS,  
     &           Xsi_L2_QS,
     &           Xsi_L3_QS,
     &           Xsi_LN2_QS,
     &           Xsi_LN3_QS,
     &           Xsi_L4_QS,
     &           Xsi_L1X_QS,
     &           Xsi_GL5_QS,

     &           Xsi_Q1_QS,
     &           Xsi_Q2_QS,
     &           Xsi_Q3_QS,
     &           Xsi_Q3XSI_QS,
     &           Xsi_QN4_QS,
     &           Xsi_QN8_QS,
     &           Xsi_Q32_QS,
     &           Xsi_Q42_QS,
     &           Xsi_Q62_QS,

     &           Xsi_T1_QS,
     &           Xsi_T3_QS,
     &           Xsi_T7_QS,
     &           Xsi_T13_QS,
     &           Xsi_TN3_QS,
     &           Xsi_TN6_QS,

     &           Xsi_B1_QS,
     &           Xsi_B2_QS,
     &           Xsi_B3_QS,

     &           Xsi_W1_QS,
     &           Xsi_W2_QS,
c    &           Xsi_W3_QS,

     &           Xsi_P1_QS,
     &           Xsi_P2_QS,
     &           Xsi_P3_QS 

      integer*4 :: paddingb2_QS, paddinge2_QS

      common / QS_Xsi /
     &           Xsi_L1_QS(1,1) ,  ! 1-point
     &           Xsi_L2_QS(1,2) ,  ! 2-point
     &           Xsi_L3_QS(1,3) ,  ! 3-point
     &           Xsi_LN2_QS(1,2),  ! 2 node
     &           Xsi_LN3_QS(1,3),  ! 3 node
     &           Xsi_L1X_QS(1,3),  ! 
     &           Xsi_L4_QS (1,4),  ! 4-point
     &           Xsi_GL5_QS(1,5),  ! Gauss Lobatto 5
 ! 2-dimensional:
     &           Xsi_Q1_QS(2,1) , ! quad,   1x1 - point
     &           Xsi_Q2_QS(2,4) , ! quad,   2x2 - point
     &           Xsi_Q3_QS(2,9) , ! quad,   3x3 - point
     &           Xsi_Q3XSI_QS(2,3) , ! quad,   3x1 - point
     &           Xsi_QN4_QS(2,4) , ! quad  4 nodal point
     &           Xsi_QN8_QS(2,8) , ! quad  8 nodal point
     &           Xsi_Q32_QS (2,6), ! quad with 3 points along xi dir. 2 points along eta dir.
     &           Xsi_Q42_QS (2,8), ! quad with 4 points along xi dir. 2 points along eta dir.
     &           Xsi_Q62_QS (2,12),! quad with 6 points along xi dir. 2 points along eta dir.

     &           Xsi_T1_QS(2,1) , ! triangle, 1 - point
     &           Xsi_T3_QS(2,3) , ! triangle, 3 - point
     &           Xsi_T7_QS(2,7) , ! triangle, 7 - point
     &           Xsi_T13_QS(2,13), ! triangle, 13 - point
     &           Xsi_TN3_QS(2,3) , ! triangle T3 nodal quadrature
     &           Xsi_TN6_QS(2,6) , ! triangle T6 nodal quadrature

 ! 3-dimensional
     &           Xsi_B1_QS(3,1)  , ! brick,  1x1x1  point
     &           Xsi_B2_QS(3,8)  , ! brick,  2x2x2
     &           Xsi_B3_QS(3,27) , ! brick,  3x3x3

     &           Xsi_W1_QS(3,1)  , ! wedge , 1x1
     &           Xsi_W2_QS(3,6)  , ! wedge , 3x2
c     &           Xsi_W3_QS(3,21), ! wedge , 7x3

     &           Xsi_P1_QS(3,1 ) , ! pyramid   1
     &           Xsi_P2_QS(3,4 ) , ! pyramid   4
     &           Xsi_P3_QS(3,5 ) , ! pyramid   5
     &           paddinge2_QS (6)

      save /QS_Xsi/


      real*8 
     &           W_L1_QS,
     &           W_L2_QS,
     &           W_L3_QS,
     &           W_L4_QS,
     &           W_LN2_QS,
     &           W_LN3_QS,
     &           W_L1X_QS,
     &           W_GL5_QS,

     &           W_Q1_QS,
     &           W_Q2_QS,
     &           W_Q3_QS,
     &           W_Q3XSI_QS,
     &           W_Q4_QS,
     &           W_QN4_QS,
     &           W_QN8_QS,
     &           W_Q32_QS,
     &           W_Q42_QS,
     &           W_Q62_QS,

     &           W_T1_QS,
     &           W_T3_QS,
     &           W_T7_QS,
     &           W_T13_QS,
     &           W_TN3_QS,
     &           W_TN6_QS,

     &           W_B1_QS,
     &           W_B2_QS,
     &           W_B3_QS,

     &           W_W1_QS,
     &           W_W2_QS,
c     &           W_W3_QS,

     &           W_P1_QS,
     &           W_P2_QS,
     &           W_P3_QS 
      integer*4 :: padding3b_QS, padding3e_QS

      common / QS_W /
     &           W_L1_QS(1) ,  ! 1-point
     &           W_L2_QS(2) ,  ! 2-point
     &           W_L3_QS(3) ,  ! 3-point
     &           W_L4_QS(4) ,  ! 4-point
     &           W_LN2_QS(2),  ! 2point-nodal quadr.
     &           W_LN3_QS(3),  ! 3point-nodal quadr.
     &           W_L1X_QS(3),
     &           W_GL5_QS(5),
 ! 2-dimensional:
     &           W_Q1_QS(1)  , ! quad,   1x1 - point
     &           W_Q2_QS(4)  , ! quad,   2x2 - point
     &           W_Q3_QS(9)  , ! quad,   3x3 - point
     &           W_Q3XSI_QS(3),! quad,   3x3 - point
     &           W_Q4_QS(16) , ! quad,   4x4 - point
     &           W_QN4_QS(4) , ! quad  4 nodal point
     &           W_QN8_QS(8) , ! quad  8 nodal point
     &           W_Q32_QS(6) , ! quad with 6 points (3 nodes along xsi direction)
     &           W_Q42_QS(8) , ! quad with 8 points (4 nodes along xsi direction)
     &           W_Q62_QS(12), ! quad with 8 points (4 nodes along xsi direction)

     &           W_T1_QS(1)  , ! triangle, 1 - point
     &           W_T3_QS(3)  , ! triangle, 3 - point
     &           W_T7_QS(7)  , ! triangle, 7 - point
     &           W_T13_QS(13), ! triangle, 13- point
     &           W_TN3_QS(3) , ! triangle 3 nodal point
     &           W_TN6_QS(6) , ! triangle 6 nodal point

 ! 3-dimensional
     &           W_B1_QS(1) , ! brick,  1x1x1  point
     &           W_B2_QS(8) , ! brick,  2x2x2
     &           W_B3_QS(27) , ! brick,  3x3x3

     &           W_W1_QS(1) , ! wedge , 1x1
     &           W_W2_QS(6) , ! wedge , 3x2
c     &           W_W3_QS(21) , ! wedge , 7x3

     &           W_P1_QS(1 ) , ! pyramid   1
     &           W_P2_QS(4 ) , ! pyramid   4
     &           W_P3_QS(5 ) , ! pyramid   5
     &           padding3e_QS(8)	 


      save /QS_W/

      integer*4, parameter :: IQS_MAX_GP_POLYGON_VERTICES = 8

      type GPpolygonTYPE_QS
        SEQUENCE
        integer*4 :: polygonShape
        integer*4 :: nVertices
        integer*4 :: index
        integer*4 :: padding
        real*8    :: xsi(3*IQS_MAX_GP_POLYGON_VERTICES) 
      end type GPpolygonTYPE_QS

      type (GPpolygonTYPE_QS) :: GPpolygons_QS 

      integer*4 :: padding4b_QS, padding4e_QS
      common /gppoly_qs/ !padding4b_QS(32),
     &                   GPpolygons_QS (IQS_MAX_INTPOINT,IQS_QUA_MAX),
     &                   padding4e_QS(32)
      save /gppoly_qs/

      integer*4 :: padding5b_QS, padding5e_QS
	  real*8 X0_B20
      common /B20_/ 
     &              X0_B20(3,20),
     &              padding5e_QS (8)
	  save /B20_/

      integer*4 :: padding6b_QS, padding6e_QS
	  integer*4 iL3_Q9
      common /Q9_/ !padding6b_QS (32),
     &             iL3_Q9(2,9),
     &             padding6e_QS (14) 
	  save /Q9_/

!MS$DEFINE __QS_INC
!MS$ENDIF
