!MS$IF DEFINED (__TRANS_INC)
!MS$ELSE


c !!! This is general common to communicate between general element level
c !!! and material model level
      include 'maxmin.inc'  ! must be included before this
      include 'contact.inc'
!MS$FREEFORM
include 'handle_type.fi'
!MS$NOFREEFORM

      integer*4 iptr_E_TRA      ,
     &          iptr_dE_TRA     ,  
     &          iptr_SigN_TRA   , 
     &          iptr_SigEXC_TRA , 
     &          iptr_Sig0_TRA   ,
     &          iptr_dSig0X_TRA ,  
     &          iptr_SigK0_TRA  ,
     &          iptr_prestress_ON_TRA,
     &          iptr_CreepBeamLay_TRA,
     &          iptr_dEps0_TRA  , 
     &          iptr_pfN_TRA,
     &          iptr_pfNx1_TRA,
     &          iptr_voidrN_TRA,
     &          iptr_voidrNx1_TRA,
     &          iptr_dEpsZ_TRA  , 
     &          iptr_Kt_N_TRA,
     &          iptr_Kt_Nx1_TRA,
     &          iptr_HEATrec_TRA,  
     &          iptr_HUMIrec_TRA,  
     &          iptr_model_TRA  ,  
     &          iptr_HeatModel_TRA,
     &          iptr_HumidityModel_TRA,
     &          iptr_FLOWrec_TRA,
     &          padding1b_TRA, padding1e_TRA



      common /pointers_TRA / ! local pointers in gP storage buffers
                             ! part independent from current model
     & padding1b_TRA (16),
     & iptr_E_TRA      ,  ! total strain
     & iptr_dE_TRA     ,  ! total strain
     & iptr_SigN_TRA   ,  ! stress state at last equilibrium configuration
     & iptr_SigEXC_TRA ,  ! stress state needed to compute 
     & iptr_Sig0_TRA   ,  ! initial stresses
     & iptr_dSig0X_TRA ,  ! initial stresses correction
     & iptr_SigK0_TRA  ,
     & iptr_prestress_ON_TRA, ! for beams to put a flag saying that prestresss is active in this step
     & iptr_CreepBeamLay_TRA, ! pointer to creep storage for beam layers
     & iptr_dEps0_TRA  ,  ! initial strain increment
     & iptr_pfN_TRA,
     & iptr_pfNx1_TRA,
     & iptr_voidrN_TRA,
     & iptr_voidrNx1_TRA,
     & iptr_Kt_N_TRA,
     & iptr_Kt_Nx1_TRA,
     & iptr_dEpsZ_TRA,    ! eps-Z increment for global plane-stress algorithm
     & iptr_HEATrec_TRA,  ! extra information needed for thermal strains
     & iptr_HUMIrec_TRA,  ! extra information needed for hygral  strains
     & iptr_HeatModel_TRA,
     & iptr_HumidityModel_TRA,
     & iptr_FLOWrec_TRA,
     & iptr_model_TRA  ,  ! specific model gp memory
     & padding1e_TRA (9)


!$OMP THREADPRIVATE(/pointers_TRA/)
      !save /pointers_TRA/


      real*8 
     &  Dev_TRA ,
     &  Cev_TRA ,
     &  dEcr_TRA, E_ve_mult_TRA,Aging_Growth_TRA

      type (HANDLE_type) :: ele_field_handle_TRA
      type (HANDLE_type) :: beam_cross_section_info_TRA
      type (HANDLE_type) :: beam_aux_objs_TRA
      type (HANDLE_type) :: shell_aux_objs_handle_TRA
      integer*4 :: padding2b_TRA, padding2e_TRA

      common / CentralPoint_TRA /  
     &  padding2b_TRA (16),
     &  Dev_TRA ( MAX_STRESS_2 ) ,! (visco)elastic const. matrix
     &  Cev_TRA ( MAX_STRESS_2 ) ,! inversion of the above
     &  dEcr_TRA( MAX_STRESS   ) ,! creep strain increment
     &  E_ve_mult_TRA,Aging_Growth_TRA,
     &  padding2e_TRA (4)


!$OMP THREADPRIVATE(/CentralPoint_TRA/)
      !save / CentralPoint_TRA /

      character*4  StatusChar_TRA

      real*8 
     &  Dep_TRA   ,
     &  Dup_TRA   ,
     &  Dpu_TRA   ,
     &  Dpp _TRA  ,
     &  dEpsPV_TRA,
     &  Sact_TRA  ,
     &  dStr_TRA  ,
     &  dE_TRA    ,
     &  dEc_TRA   ,
     &  dp_TRA    ,
     &  dSig0_TRA ,
     &  Sig0init_TRA,
     &  dEps0_TRA ,
     &  TotStrain_TRA,
     &  voidrN_TRA,
     &  voidrNx1_TRA,
     &  LOC_vars_TRA,
     &  NNL_vars_TRA,
     &  Xgp_TRA   ,
     &  v_TRA     ,
     &  E_TRA     ,
     &  Dvol_TRA  ,                 
     &  he_TRA    ,
     &  he_arr_TRA,
     &  gp_weight_TRA,
     &  Slev_TRA  ,                  
     &  xMaturity_TRA   ,               
     &  dMaturityDT_TRA ,            
     &  ft_TRA  ,

     &  YoungET_TRA,
     &  YoungE0_TRA,

     &  HardPC_TRA,
     &  T_TRA,
     & dT_TRA,

     &  Hard_gamma_TRA,
     &  EpsVP_EQ_TRA,
     &  DefGrad_N_TRA,
     &  DefGrad_Nx1_2_TRA,
     &  det_DefGrad_N_TRA,
     &  det_DefGrad_Nx1_2_TRA,
     &  Damage_TRA


     
      integer*4 :: Iplas_TRA,T_err_TRA,misalignment_TRA,
     &             sig_eps_flag_TRA, fluid_vf_S_flag_TRA,
     &             igaus_TRA, iele_TRA, ilayer_TRA, 
     &             padding3b_TRA, padding3e_TRA

      

      common / CurrentIntPoint_TRA /
     &  padding3b_TRA (16)           ,
     &  Dep_TRA   ( MAX_STRESS_2 )  ,! computed constitutive matrix
     &  Dup_TRA   ( MAX_STRESS   )  ,
     &  Dpu_TRA   ( MAX_STRESS   )  ,
     &  Dpp _TRA                    ,
     &  dEpsPV_TRA                  ,! volumetric plastic strain
     &  Sact_TRA  ( MAX_STRESS   )  ,! actual stresses
     &  dStr_TRA  ( MAX_STRESS   )  ,! true stress increment
     &  dE_TRA    ( MAX_STRESS   )  ,! effective strain increment
     &  dEc_TRA   ( MAX_STRESS   )  ,! effective strain increment at element center
     &  dp_TRA                      ,
     &  dSig0_TRA ( MAX_STRESS   )  ,! initial stress increment
     &  Sig0init_TRA(MAX_STRESS  )  ,! initial stresses given by the user
     &  dEps0_TRA ( MAX_STRESS   )  ,! initial strain increment
     &  TotStrain_TRA ( MAX_STRESS   ),! total strain increment
     &  voidrN_TRA                  ,! void ratio at step N
     &  voidrNx1_TRA                ,! void ratio at step N+1
     &  LOC_vars_TRA (12),
     &  NNL_vars_TRA (12),     
     &  Xgp_TRA   ( 3 )             ,! global int. point coordinates
     &  v_TRA                       ,! Poisson coeff
     &  E_TRA                       ,! Young modulus
     &  Dvol_TRA                    ,! integration point volume
     &  he_TRA                      ,! element size
     &  he_arr_TRA (3,2)            ,! element size in each principal strain direction
     &  gp_weight_TRA               ,! gauss point weight
     &  Slev_TRA                    ,! Stress level
     &  xMaturity_TRA               ,! Maturity
     &  dMaturityDT_TRA             ,! dMaturity/dTemperature
     &  ft_TRA                      ,! tension strength
     &  YoungET_TRA                 ,! tangent E modulus/initial E modulus
     &  YoungE0_TRA                 ,! tangent E modulus/initial E modulus
     &  HardPC_TRA                  ,! hardening parameters
     &  T_TRA                       ,! current value of temperature
     &  dT_TRA                      ,! temperature increment
     &  T_err_TRA                   ,! flag whether temperature is defined
     &  Hard_gamma_TRA              ,! Hoek-Brown gamma hardening parameter
     &  EpsVP_EQ_TRA                ,! Hoek-Brown creep equivalent strain
     &  DefGrad_N_TRA     (3,3)     ,! deformation gradient on configuration N
     &  DefGrad_Nx1_2_TRA (3,3)     ,! deformation gradient on configuration N+1/2
     &  det_DefGrad_N_TRA           ,! determinant of deformation gradient on configuration N
     &  det_DefGrad_Nx1_2_TRA       ,! determinant of deformation gradient on configuration N+1/2 
     &  Damage_TRA                  ,! damage value
     &  Iplas_TRA                   ,! plastic status int. representation
     &  sig_eps_flag_TRA            ,! sig_eps_flag status - could be hidden within iplas_TRA
     &  StatusChar_TRA              ,!    "       "   character
     &  igaus_TRA,
     &  iele_TRA,
     &  ilayer_TRA,
     &  padding3e_TRA (3)           


!$OMP THREADPRIVATE(/CurrentIntpoint_TRA/)
      !save /CurrentIntpoint_TRA/

      !type ::currintpointtype
      !
      ! real*8 :: Dep_TRA   ( MAX_STRESS_2 )  
      ! real*8 :: Dup_TRA   ( MAX_STRESS   )  
      ! real*8 :: Dpu_TRA   ( MAX_STRESS   )  
      ! real*8 :: Dpp _TRA                    
      ! real*8 :: dEpsPV_TRA                  
      ! real*8 :: Sact_TRA  ( MAX_STRESS   )  
      ! real*8 :: dStr_TRA  ( MAX_STRESS   )  
      ! real*8 :: dE_TRA    ( MAX_STRESS   )  
      ! real*8 :: dEc_TRA   ( MAX_STRESS   )  
      ! real*8 :: dp_TRA                      
      ! real*8 :: dSig0_TRA ( MAX_STRESS   )  
      ! real*8 :: Sig0init_TRA(MAX_STRESS  )  
      ! real*8 :: dEps0_TRA ( MAX_STRESS   )  
      ! real*8 :: TotStrain_TRA ( MAX_STRESS ) 
      ! real*8 :: voidrN_TRA                  
      ! real*8 :: voidrNx1_TRA                
      ! real*8 :: LOC_vars_TRA (12)
      ! real*8 :: NNL_vars_TRA (12)     
      ! real*8 :: Xgp_TRA   ( 3 )             
      ! real*8 :: v_TRA                       
      ! real*8 :: E_TRA                       
      ! real*8 :: Dvol_TRA                    
      ! real*8 :: he_TRA                      
      ! real*8 :: he_arr_TRA (3,2)            
      ! real*8 :: gp_weight_TRA               
      ! real*8 :: Slev_TRA                    
      ! real*8 :: xMaturity_TRA               
      ! real*8 :: dMaturityDT_TRA             
      ! real*8 :: ft_TRA                      
      ! real*8 :: YoungET_TRA                 
      ! real*8 :: YoungE0_TRA                 
      ! real*8 :: HardPC_TRA                  
      ! real*8 :: T_TRA                       
      ! real*8 :: dT_TRA                      
      ! real*8 :: T_err_TRA                   
      ! real*8 :: Hard_gamma_TRA              
      ! real*8 :: EpsVP_EQ_TRA                
      ! real*8 :: DefGrad_N_TRA     (3,3)     
      ! real*8 :: DefGrad_Nx1_2_TRA (3,3)     
      ! real*8 :: det_DefGrad_N_TRA           
      ! real*8 :: det_DefGrad_Nx1_2_TRA       
      ! real*8 :: Damage_TRA                  
      ! real*8 :: Iplas_TRA                   
      ! real*8 :: sig_eps_flag_TRA            
      ! real*8 :: StatusChar_TRA              
      ! real*8 :: igaus_TRA
      ! real*8 :: iele_TRA
      ! real*8 :: ilayer_TRA
      !
      !end type
      !
      !type currpoint_x
      !  type (HANDLE_type) :: ele_field_handle
      !  type (HANDLE_type) :: beam_cross_section_info
      !  type (HANDLE_type) :: beam_aux_objs
      !  type (HANDLE_type) :: shell_aux_objs_handle
      !end type currpoint_x

      integer*4 :: padding4b_TRA, padding4e_TRA

      common / CurrentIntPoint_ex_TRA /
     &  padding4b_TRA (16), 
     &  ele_field_handle_TRA        ,! pointer to ele_field 
     &  beam_cross_section_info_TRA ,! pointer to beam cross section info set at element level
     &  beam_aux_objs_TRA,           ! pointer to beam aux objects set at element level
     &  shell_aux_objs_handle_TRA,   ! here everything is padded to 64 bytes
     &  padding4e_TRA (8)

!$OMP THREADPRIVATE(/CurrentIntpoint_ex_TRA/)
       save /CurrentIntpoint_ex_TRA/


      ! orders to fill the commons with content of GP Buffer
      ! with values common for many mat. models

      integer*4   ITRA_NR_OF_ITEM ,
     &            ITRA_GP_SACT    ,
     &            ITRA_GP_POISS   ,
     &            ITRA_GP_IPLA    ,
     &            ITRA_GP_SLEV    ,
     &            ITRA_GP_YOUNG   ,
     &            ITRA_GP_MATURITY,
     &            ITRA_GP_DMDT    ,
     &            ITRA_GP_FT      ,

     &            ITRA_GP_YOUNG_ET,
     &            ITRA_GP_YOUNG_E0,
     &            ITRA_GP_HARD_PC,
     &            ITRA_GP_DSTRESS,
     &            ITRA_GP_HARD_GAMMA,
     &            ITRA_GP_EPSVP_EQ,
     &            ITRA_GP_DAMAGE,
     &            ITRA_GP_SIG_EPS_FLAG


      parameter ( ITRA_GP_SACT    = 1,        ! actual stress
     &            ITRA_GP_POISS   = 2,        ! actual Poisson ratio
     &            ITRA_GP_IPLA    = 4,        ! plasticity flag
     &            ITRA_GP_SLEV    = 8,        ! stress level
     &            ITRA_GP_YOUNG   =16,        ! actual young modulus
     &            ITRA_GP_MATURITY=32,        ! maturity
     &            ITRA_GP_DMDT    =64,        ! DMaturity/DTemp
     &            ITRA_GP_FT      =128,       ! ft
     &            ITRA_GP_YOUNG_ET=256,       ! Et/E0
     &            ITRA_GP_YOUNG_E0=512,       ! Et/E0
     &            ITRA_GP_HARD_PC =1024,      ! pc
     &            ITRA_GP_DSTRESS =2048,      ! d-sigma
     &            ITRA_GP_HARD_GAMMA=4096,    ! Gamma
     &            ITRA_GP_EPSVP_EQ=8192,      ! EpsPVP_EQ
     &            ITRA_GP_DAMAGE  =16384,     ! D
     &            ITRA_GP_SIG_EPS_FLAG =32768,! post peak flag 0/1-in tension/2-in compression - bit code in general
     &            ITRA_NR_OF_ITEM = 18)       ! nr of all items


!MS$DEFINE __TRANS_INC
!MS$ENDIF