!MS$IF DEFINED (__CUSTOM_LMS)

c PRO_GetFromDat ( props,IPRO_FLOW_MAX+1) -> LTF for k(T)

c ====================================================================================
      subroutine FSS_MakePearmTempDependent ( ki,Ndm,TisGiven,T,props,M)
c ====================================================================================
!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLEXPORT :: FSS_MakePearmTempDependent   
!MS$ END IF

c  ki [Ndm] - permeability coefficients in principal permeability directions
c  Ndm      - space dimension
c  T        - temperature
c  props    - array of properties
c ------------------------------------------------------------------------------------
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\anal_enu.inc'
      integer*4 :: Ndm
      real*8    :: ki (Ndm),T,props (*)
	integer*4 :: M(*) ! data space
      logical*4 :: TisGiven
      real*8    :: PRO_GetFromDat,RLTF_Value,ANA_RealInfo
      integer*4 :: i,ltf
      real*8    :: kofTMultiplier,Time

      ! ki = ki * LTF ( T(t) )
      ! there are two possibilities to make k dependent on T
      ! a) through LTF ( T(t) )
      ! b) through constitutive function based on some parameters

      ! ATTENTION : this function can be combined only with user supplied model
      ! in which group of FLOW parameters is expanded according to user wishes.
      ! Be careful to not to refer outside declared range (via zsoil.usm script
      ! file)

      ! here set multiplier for ki coefficients
      ltf  = PRO_GetFromDat (props,IPRO_GR_FLOW,IPRO_FLOW_MAX+1)
      if ( TisGiven ) then
        if ( ltf.le.0 ) then 
          kofTMultiplier = 1.0d0
        else
          kofTMultiplier = RLTF_Value( T,ltf,M )
        end if
      else
        kofTMultiplier = 1.0d0
      end if

      call MAT_axfactor ( ki,Ndm,kofTMultiplier,ki )

      return
      end

c ====================================================================================
      subroutine ftr_set_source_term (Shape,dVolu,Q,Nen,props,SatCoeff,
     &                                dT )
c ====================================================================================
!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLEXPORT :: ftr_set_source_term   
!MS$ END IF

c add source term related to fluid dilatancy induced by thermal effects
c            n S alpha-F delta(T)
c this procedure is called for given gauss point
c Shape (Nen) - array of shape functions for given gauss point (IN)
c dVolu       - dV for given gauss point                       (IN)
c Q     (Nen) - temporary rhs array which accumulates source term (IN/OUT)
c Nen         - nr of element nodes                            (IN)
c props       - array of material properties                   (IN)
c SatCoeff    - actual saturation coefficent                   (IN)
c dT          - increment of temperature at given gauss point  (IN)

      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\heat.inc'


      real*8    :: Shape (*),Q (*),props (*),dVolu,SatCoeff
      integer*4 :: Nen
      real*8    :: dT,multiplier
      real*8    :: VoidR,Porosity,alphaFT
      real*8    :: PRO_GetFromDat

      VoidR = PRO_GetFromDat (props,IPRO_GR_DENS,IPRO_DENS_VOIDR   )
      Porosity = VoidR / ( 1.0d0 + VoidR )

      alphaFT  = PRO_GetFromDat ( props,IPRO_GR_HEAT,IPRO_HEAT_MAX+1)
      multiplier = Porosity * SatCoeff * alphaFT * dT * dVolu

      ! accumulate on Q at given gauss point
      ! Qi = Ni * n S alpha-F delta(T) (summation over gauss points)
      call MAT_addmultvec ( Q,multiplier,Shape,Nen )

      return 
      end

!MS$ENDIF
