
c =======================================================================================
      subroutine SUM_Models( model, order, props, gp_buff, 
     &                       infoIn, infoOut, domain)
c =======================================================================================
!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLEXPORT :: SUM_Models   
!MS$ END IF


      include '..\src\nodecl.inc'
      include '..\src\models.inc'
      include '..\src\prop.inc'

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /PRO_models_common/   
!MS$ END IF
!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /PRO_groups_common/   
!MS$ END IF
!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /PRO_common/   
!MS$ END IF
      
      integer*4 :: order        ! action index to be performed for this gauss point
      integer*4 :: model         ! model index
      real*8    :: props   (*)   ! array with properties
      integer*4 :: gp_buff (*)   ! gauss point internal storage
      integer*4 :: infoIn  (*)   ! input buffer
      integer*4 :: infoOut (*)   ! output buffer
      integer*4 :: domain       (*)   ! whole data space
      character*10 xxx

      xxx = PRO_TypeCharIdArray( model)
     
      select case (PRO_TypeCharIdArray(model))

        case ('     USER1')
          call USR1_Model (order, props, gp_buff, infoin, infoout, 
     &                     domain)
        case ('      PEAB')
         call PEAB_Model  (order, props, gp_buff, infoin, infoout, 
     &                     domain)
        case ('  FIBER-1D')
          ! here we call the 1D fiber model to be used in beam elements 
         call FIBER_1D_Model (order, props, gp_buff, infoin, infoout, 
     &                     domain)
        case ('      SHLE')
c         call SHLE_Model  (iorder,Props,IGPbuff,InfoIn,InfoOut,M)
        case ('      ANSL')
         call ANSL_Model  (order, props, gp_buff, infoin, infoout, 
     &                     domain)
        !case ('    ANSL36')
        ! call ANSL36_Model  (order,Props,IGPbuff,InfoIn,InfoOut,M)
        case default
          call SYS_Stop ("USER_Models internal error : undefined model")

      end select

      end subroutine SUM_Models


