c -------------------------------------------------------------------------
c here is a constitutive module template 
c Fortran 90/77 syntax is used here 
c
c anisotropic elasticity model for continuum
c 
c
c statements with comment DON'T EDIT cannot be removed !
c
c state parameters like stresses, plastic strains etc... are kept in a continuos memory 
c block called model_buff (*) which is an INT*4 array (*)
c 
c -------------------------------------------------------------------------



c==========================================================================
      subroutine  ANSL_Model (order, props, model_buff, InfoIn, InfoOut,
     &                        domain)
c--------------------------------------------------------------------------

!
!!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
!  !MS$ ATTRIBUTES DLLIMPORT :: /dat_common/   
!!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /JOB_common/
!MS$ END IF

!!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
!  !MS$ ATTRIBUTES DLLIMPORT :: /ELE_common/
!!MS$ END IF
!
!!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
!  !MS$ ATTRIBUTES DLLIMPORT :: /ELE_current/
!!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /CentralPoint_TRA/   
!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /CurrentIntpoint_TRA/ 
!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /pointers_TRA/ 
!MS$ END IF



      include '..\src\nodecl.inc'
      include 'ansl.inc'             ! your private common block

      !include '..\src\elgeo.inc'       ! element geometry
      include '..\src\prop.inc'        ! enums for material parameters predefined in
                                       ! original system prior adding user model
                                       ! plus enums for material level actions

      include '..\src\position.inc'    ! enums for stress/strain components

      include '..\src\trans.inc'       ! transfer common block through which the communication, 
                                       ! between finite element and gauss point, is performed

      include '..\src\dat.inc'         ! structure which describes element/gauss points storage

      include '..\src\job.inc'         ! parametrization parameters like nr of stress 
                                ! components for all job types like (3D, plane strain etc...) 
                                ! plus job enums

      integer*4 :: order
      real*8    :: Props     (*)   ! property data
      integer*4 :: model_buff (*)   ! model storage 
      
      integer*4 :: InfoIn    (*),  ! additonal input (it may change meaning for -> iorder)
     &             InfoOut   (*)   ! additional output
      integer*4 :: domain (*)           ! whole data space

      integer*4 :: nstre, offs, iGpsize
      integer*4 :: ANSL_SetGpAdr ! function which sets up nr of parameters to be kept
                                   ! for single gauss point both for old and new 
                                   ! configuration of equilibrium

      real*8    :: PRO_GetFromDat
      real*8    :: E,v
      integer*4 :: i,k,iorderTmp2,ret
      real*8    :: T
      logical*4 :: TisGiven
      real*8    :: De (36)
      integer*4 :: MAT_InvertMtrx
      integer*4 :: p_ (max_ANSL)
      
!!MS$IF DEFINED (__X64)      
!      integer*8 :: IBUF_EleHandleGet
!!MS$ELSE      
!      integer*4 :: IBUF_EleHandleGet
!!MS$ENDIF      
!      integer*4 :: this_BUF (*)
!      pointer (iptr,this_BUF)                        
      
      Nstre = JOB_NrOfStressComp (Itype_JOB) ! sets nr of of stress components for assumed job
                                             ! DON'T EDIT
      iGpsize = ANSL_SetGpAdr    ( p_, nstre   ) ! set pointers to state parameters

      select case (order)

        ! --------------------
        case( L_GP_UPD_STATE )
        ! --------------------
          ! here you have to update state parameters like stresses, 
          ! plastic strains, hardening parameters, etc.............

          offs = MODofs_DAT (MOD_ALL_DAT) ! offset in model storage buffer 
                                          ! DON'T EDIT

          ! here update stress state :  old <= new 
          call UTL_move ( model_buff ( offs + p_ (stress_n_ANSL)),
     &                    model_buff ( offs + p_ (stress_nx1_ANSL)),
     &                    nstre )

          ! here update plastic status parameter :  old <= new 
          call UTL_move ( model_buff ( offs + p_(plas_code_n_ANSL)),
     &                    model_buff ( offs + p_(plas_code_nx1_ANSL)),
     &                    1 )

          ! return actual plastic status (obligatory !) through transfer common block
          ! defined in trans.inc include file
          Iplas_TRA = model_buff ( offs + p_(plas_code_nx1_ANSL)) 

        ! --------------------
        case( L_GP_NEW_STATE )
        ! --------------------
           ! compute new state for given effective strain increment dE_TRA
           !         (dE_TRA = dE - dEo - dEcr)
           !         where dE   - total strain increment
           !         where dE0  - initial strain increment
           !         where dEcr - creep strain increment
           !                             initial stress increment   dSig0_TRA
           !                             initial elastic moduli     Dev_TRA
           ! note : for models with constant elastic stiffness with activated creep
           !        an elastic moduli matrix is modified through creep module
           !        and thus the one given in Dev_TRA (via transfer common block
           !        defined in trans.inc file) should be used here;
           !        however, it is obvious that for models with variable elastic stiffness
           !        the creep (in actual form!) cannot be activated and elastic moduli are not 
           !        constant anymore so this input data should be simply ignored
           !        
           offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT


           TisGiven = (T_err_TRA == 0)
           T = 0.0d0
           if ( T_err_TRA == 0 ) then
             T = T_TRA
           end if
             

           call ANSL_NewState ( Dev_TRA,
     &             model_buff  (offs + p_ (stress_n_ANSL)),
     &             model_buff  (offs + p_ (stress_nx1_ANSL)),
     &             model_buff  (offs + p_(plas_code_n_ANSL)),
     &             model_buff  (offs + p_(plas_code_nx1_ANSL)),
     &             model_buff ( offs + p_(stress_lev_ANSL)),
     &             dE_TRA, dSig0_TRA, nstre, Dep_TRA, props,
     &             T, TisGiven, domain )

           ! copy computed new stress state from internal storage to array Sact_TRA 
           ! (which is in common block defined in trans.inc file )
           
           call UTL_move ( Sact_TRA,
     &               model_buff (offs+p_ (stress_nx1_ANSL)),nstre) 

        ! --------------------
        case( L_GP_INI_STATE )
        ! --------------------
          offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT

          ! initialization of state parameters
          ! nulify all your arrays

          call UTL_clear ( model_buff ( offs+p_ (stress_nx1_ANSL))   ,
     &                     nstre)
          call UTL_clear ( model_buff ( offs+p_ (stress_n_ANSL)),
     &                     nstre)
          call UTL_iclear( model_buff ( offs+p_(plas_code_n_ANSL))  , 1)
          call UTL_iclear( model_buff ( offs+p_(plas_code_nx1_ANSL)), 1)
          call UTL_clear ( model_buff ( offs+p_(stress_lev_ANSL)) , 1)

        ! --------------------
        case( L_GP_SIZE      )
        ! --------------------
          
          ! return through output buffer the ammount of INT*4 words needed
          ! to save all your state parameters (the float values keep always
          ! as real*8 words which is equivalent to 2 words of INT*4 

          InfoOut (MOD_ALL_DAT) = iGPsize ! DON'T EDIT

        ! --------------------
        case( L_GP_IFSYM     )
        ! --------------------

          ! return the information whether your tangent stiffness matrix 
          ! is symmetric (if yes put 1 and if not put 0)

          InfoOut (1) = 1    

        ! --------------------
        case( L_GP_SETDELA   )
        ! --------------------
          ! return the actual elastic stiffness  constitutive matrix D
          ! through the output buffer
          ! if the elastic stiffness is a function of stress 
          ! then perform an action:
          !
          ! offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT
          ! compute stiffness matrix based on actual stress
          ! kept in ->         model_buff ( offs+p_ (stress_nx1_ANSL))
          
          ! and return in via -> InfoOut buffer
          call ANSL_set_DE ( props,nstre,InfoOut (1) )

        ! --------------------
        case( L_GP_SETCELA   )
        ! --------------------
          ! return the actual elastic compliance constitutive matrix C
          ! through the output buffer

          ! if the elastic stiffness is a function of stress 
          ! then perform an action:
          !
          ! offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT
          ! compute compliance matrix based on actual stress
          ! kept in ->         model_buff ( offs+p_ (stress_nx1_ANSL))

          ! compute elastic compliance matrix based on E & v (in this case)
          ! and return in via -> InfoOut buffer

          call ANSL_set_DE ( props,nstre,De ) 
          ret = MAT_InvertMtrx ( De,nstre,nstre,InfoOut (1) )
          if ( ret.ne.0 ) then
            call sys_stop("Singular stiffness matrix for anisotropic ela
     &sticity - De ")
          end if

        ! --------------------
        case( L_GP_PRINTPARAM )
        ! --------------------
          ! print out the input data
          call ANSL_PrintProps (Props, InfoIn)

        ! --------------------
        case (L_GP_GET_INFO)
        ! --------------------
          ! return through transfer common block (see trans.inc file)
          ! all requested requested results/data
          k = 1
          do while (k.le.ITRA_NR_OF_ITEM)
            iorderTmp2 = ishft(1,k-1)
            if( iand(InfoIn(1), iorderTmp2) .ne. 0 ) then
              select case (iorderTmp2)

                case ( ITRA_GP_SACT )
                  ! return actual stress state copying it from internal storage
                  ! to Sact_TRA array (from transfer coomon block)
                  offs  = MODofs_DAT (MOD_ALL_DAT)
                  call UTL_move ( Sact_TRA,
     &                     model_buff (offs+p_ (stress_nx1_ANSL)),Nstre)

                case ( ITRA_GP_POISS )
                  ! return actual value of Poisson coefficient
                  ! by copying its value to v_TRA variable
                  ! (from transfer coomon block)
                  v_TRA = 0.0d0
                  
                case ( ITRA_GP_IPLA )
                  ! return actual value of plastic status+
                  ! by copying its value to Iplas_TRA variable
                  ! (from transfer coomon block)
                  offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT

                  Iplas_TRA = model_buff ( offs+p_(plas_code_nx1_ANSL))
                  StatusChar_TRA ='  E  '

                case ( ITRA_GP_SLEV )
                  ! return actual value of stress level
                  ! by copying its value to SLev_TRA variable
                  ! (from transfer coomon block)
                  call UTL_move ( Slev_TRA,
     &                     model_buff (offs+p_(stress_lev_ANSL)),1 )
                case ( ITRA_GP_YOUNG)
                  ! return actual value of Young modulus
                  ! by copying its value to E_TRA variable
                  ! (from transfer coomon block)
                  E_TRA = 0.0d0
                case default
                  continue 
              end select
            end if
            k=k+1
          end do

        ! --------------------
        case ( L_GP_MODIFPARAM )
        ! --------------------
          ! here you can make modification of material parameters due to
          ! stability analysis
          ! call ANSL_ModifParam ( props,InfoIn )

        ! --------------------
        case ( L_GP_SET_INCOMP)
        ! --------------------
          ! do nothing here 

        ! --------------------
        case ( L_GP_FORM_DESCR ) 
        ! --------------------
          ! do nothing here 

        ! --------------------
        case default
        ! --------------------
          ! do nothing here 

      end select

      return
      end subroutine ANSL_Model


c=====================================================================
      integer*4 function ANSL_SetGpAdr( p_, nstre)
c---------------------------------------------------------------------
c  returns size of single gauss point GP storage for this material model
c  sets up pointers to certain information likestress arrays etc...
c  and saves these pointers in coomon block cpecific for this material model
c  called ansl.inc
c---------------------------------------------------------------------
      use LPTR_profiler
      include '..\src\nodecl.inc'
      include 'ansl.inc' 

      integer*4 :: nstre           ! nr of stress components     (IN)
      integer*4 :: p_ (max_ANSL)
      integer*4 :: size           ! storage size in INT*4 words (AUX)
      type (LPTR_PtrsOrganizer) :: myPtrs


      call LPTR_new (myPtrs) ! do not edit !
        ! pointer to array of new stress state with size -> nstre of REAL*8 words 
        ! as the state parameters storage is always expressed in INT*4 words
        ! in call to function MEM_NextPos we put first parameter equal to nstre
        ! and the second equal to 2 which indicates that each value ocuppies 
        ! 2 x INT*4 words (which is equal to 1 REAL*8 word)

      ! pointer to new stress state
      p_ ( stress_nx1_ANSL) = LPTR_next (myPtrs, nstre * 2) 

      ! pointer to array of old stress state
      p_ ( stress_n_ANSL) = LPTR_next (myPtrs, nstre * 2) 

      ! pointer to "new" plastic status parameter (1 x INT*4 ) word
      p_ ( plas_code_nx1_ANSL) = LPTR_next (myPtrs, 1) 

      ! pointer to "old" plastic status parameter (1 x INT*4 ) word
      p_ ( plas_code_n_ANSL) = LPTR_next (myPtrs, 1) 

      ! pointer to stress level
      p_ ( stress_lev_ANSL) = LPTR_next (myPtrs, 2) 

        ! retrieve size of requested storage for state parameters
      size  = LPTR_size (myPtrs) ! DON'T EDIT

      ANSL_SetGpAdr = size

      return
      end function ANSL_SetGpAdr


c=================================================================
      subroutine ANSL_NewState( De,Sold,Snew,iPlasOld,iPlasNew,
     &                 StressLevel,
     &                 dEps,dSig0,Nstre,Dep,props,T,TisGiven,M )
c-----------------------------------------------------------------
c this routine computes new stress Snew 
c and corresponding tangent matrix Dep for simple J2 plasticity model
c of form   F = sqrt(J2) - c = 0
c with plastic potential Q = sqrt(J2)

      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include 'ansl.inc'
  
      integer*4 :: nstre

      integer*4 :: iPlasOld           ! old plastic status (IN)
      integer*4 :: iPlasNew           ! new plastic status (OUT)

      real*8    ::  De   (nstre,*),   ! elastic const. matrix (IN)
     &              Sold (nstre  ),   ! old stress state (IN)
     &              Snew (nstre  ),   ! new stress state (OUT)
     &              dEps (nstre  ),   ! strain increment (IN)
     &              dSig0(nstre  ),   ! initial stress increment (IN)
     &              Dep  (nstre,*),   ! tangent constitutive matrix (Dep) (OUT)
     &              props(*),         ! array with properties (IN)
     &              T       ,         ! actual temperature
     &              StressLevel       ! actual stress level (OUT)

      logical*4 ::  TisGiven
      integer*4 ::  M(*)
      real*8    ::  tmp (6)

      ! compute trial stress increment : De * dEps
      call MAT_axb ( De,nstre,nstre,dEps,1,tmp )

      ! compute trial stress state  SigT = De * dEps + SigOld  
      call MAT_addvec ( Sold,tmp,tmp,nstre  )
 
      ! add initial stress increment SigT = De * dEps + SigOld + dSig0
      call MAT_addvec ( tmp,dSig0,tmp,nstre )

      call UTL_move ( Snew,tmp,nstre  )
      call UTL_move ( Dep,De,nstre*nstre )
      iPlasNew = 0 ! means elastic
      
      end subroutine ANSL_NewState




c========================================================================
      subroutine ANSL_PrintProps( Props, InfoConst )
c------------------------------------------------------------------------
c calls functions to print parameters for all material data groups
c for nonactive groups use dummy PRO_DummyPrint   function

      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\propname.inc'

      real*8    :: Props     (*)
      integer*4 :: InfoConst (*)

  ! function to deal with each group of properties in this model
      external  PRO_MainPrint,
     &          PRO_DensPrint,
     &          ANSL_ElasticPrintParam,
     &          PRO_DummyPrint,
     &          ANSL_FlowPrintParam,
     &          CRE_PrintParam,
     &          ANSL_NonlPrintParam,
     &          ANSL_HeatPrintParam,
     &          HUM_PrintParam,
     &          PRO_InisPrint,
     &          PRO_LocStabPrint,
     &          PRO_DampPrint

       call PRO_PrintParam( Props, InfoConst ,
     &          'USER MODEL - ANISOTROPIC ELASTICITY',
     &          PRO_MainPrint,      ! function which prints parameters from group MAIN (standard)
     &          PRO_DensPrint,      ! function which prints parameters from group DENS (standard)
     &          ANSL_ElasticPrintParam,! function which prints parameters from group ELAS
     &          PRO_DummyPrint,     ! dummy function which does nothing
     &          ANSL_FlowPrintParam,! function which prints parameters for group FLOW
     &          CRE_PrintParam,     ! function which prints parameters for group CREEP (standard)
     &          ANSL_NonlPrintParam,! function which prints parameters for group NONL
     &          ANSL_HeatPrintParam,! function which prints parameters for group HEAT
     &          HUM_PrintParam,     ! function which prints parameters for group HUMI (standard)
     &          PRO_InisPrint,      ! function which prints parameters for group INIS (standard)
     &          PRO_LocStabPrint,   ! function which prints parameters for group LSTAB(standard)
     &          PRO_DampPrint,      ! 
     &          PRO_DummyPrint)     ! 

      return
      end

c==================================================================
      subroutine  ANSL_ElasticPrintParam( ifile,props)
c------------------------------------------------------------------
c print elastic parameters
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\prnline.inc'

      integer*4 :: ifile
      real*8    :: props(*)
      real*8    :: De (6,6)
      integer*4 :: i,j
      type (print_line_struct_type) :: line

      call ANSL_set_DE ( props,6,De )
      call IO_BeginLine_ex (line)
      call IO_AddStrToLine_ex  (line, 'De - matrix',11 ) 
      call IO_EndLine_ex       (line, ifile ) ! flush the line      
 
      do i=1,6
        call IO_BeginLine_ex (line)
        do j=1,6
          call IO_AddR8ToLine_ex (line, De (i,j) )                 
        end do
        call IO_EndLine_ex       (line, ifile ) 
      end do         

      return
      end

c==================================================================
      subroutine  ANSL_FlowPrintParam( ifile,props)
c------------------------------------------------------------------
c print flow parameters
c------------------------------------------------------------------
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'

      integer*4 :: ifile
      real*8    :: props(*),tmp
      real*8    :: PRO_GetFromDAT 

      ! here we add some parameters to FLOW data so first we print standard 
      ! parameters and then ours
      call FLU_PrintParam (ifile,props )      

      ! here we put our extra parameters

      return
      end

c==================================================================
      subroutine  ANSL_HeatPrintParam( ifile,props)
c------------------------------------------------------------------
c print heat parameters
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\heat.inc'

      integer*4 :: ifile
      real*8    :: props(*),tmp
      real*8    :: PRO_GetFromDAT 

      ! here we add some parameters to HEAT data so first we print standard 
      ! parameters and then ours
      call HEA_PrintParam (ifile,props )      

      ! here we put our extra parameters

      return
      end


c==================================================================
      subroutine  ANSL_NonlPrintParam( ifile,props)
c------------------------------------------------------------------
c print nonlinear parameters
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include 'ansl.inc'

      integer*4 :: ifile
      real*8    :: props(*),tmp
      real*8    :: PRO_GetFromDAT 

      ! nonlinear parameters

      ! here we put our parameters
      ! ..... and so on

      return
      end




c ===================================================================
      subroutine ANSL_set_DE ( props,nstre,De )
c ===================================================================      
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include 'ansl.inc'  
      integer*4 :: nstre
      real*8    :: props (*)
      real*8    :: De (nstre,nstre)    
      real*8    :: DeTMP (6,6)
      integer*4 :: i,j,k
      real*8    :: aux
      real*8    :: PRO_GetFromDat
      
      k = 0
      do i=1,6
        do j=1,6
          k = k + 1
          aux = PRO_GetFromDat (props,IPRO_GR_ELAS,k)      
          DeTMP (i,j) = aux
          DeTMP (j,i) = aux
        end do
      end do
      
      De (1:nstre,1:nstre) = DeTMP (1:nstre,1:nstre)
            
      end subroutine ANSL_set_DE 