c==========================================================================
c--------------------------------------------------------------------------
c==========================================================================
      module PEAB_module
c==========================================================================
c--------------------------------------------------------------------------
c==========================================================================
  
      integer*4, parameter :: PEAB_ELAS_K1   = 1,
     &                        PEAB_ELAS_K2   = 2,
     &                        PEAB_ELAS_K3   = 3,
     &                        PEAB_ELAS_K4   = 4,
     &                        PEAB_ELAS_v    = 5,
     &                        PEAB_ELAS_pref = 6,
     &                        PEAB_ELAS_pL   = 7,
     &                        PEAB_ELAS_xsi  = 8,
     &                        PEAB_ELAS_xo   = 9,
     &                        PEAB_ELAS_MAX  = 9

      integer*4, parameter :: PEAB_NONL_PHI  = 1,
     &                        PEAB_NONL_PSI  = 2,
     &                        PEAB_NONL_C    = 3,
     &                        PEAB_NONL_MAX  = 3

      integer*4, parameter :: MAX_STRESS_PEAB     = 6

      type MatProperties_PEAB
        ! input data
        real*8 :: K1,K2,K3,K4,v,pref,pL,xsi,xo ! elastic
        real*8 :: a1,a2,b1,b2
        real*8 :: phi,psi,c,ak,aphi,apsi,pAppex
      end type MatProperties_PEAB

      type StateParameters_PEAB
        real*8 :: Stress (MAX_STRESS_PEAB) 
        real*8 :: p0,q0
        real*8 :: s0     (MAX_STRESS_PEAB) 
        real*8 :: Strain (MAX_STRESS_PEAB)
        real*8 :: initialized  ! flag whether stress state was already updated
        real*8 :: plasticFlag
      end type StateParameters_PEAB

      ! active stress componenets for deviatoric mechanisms

      ! tollerance to detect almost zero strain state
      real*8, parameter :: PEAB_EPS_TOL = 1.0d-10
      real*8, parameter :: ONE_THIRD = 1.0d0/3.0d0
      real*8    :: R_PEAB   (MAX_STRESS_PEAB)
      real*8    :: R_1_PEAB (MAX_STRESS_PEAB)

      data R_PEAB   / 1.0d0,1.0d0,2.0d0,1.0d0,2.0d0,2.0d0 /
      data R_1_PEAB / 1.0d0,1.0d0,0.5d0,1.0d0,0.5d0,0.5d0 /


      character*8 ElasticProps_PEAB (PEAB_ELAS_MAX)
      data ElasticProps_PEAB / "K1    =  ",
     &                         "K2    =  ",
     &                         "K3    =  ",
     &                         "K4    =  ",
     &                         "v     =  ",
     &                         "pref  =  ",
     &                         "pL    =  ",
     &                         "xsi   =  ",
     &                         "xo    =  " /

      character*8 NonlProps_PEAB (PEAB_NONL_MAX)
      data NonlProps_PEAB    / "PHI (deg) =  ",
     &                         "PSI (deg) =  ",
     &                         "C         =  "/

      real*8, parameter :: ETA_SMALL_TOL = 1.0d-10

      !xxxxxxxx
      !--------
      contains
      !--------
      !xxxxxxxx


      ! ===========================================================================
      integer*4 function PEAB_StateStorageSizeI4words (nstre)
      ! ===========================================================================
      include 'nodecl.inc'
      integer*4, intent (in) :: nstre

      ! storage size for stateN and Nx1 (actual stress dimension is taken into account)
      PEAB_StateStorageSizeI4words = 2 * (nstre*2 + nstre*2 + nstre*2 +
     &                                    2+2+2+2)

      end function PEAB_StateStorageSizeI4words


      ! ===========================================================================
      subroutine PEAB_unpack_props (props,Mat)
      ! ===========================================================================
      include 'nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\math.inc'
      include '..\src\cap.inc'

      real*8, intent (in) :: props(*) 
      type (MatProperties_PEAB), intent (out) :: Mat

      real*8    :: PRO_GetFromDAT
      real*8    :: sinphi,sinpsi,tgpsi,cosphi,aphi3
      real*8    :: adjust,alpha,beta

      
      Mat % K1 = PRO_GetFromDAT ( props,IPRO_GR_ELAS,PEAB_ELAS_K1)
      Mat % K2 = PRO_GetFromDAT ( props,IPRO_GR_ELAS,PEAB_ELAS_K2)
      Mat % K3 = PRO_GetFromDAT ( props,IPRO_GR_ELAS,PEAB_ELAS_K3)
      Mat % K4 = PRO_GetFromDAT ( props,IPRO_GR_ELAS,PEAB_ELAS_K4)
      Mat % v  = PRO_GetFromDAT ( props,IPRO_GR_ELAS,PEAB_ELAS_v)
      Mat % pref=PRO_GetFromDAT ( props,IPRO_GR_ELAS,PEAB_ELAS_pref)
      Mat % pL = PRO_GetFromDAT ( props,IPRO_GR_ELAS,PEAB_ELAS_pL)
      Mat % xsi= PRO_GetFromDAT ( props,IPRO_GR_ELAS,PEAB_ELAS_xsi)
      Mat % xo = PRO_GetFromDAT ( props,IPRO_GR_ELAS,PEAB_ELAS_xo)

      alpha = (Mat%xo/Mat%pref)**Mat%K4
      beta  = alpha*Mat%K4/Mat%xo
      Mat % a1 = -(2.0d0*alpha-Mat%xo*beta)/Mat%xo**3
      Mat % a2 =  (3.0d0*alpha-Mat%xo*beta)/Mat%xo**2

      Mat % b1 = -Mat % a1
      Mat % b2 =  Mat % a2

      Mat % phi = PRO_GetFromDAT ( props,IPRO_GR_NONL,PEAB_NONL_PHI)
      Mat % psi = PRO_GetFromDAT ( props,IPRO_GR_NONL,PEAB_NONL_PSI)
      Mat % c   = PRO_GetFromDAT ( props,IPRO_GR_NONL,PEAB_NONL_C  )

      adjust = IDP_PSTRN_ADJUST
      sinphi = sin( Mat % phi / R_MAT_DRG )
      sinpsi = sin( Mat % psi / R_MAT_DRG )
      tgpsi  = tan( Mat % psi / R_MAT_DRG )
      cosphi = cos( Mat % phi / R_MAT_DRG )

      call DP_adjustEx ( adjust,sinphi,sinpsi,
     &                   tgpsi,cosphi,Mat % c,
     &                   Mat % v,Mat % aphi,Mat % apsi,Mat % ak )

      if ( Mat % aphi.ge.R_MAT_SMALL ) then
        aphi3 = 3.0d0*Mat % aphi
        Mat % pAppex = Mat % ak / aphi3
      else
        Mat % pAppex = 1.0d99
      end if


      end subroutine PEAB_unpack_props


c ===================================================================
      real*8 function PEAB_StrLevel ( Mat,strsi,nstre )
c ===================================================================
      include '..\src\nodecl.inc'
      include '..\src\math.inc'
      include '..\src\vref.inc'

      type (MatProperties_PEAB) :: Mat
      integer*4 :: nstre
      real*8 :: strsi(nstre),s(6),xsqrtJ2,xI1,tmp,sl
      real*8 :: get_J2,get_I1

      xsqrtJ2 = sqrt ( get_J2 (strsi,s,nstre) )
      xI1 = get_I1 ( strsi,nstre )
      tmp = Mat%ak - Mat%aphi * xI1

      if ( dabs(tmp)/press_REF.le.R_MAT_SMALL ) then
        sl = 1.0d0
      else
        sl = xsqrtJ2 / tmp
      end if

      sl = dmax1 ( 0.0d0,sl )
      sl = dmin1 ( 1.0d0,sl )

      PEAB_StrLevel = sl

      return
      end function PEAB_StrLevel


      ! ===========================================================================
      subroutine PEAB_CopyLeftToRight (a,b,n)
      ! ===========================================================================
      include 'nodecl.inc'
 
      integer*4 :: n,a(n),b(n)

      b = a

      end subroutine PEAB_CopyLeftToRight

      ! ===========================================================================
      subroutine PEAB_CopyRightToLeft (a,b,n)
      ! ===========================================================================
      include 'nodecl.inc'
 
      integer*4 :: n,a(n),b(n)

      a = b

      end subroutine PEAB_CopyRightToLeft


      ! ===========================================================================
      subroutine PEAB_repack_state (buff,offs,state,nstre,CopyProc)
      ! ===========================================================================
      use LPTR_profiler
      include 'nodecl.inc'
      integer*4,                  intent (in )   :: buff (*)
      integer*4,                  intent (in )   :: offs
      type (StateParameters_PEAB), intent (inout) :: state
      integer*4,                  intent (in )   :: nstre
      external CopyProc

      integer*4 :: i,j,k
      real*8, pointer :: tmpPTR (:)

      type (LPTR_PtrsOrganizer) :: myPtrs

      call LPTR_newWithOffs ( myPtrs,offs )
      
      k = LPTR_next   (myPtrs,nstre*2 ) 
      call CopyProc   (state % Stress,buff (k),nstre*2 )

      k = LPTR_next   (myPtrs,nstre*2 ) 
      call CopyProc   (state % Strain,buff (k),nstre*2 )

      k = LPTR_next   (myPtrs,nstre*2 ) 
      call CopyProc   (state % s0,buff (k),nstre*2 )

      k = LPTR_next   (myPtrs,      2 ) 
      call CopyProc   (state % p0,buff (k),2 )

      k = LPTR_next   (myPtrs,      2 ) 
      call CopyProc   (state % q0,buff (k),2 )

      k = LPTR_next   (myPtrs,2 ) 
      call CopyProc   (state % initialized,buff(k),2 )

      k = LPTR_next   (myPtrs,2 ) 
      call CopyProc   (state % plasticFlag,buff(k),2 )

      end subroutine PEAB_repack_state


      ! ======================================================================
      real*8 function PEAB_getE (Stress,nstre,p0,q0,initialized,Mat )
      ! ======================================================================
      include 'nodecl.inc'
      include '..\src\math.inc'
      integer*4 :: nstre
      real*8    :: Stress (nstre),p0,q0,initialized
      type (MatProperties_PEAB), intent (in) :: Mat
      real*8    :: p,q,E,dEs_dp,dEs_dq
      integer*4 :: initDone
      real*8    :: CEQ_get_px,CEQ_get_qx ! ,PEAB_getEs

      initDone = initialized

      if ( initDone.eq.0 ) then
        E = PEAB_getEs (p0,q0,q0,Mat,dEs_dp,dEs_dq)
      else
        p =  CEQ_get_px ( Stress,nstre )
        q =  CEQ_get_qx ( Stress,nstre )
        E =  PEAB_getEs (p,q,q0,Mat,dEs_dp,dEs_dq)
      end if
      PEAB_getE = E

      end function PEAB_getE


      ! ======================================================================
      subroutine PEAB_InitStateParameters (StateN,StateNx1,nstre,Sig0,
     &                                    Mat)
      ! ======================================================================
      include 'nodecl.inc'
      integer*4, intent(in) :: nstre
      real*8, intent(in)    :: Sig0 (nstre)
      type (StateParameters_PEAB), intent (inout) :: StateNx1,StateN
      type (MatProperties_PEAB  ), intent (in   ) :: Mat
      real*8    :: CEQ_get_px,CEQ_get_qx

      StateNx1%p0 = CEQ_get_px ( Sig0,nstre )
      StateNx1%q0 = CEQ_get_qx ( Sig0,nstre )
      call CEQ_get_deviator    ( Sig0,StateNx1%s0,nstre )
      StateNx1%initialized = 0.0d0
      StateNx1%Strain (1:nstre) = 0.0d0
      StateNx1%Stress (1:nstre) = 0.0d0
      StateNx1%plasticFlag      = 0.0d0
      StateN = StateNx1

c      if (dabs(StateN%s0(1)-StateN%s0(4)).gt.1.0d-4)then
c        continue
c      end if 

      end subroutine PEAB_InitStateParameters


      ! ======================================================================
      subroutine PEAB_NewStressState (StateN,StateNx1,nstre,Mat,
     &                                dSig0,dEpsNx1,dEpsPNx1,De,Dep,
     &                                Ks,Gs)
      ! ======================================================================
      use CEQ_utility
      include 'nodecl.inc'
      include '..\src\math.inc'
      include '..\src\anal_enu.inc'
      
      integer*4, intent (in) :: nstre
      real*8, intent (in)    :: dEpsNx1    (nstre),dEpsPNx1    (nstre),
     &                          dSig0 (nstre)
      real*8, intent (inout) :: De (nstre,nstre),Dep(nstre,nstre),
     &                          Ks,Gs

      type (StateParameters_PEAB), intent (inout) :: StateN
      type (StateParameters_PEAB), intent (inout) :: StateNx1
      type (StateParameters_PEAB)                 :: StateNx1Save
      type (MatProperties_PEAB  ), intent (in   ) :: Mat

      integer*4 :: initDone,iter,status,i
      real*8    :: q0,s0(MAX_STRESS_PEAB),s(MAX_STRESS_PEAB),
     &             devStrain(MAX_STRESS_PEAB),EpsDNx1,EpsVNx1,pN,qN,
     &             Stress(MAX_STRESS_PEAB),w1,p,q,EpsDN,EpsVN,p0

      integer*4 :: IANA_IntInfo
      real*8    :: ANA_RealInfo,CEQ_get_qx,CEQ_get_px,CEQ_get_I1,
     &             CEQ_get_EpsD,CEQ_get_EpsV
      logical*4 :: done
      real*8    :: dEpsVnx1,p1,p2,tmpG,tmpK


      StateNx1 = StateN
      initDone = StateNx1 % initialized 
      if ( IANA_IntInfo ( IANA_PROCESS_ACT ).eq.IANA_INI_STATE ) then
        if ( initDone.eq.0 ) then
          p0 = StateN % p0 * ANA_RealInfo (IANA_GRAV_INC)
          q0 = StateN % q0 * ANA_RealInfo (IANA_GRAV_INC)
          s0(1:nstre) = StateN%s0 (1:nstre)*ANA_RealInfo (IANA_GRAV_INC)
        else
          Stress(1:nstre) = StateN % Stress (1:nstre) + dSig0 (1:nstre)          
          q0 = CEQ_get_qx ( Stress,nstre )
          p0 = CEQ_get_px ( Stress,nstre )
          call CEQ_get_deviator  ( Stress,s0,nstre )
        end if
      else
        q0 = StateNx1 % q0 
        p0 = StateNx1 % p0 
        s0 (1:nstre) = StateNx1 % s0(1:nstre)
      end if

      StateNx1Save  = StateN

      StateNx1 % Stress (1:nstre) = StateN % Stress (1:nstre) + 
     &                              dSig0 (1:nstre)

      StateNx1 % Strain (1:nstre) = StateN % Strain (1:nstre) +
     &                              dEpsNx1 (1:nstre)

      EpsDN = CEQ_get_EpsD  ( StateN % Strain,devStrain,nstre )      
      EpsVN = CEQ_get_I1     (StateN % Strain,nstre )      

      EpsDNx1 = CEQ_get_EpsD  ( StateNx1 % Strain,devStrain,nstre )      
      EpsVNx1 = CEQ_get_I1     (StateNx1 % Strain,nstre )      


      pN      = CEQ_get_px ( StateN % Stress,nstre )
      qN      = CEQ_get_qx ( StateN % Stress,nstre )

cdebug
c      if ( ANA_RealInfo ( IANA_TIME_ACT).gt.0.0d0) then
c        if ( IANA_IntInfo (IANA_ITER_NR).gt.0 ) then
c          pN = pN
c        end if
c      end if



      w1 = dot_product (s0(1:nstre),devStrain(1:nstre))
      call PEAB_FinfNew_pq    ( p0,q0,
     &                          pN,qN,EpsDNx1,EpsVNx1,w1,Mat,p,q,Gs,Ks,
     &                          StateNx1 % initialized,EpsDN,EpsVN,
     &                          devStrain,s0,nstre)

      do i=1,nstre
        s(i) = s0(i)+2.0d0*Gs*R_1_PEAB(i)*devStrain(i)
      end do

      call CEQ_SetStress ( s,p,StateNx1%Stress,nstre )

      call CEQ_Elastic_Matr ( Ks,Gs,CEQ_STIFFNESS,De,nstre )      
      Dep = De

      return
      end subroutine PEAB_NewStressState



      ! ======================================================================
      subroutine PEAB_NewState ( dEpsNx1,dSig0,nstre,StateN,StateNx1,
     &                           De,Dep,Mat,M)
      ! ======================================================================
      use CEQ_utility
      include 'nodecl.inc'
      include '..\src\math.inc'
      include '..\src\anal_enu.inc'
      include '..\src\vref.inc'
      
      integer*4, intent (in) :: nstre
      real*8, intent (in)    :: dEpsNx1    (nstre),
     &                          dSig0 (nstre)
      real*8, intent (inout) :: De (nstre,nstre), Dep (nstre,nstre)

      type (StateParameters_PEAB), intent (inout) :: StateN
      type (StateParameters_PEAB), intent (inout) :: StateNx1
      type (MatProperties_PEAB  ), intent (in   ) :: Mat
      type (StateParameters_PEAB)                 :: StateNx1TMP1
      type (StateParameters_PEAB)                 :: StateNx1TMP2

      real*8 :: dEpspNx1(MAX_STRESS_PEAB),S(MAX_STRESS_PEAB),
     &          Smapp(MAX_STRESS_PEAB),Strsi(MAX_STRESS_PEAB)
      real*8 :: sqrtJ2tr,xI1tr,pTr,qTr,F,Ksec,Gsec,aq,ap,bq,bp,G3,
     &          aTDb,dlambda,ro,q,p,pAppexSafety,pAppex,tmp,
     &          scaleRadial,pTrV,xKf,denom,aI1,aJ2,bI1,KsecRef,
     &          a(MAX_STRESS_PEAB),b(MAX_STRESS_PEAB),
     &          convnorm,tmpK,tmpG,
     &          dEpsNx1TMP(MAX_STRESS_PEAB),eps,
     &          DepTMP(MAX_STRESS_PEAB,MAX_STRESS_PEAB)
      real*8 :: DP_Yield
      integer*4 :: nstre2,iter,i,j
      logical*4 :: thereIsVertex,considerVertex,done
      integer*4, parameter :: MAX_ITER = 50
      integer*4 :: M(*)


cdebug
c      integer*4 :: ele,gp,ILOA_GetValueForDataSuperElement
c      real*8    :: xgp(24),value
c      include '..\src\trans.inc'       ! element geometry
c      xgp(1:3) = xgp_tra(1:3)
c      i = ILOA_GetValueForDataSuperElement (M,5,xgp,value)

cdebug


c     call PEAB_debug (Mat)

      call PEAB_NewStressState (StateN,StateNx1,nstre,Mat,
     &                          dSig0,dEpsNx1,dEpsPNx1,De,Dep,
     &                          Ksec,Gsec)  

      eps = 1.0d-8
      do i=1,nstre
        dEpsNx1TMP (1:nstre) = dEpsNx1 (1:nstre)
        dEpsNx1TMP (i) = dEpsNx1 (i) - eps

        call PEAB_NewStressState (StateN,StateNx1TMP1,nstre,Mat,
     &                            dSig0,dEpsNx1TMP,dEpsPNx1,De,Dep,
     &                            Ksec,Gsec)  

        dEpsNx1TMP (i) = dEpsNx1 (i) + eps

        call PEAB_NewStressState (StateN,StateNx1TMP2,nstre,Mat,
     &                            dSig0,dEpsNx1TMP,dEpsPNx1,De,Dep,
     &                            Ksec,Gsec)  

        do j=1,nstre
          DepTMP(j,i) = (StateNx1TMP2%Stress(j)-
     &                       StateNx1TMP1%Stress(j))/(2.0d0*eps)
        end do
      end do

      Dep(1:nstre,1:nstre) = DepTMP(1:nstre,1:nstre)


      return


      done = .false.
      pAppex = Mat % pAppex
      dEpspNx1 = 0.0d0
      nstre2   = nstre * nstre

      tmpG = 1.0d0/(2.0d0*(1.0d0+Mat%v))
      tmpK = 1.0d0/(3.0d0*(1.0d0-2.0d0*Mat%v))

      iter = 0
999   iter = iter + 1

      call PEAB_NewStressState (StateN,StateNx1,nstre,Mat,
     &                          dSig0,dEpsNx1,dEpsPNx1,De,Dep,
     &                          Ksec,Gsec)  


      if ( iter.eq.1 ) then
        KsecRef = Ksec
      else
        convnorm = abs(KsecRef-Ksec)/KsecRef
        if ( convnorm.lt.1.d-3 ) done = .true.
        KsecRef = Ksec
c       Ksec =(Ksec+KsecRef)/2.0d0
c       Gsec = tmpG/tmpK * Ksec         
      end if

      G3 = Gsec * 3.0d0

      call DP_TrialStateInv (StateNx1%Stress,nstre,
     &                       S,sqrtJ2tr,xI1tr,pTr,qTr )

      F = DP_yield ( xI1tr,sqrtJ2tr,Mat % aphi, Mat % ak )

      if ( F.le.0.0d0 ) then
        Dep = De
        if ( iter.eq.1 ) then
          call PEAB_PlasticFlag (0,StateN,StateNx1)
          return
        end if
      end if

      call DP_pqderiv ( Mat % aphi,Mat % apsi,aq,ap,bq,bp )
      aTdb = G3 * aq * bq + Ksec * ap * bp
      dlambda = F / aTdb
      p = pTr - Ksec * dlambda * bp

      thereIsVertex  = .false.
      considerVertex = .true.

      pAppexSafety = pAppex / (1.0d0+1.0d-6)
      if (qTr.ne.0.0d0.and.
     &   ((.not.considerVertex).or.(p.gt.-pAppexSafety))) then 
        ro = 0.0d0
        q = qTr - G3 * dlambda * bq
        q = dmax1 ( q,0.0d0 )
        ! compose stress vector in nstre dim. space
        tmp = q / qTr
        call MAT_axfactor     ( S,nstre,tmp,Smapp )
        call DP_composeStress ( Smapp,p,nstre,Strsi  )
        scaleRadial = tmp
        ro          = 0.0d0

      else ! vertex state

        thereIsVertex = .true.
        call UTL_clear        ( Smapp,nstre )
        call DP_composeStress ( Smapp,-pAppex,nstre,Strsi  )
        pTrV  = pTr + pAppex
        xKf   = Ksec * F
        denom = xKf - pTrV * Ksec * ap
        if ( qTr.ne.0.0d0.and.dabs(denom)/press_REF.gt.1.0d-6 ) then
          ro = (pTrV * aTDb - xKf * bp)/denom
          scaleRadial = 0.0d0 
          scaleRadial = dmin1 ( 1.0d0,scaleRadial )
          aTdb = G3 * aq * bq + Ksec * ap * (bp+ro)
          dlambda = 0.0d0
          call MAT_axfactor ( S,nstre,scaleRadial,Smapp )
        else
          ! impossible to correct plastic flow vector
          call UTL_move ( Dep,De,nstre2 )
          go to 111
        end if
      end if ! p > -pAppex


111   continue

      StateNx1 % Stress (1:nstre) = strsi(1:nstre)

      call DP_pqToI1J2deriv ( ap,aq,bp,ro,qTr,aI1,aJ2,bI1 )
      call DP_gradients     ( aI1,aJ2,bI1,S,nstre,a,b )

      dEpsPNx1 (1:nstre) = dlambda * b(1:nstre)

      if ( .not.done.and.iter.le.MAX_ITER ) go to 999
      if ( iter.gt.MAX_ITER)then
        iter = iter
      end if

      if (thereIsVertex) then
        Dep = De
      else
        call Set_DepH         ( De,Dep,a,b,0.0d0,nstre )
      end if

      call PEAB_PlasticFlag (1,StateN,StateNx1)

      end subroutine PEAB_NewState

c==========================================================================
      subroutine PEAB_PlasticFlag (plasticity,StateN,StateNx1)
c==========================================================================
      include 'nodecl.inc'
      integer*4 :: plasticity
      type (StateParameters_PEAB), intent (inout) :: StateN
      type (StateParameters_PEAB), intent (inout) :: StateNx1

      if ( StateN % plasticFlag.eq.0.0d0 ) then

        if ( plasticity.eq.0 ) then
          StateNx1%plasticFlag = 0.0d0 
        else
          StateNx1%plasticFlag = 1.0d0 
        end if

      else if ( StateN % plasticFlag.eq.1.0d0 ) then

        if ( plasticity.eq.0 ) then
          StateNx1%plasticFlag = -1.0d0
        else
          StateNx1%plasticFlag =  1.0d0
        end if

      else

        if ( plasticity.eq.0 ) then
          StateNx1%plasticFlag = -1.0d0
        else
          StateNx1%plasticFlag =  1.0d0
        end if

      end if

      return
      end subroutine PEAB_PlasticFlag

c==========================================================================
      subroutine PEAB_UpdateState ( StateN,StateNx1,nstre )
c==========================================================================

      include 'nodecl.inc'
      include '..\src\anal_enu.inc'
      integer*4, intent(in) :: nstre
      type (StateParameters_PEAB), intent (inout) :: StateN,StateNx1
      integer*4 :: IANA_IntInfo
      real*8    :: CEQ_get_qx,CEQ_get_px

      if ( IANA_IntInfo ( IANA_PROCESS_ACT ).eq.IANA_INI_STATE ) then
        StateNx1 % q0 = CEQ_get_qx ( StateNx1 % Stress,nstre )      
        StateNx1 % p0 = CEQ_get_px ( StateNx1 % Stress,nstre )      
        call CEQ_get_deviator  ( StateNx1 % Stress,StateNx1%s0,nstre )
        StateNx1 % Strain (1:nstre) = 0.0d0
      else
        continue
      end if

      StateNx1%initialized = 1.0d0
      StateN = StateNx1


      end subroutine PEAB_UpdateState


c==========================================================================
      subroutine PEAB_FinfNew_pq ( po,qo,pN,qN,epsdNx1,epsvNx1,w1,Mat,
     &                             p,q,
     &                             Gs,Ks,initialized,epsdN,epsvN,e,s0,
     &                             nstre)
c==========================================================================
      include 'nodecl.inc'
      include '..\src\anal_enu.inc'
c      include '..\src\elgeo.inc'
      
      type (MatProperties_PEAB) :: Mat
      real*8 :: w1,pN,qN,po,qo,epsdNx1,epsvNx1,A(2,2),B(2),p,q,rp,rq,
     &          epsdN,epsvN,Asave(2,2),w1x,test,
     &          drp_dp,drp_dq,drq_dp,drq_dq,e(*),s0(*),AA(2,2)
    
      integer*4 :: i,trial,max_iter,ok,ii,jj,nstre,initDone
      real*8 :: deltap,deltaq,det,detp,detq,refnorm,dp,dq,s,Gs,Ks,
     &          derivFrac,rnorm,initialized,epsv,epsd,
     &          psave,qsave,sum,inc
      integer*4 :: IANA_intinfo 
      real*8    :: ANA_realInfo

!!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
!  !MS$ ATTRIBUTES DLLIMPORT :: /ELE_common/
!!MS$ END IF

!!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
!  !MS$ ATTRIBUTES DLLIMPORT :: /ELE_current/
!!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
c  !MS$ ATTRIBUTES DLLIMPORT :: /CentralPoint_TRA/   
!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
c  !MS$ ATTRIBUTES DLLIMPORT :: /CurrentIntpoint_TRA/ 
!MS$ END IF


1231  continue

      sum = 0.0d0
      inc = 1.0d0
      ok  = 0

      initDone = initialized

      max_iter = 50
      if ( initDone.eq.0 ) then
        p = po
        q = qo
      else
        p = pN
        q = qN
      end if

      psave = pN
      qsave = qN
      psave = p
      qsave = q

777   continue

      epsd = epsdN + (sum+inc)*(epsdNx1-epsDN)
      epsv = epsVN + (sum+inc)*(epsVNx1-epsVN)
      w1x  = w1 * (sum+inc)

888   continue

      i = 0
999   i = i + 1

c      derivFrac = 1.d-5
c      deltap = dmax1 (derivFrac*Mat%pL,derivFrac*p)
c      deltaq = deltap
c      call PEAB_rprq(po,qo,p+deltap,q,w1x,Mat,epsv,epsd,B(1),B(2),Gs,Ks,
c     &               drp_dp,drp_dq,drq_dp,drq_dq,e,s0,nstre)
c      A (1,1) = B(1)
c      A (2,1) = B(2)
c      call PEAB_rprq(po,qo,p-deltap,q,w1x,Mat,epsv,epsd,B(1),B(2),Gs,Ks,
c     &               drp_dp,drp_dq,drq_dp,drq_dq,e,s0,nstre)
c      A (1,1) = (A(1,1) - B(1))/(2.0d0*deltap)
c      A (2,1) = (A(2,1) - B(2))/(2.0d0*deltap)
c      call PEAB_rprq(po,qo,p,q+deltaq,w1x,Mat,epsv,epsd,B(1),B(2),Gs,Ks,
c     &               drp_dp,drp_dq,drq_dp,drq_dq,e,s0,nstre)
c      A (1,2) = B(1)
c      A (2,2) = B(2)
c      call PEAB_rprq(po,qo,p,q-deltaq,w1x,Mat,epsv,epsd,B(1),B(2),Gs,Ks,
c     &               drp_dp,drp_dq,drq_dp,drq_dq,e,s0,nstre)
c      A (1,2) = (A(1,2) - B(1))/(2.0d0*deltaq)
c      A (2,2) = (A(2,2) - B(2))/(2.0d0*deltaq)
c      AA=A

      call PEAB_rprq(po,qo,p,q,w1x,Mat,epsv,epsd,B(1),B(2),Gs,Ks,
     &               drp_dp,drp_dq,drq_dp,drq_dq,e,s0,nstre)

      A(1,1) = drp_dp
      A(1,2) = drp_dq
      A(2,1) = drq_dp
      A(2,2) = drq_dq

      det  = A(1,1)*A(2,2)-A(1,2)*A(2,1)

      if ( det.le.0.0d0 ) then
        det = det
      call PEAB_rprq(po,qo,p,q,w1x,Mat,epsv,epsd,B(1),B(2),Gs,Ks,
     &               drp_dp,drp_dq,drq_dp,drq_dq,e,s0,nstre)
      end if

      detp = B(1)*A(2,2)-B(2)*A(1,2)
      detq = B(2)*A(1,1)-B(1)*A(2,1)

      if ( i.eq.1 )then
        refnorm = dmax1 (B(1)**2+B(2)**2,Mat%pL**2)
        rnorm = refnorm
      else
        rnorm   = B(1)**2+B(2)**2     
      end if

      if ( dabs(det).le.1.0d-38 ) then
        continue 
      end if

      dp   = -detp/det
      dq   = -detq/det

      s = 1.0d0

      if ( p+dp.le.0.0d0 ) then
        s = -0.5d0*p/dp
      end if     

      if ( q+s*dq.le.0.0d0 ) then
        if ( abs(dq).gt.1.0d-8 ) then
          s = -0.5d0*q/(dq)
        end if
      end if     

123   continue
      call PEAB_rprq(po,qo,p+s*dp,q+s*dq,w1x,Mat,epsv,epsd,B(1),B(2),
     &               Gs,Ks,drp_dp,drp_dq,drq_dp,drq_dq,e,s0,nstre)
      test = B(1)**2+B(2)**2     
      if ( test.gt.rnorm ) then
        s = s * 0.5d0
        if ( s.gt.1.0d-3 ) go to 123
      end if
 
      p = p + dp*s
      q = q + dq*s

      s = 1.0d0

      if ( rnorm/refnorm.lt.1.0d-12 ) then
        ! converged step
        if ( sum+inc.lt.1.0d0-1.0d-6 ) then
          sum = sum + inc
          inc = dmin1 ( inc,1.0d0-sum)
          psave = p
          qsave = q
          go to 777
        else
          return
        end if
      else if ( i.gt.max_iter ) then

        if ( inc.ge.0.05d0 ) then
          p = psave
          q = qsave
          inc = inc/2.0d0
          go to 777
        else

          psave = p
          qsave = q
          sum = sum + inc
          inc = dmin1 ( inc,1.0d0-sum)
          if ( sum+inc.lt.1.0d0-1.0d-6 ) then
            go to 777
          else
            return
          end if

        end if
      else
        go to 999
      end if

      end subroutine PEAB_FinfNew_pq



c==========================================================================
      real*8 function PEAB_getEs (p,q,qo,Mat,dEs_dp,dEs_dq)
c==========================================================================
      include 'nodecl.inc'
      type (MatProperties_PEAB) :: Mat
      real*8    :: p,q,qo,Eo,eta,etaMAX,Es,dEs_dp,dEs_dq,tmp


      Eo = Mat%K1*(dmax1(p,Mat%pL)/Mat%pref)**Mat%K2      
      etaMAX = (1.0d0-Mat%xsi)/Mat%K3

      if ( dabs(q-qo).le.Mat%xo ) then
        tmp = (q-qo)
        if ( tmp.ge.0.0d0 ) then
          ! right spline
          eta = (Mat%a1*tmp**3+Mat%a2*tmp**2)*
     &                            (dmax1(p,Mat%pL)/Mat%pref)**(-Mat%K2)
        else
c         eta = (Mat%b1*tmp**3+Mat%b2*tmp**2)*
c     &         (dmax1(p,Mat%pL)/Mat%pref)**(-Mat%K2)
          eta = 0.0d0
        end if
      else
        if ( q-qo.lt.0.0d0 ) then
          eta = 0.0d0
        else
          tmp = ((q-qo)/Mat%pref)**2
          eta =tmp**(Mat%K4/2.0d0)*(dmax1(p,Mat%pL)/Mat%pref)**(-Mat%K2)
        end if
      end if

      eta = dmin1 (eta,etaMAX)

      Es = Eo * (1.0d0-Mat%K3*eta)

      if ( p.le.Mat%pL) then

        if ( eta.lt.etaMAX ) then
           if ( dabs(q-qo).le.Mat%xo ) then
             tmp = (q-qo)
             if ( tmp.ge.0.0d0 ) then
               ! right spline
               dEs_dp = 0.0d0
               dEs_dq = -Mat%K1*(Mat%pL/Mat%pref)**Mat%K2*Mat%K3*
     &                  (3.0d0*Mat%a1*(q-qo)**2+2.0d0*Mat%a2*(q-qo))*
     &                  (Mat%pL/Mat%pref)**(-Mat%K2)
             else
               ! left  spline
               dEs_dp = 0.0d0
c               dEs_dq = -Mat%K1*(Mat%pL/Mat%pref)**Mat%K2*Mat%K3*
c     &                  (3.0d0*Mat%b1*(q-qo)**2+2.0d0*Mat%b2*(q-qo))*
c     &                  (Mat%pL/Mat%pref)**(-Mat%K2)
               dEs_dq = 0.0d0
             end if
           else
             ! standard formula
             if ( q-qo.lt.0.0d0 ) then
               dEs_dp = 0.0d0
               dEs_dq = 0.0d0
             else
               dEs_dp = 0.0d0
               dEs_dq = -Mat%K1*(Mat%pL/Mat%pref)**Mat%K2*Mat%K3*
     &                ((q-qo)**2/Mat%pref**2)**(1.0d0/2.0d0*Mat%K4)*
     &                 Mat%K4/(q-qo)*(Mat%pL/Mat%pref)**(-Mat%K2)
             end if
           end if
        else
          dEs_dp = 0.0d0
          dEs_dq = 0.0d0
        end if

      else


        if ( eta.lt.etaMAX ) then
           if ( dabs(q-qo).le.Mat%xo ) then
             tmp = (q-qo)
             if ( tmp.ge.0.0d0 ) then
               ! right spline
               dEs_dp = Mat%K1*Mat%K2*(p/Mat%pref)**Mat%K2/p
               dEs_dq = -Mat%K1*Mat%K3*(3.0d0*Mat%a1*q**2-
     &                   6.0d0*Mat%a1*q*qo+3.0d0*Mat%a1*qo**2+
     &                   2.0d0*Mat%a2*q-2.0d0*Mat%a2*qo)
             else
               ! left  spline
               dEs_dp = Mat%K1*Mat%K2*(p/Mat%pref)**Mat%K2/p
c               dEs_dq = -Mat%K1*Mat%K3*(3.0d0*Mat%b1*q**2-
c     &                   6.0d0*Mat%b1*q*qo+3.0d0*Mat%b1*qo**2+
c     &                   2.0d0*Mat%b2*q-2.0d0*Mat%b2*qo)
               dEs_dq = 0.0d0
             end if
           else
             if ( q-qo.lt.0.0d0 ) then
               dEs_dp = Mat%K1*Mat%K2*(p/Mat%pref)**Mat%K2/p
               dEs_dq = 0.0d0
             else
               ! standard formula
               dEs_dp = Mat%K1*Mat%K2*(p/Mat%pref)**Mat%K2/p
               dEs_dq = -Mat%K1*Mat%K3*((q-qo)**2/Mat%pref**2)**
     &                 (1.0d0/2.0d0*Mat%K4)*Mat%K4/(q-qo)
             end if
           end if
        else
          dEs_dp = Mat%K1*(p/Mat%pref)**Mat%K2*Mat%K2/p*
     &             (1.0d0-Mat%K3*etaMAX)
          dEs_dq = 0.0d0
        end if
      end if


      PEAB_getEs = Es
      return
      end function PEAB_getEs


c==========================================================================
      subroutine PEAB_rprq (po,qo,p,q,w1,Mat,epsv,epsd,rp,rq,Gs,Ks,
     &                      drp_dp,drp_dq,drq_dp,drq_dq,e,s0,nstre)
c==========================================================================
      include 'nodecl.inc'
      real*8 :: po,qo,p,q,w1,rp,rq,Eo,Es,Gs,Ks,epsv,epsd,tmpK,tmpG,
     &          eta,etaMAX,tmp,dEs_dp,dEs_dq,
     &          drp_dp,drp_dq,drq_dp,drq_dq,
     &          s0(*),e(*),s(6),qx,Es1,Es2,xp,xq
      type (MatProperties_PEAB) :: Mat
      integer*4 :: i,nstre
      real*8 :: CEQ_get_qx ! ,PEAB_getEs

      tmpG = 1.0d0/(2.0d0*(1.0d0+Mat%v))
      tmpK = 1.0d0/(3.0d0*(1.0d0-2.0d0*Mat%v))

c      xp = (PEAB_getEs (p+1.0d-6*p,q,qo,Mat,dEs_dp,dEs_dq)-
c     &      PEAB_getEs (p-1.0d-6*p,q,qo,Mat,dEs_dp,dEs_dq))/
c     &      (2.0d0*1.0d-6*p)
c      xq = (PEAB_getEs (p,q+1.0d-6*p,qo,Mat,dEs_dp,dEs_dq)-
c     &      PEAB_getEs (p,q-1.0d-6*p,qo,Mat,dEs_dp,dEs_dq))/
c     &      (2.0d0*1.0d-6*p)

      Es   = PEAB_getEs (p,q,qo,Mat,dEs_dp,dEs_dq)
      Ks = Es * tmpK
      Gs = Es * tmpG


c      qx = 0.0d0
c      do i=1,nstre
c        s (i) = s0(i)+2.0d0*Gs*R_1_PEAB(i)*e(i)
c        qx = qx + s(i)*R_PEAB(i)*s(i)
c      end do
c      qx = sqrt(1.5*qx)
c      qx = CEQ_get_qx (s0,nstre)

      rp  = p-po+Ks*epsv
      tmp = qo**2+6.0d0*Gs*w1+9.0d0*Gs**2*epsd**2
      if ( tmp.lt.0.0d0 ) then
        tmp = 0.0d0
      end if
      tmp =sqrt(tmp)
      rq  = q-tmp

      drp_dp = 1.0d0+epsv*tmpK * dEs_dp
      drp_dq =       epsv*tmpK * dEs_dq

      drq_dp = 0.0d0
      if ( dabs(tmp).gt.1.0d-8 * Mat%pL ) then
        drq_dp = -1.0d0/(2.0d0*tmp)*(6.0d0*w1*tmpG*dEs_dp+
     &                   9.0d0*epsd**2*2.0d0*Gs*tmpG*dEs_dp)
      end if

      drq_dq = 1.0d0
      if ( dabs(tmp).gt.1.0d-8 * Mat%pL ) then
        drq_dq = 1.0d0 - 1.0d0/(2.0d0*tmp)*(6.0d0*w1*tmpG*dEs_dq+
     &                   9.0d0*epsd**2*2.0d0*Gs*tmpG*dEs_dq)
      end if
  
      return
      end subroutine PEAB_rprq




c==========================================================================
c--------------------------------------------------------------------------
c==========================================================================
      end module PEAB_module
c==========================================================================
c--------------------------------------------------------------------------
c==========================================================================




c========================================================================
      subroutine PEAB_PrintProps( Props, InfoConst )
c------------------------------------------------------------------------
c calls functions to print parameters for all material data groups
c for nonactive groups use dummy PRO_DummyPrint   function

      include 'nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\propname.inc'

      real*8    :: Props     (*)
      integer*4 :: InfoConst (*)

  ! function to deal with each group of properties in this model
      external  PRO_MainPrint,
     &          PRO_DensPrint,
     &          PEAB_ElasticPrintParam,
     &          PEAB_NonlPrintParam,
     &          FLU_PrintParam,
     &          CRE_PrintParam,
     &          HEA_PrintParam,
     &          HUM_PrintParam,
     &          PRO_InisPrint,
     &          PRO_LocStabPrint,
     &          PRO_DummyPrint,
     &          PRO_DampPrint

       call PRO_PrintParam( Props, InfoConst ,
     &          'PEAB nonlinear elastic model',
     &          PRO_MainPrint,      ! function which prints parameters from group MAIN (standard)
     &          PRO_DensPrint,      ! function which prints parameters from group DENS (standard)
     &          PEAB_ElasticPrintParam,! function which prints parameters from group ELAS
     &          PRO_DummyPrint,     ! dummy function which does nothing
     &          FLU_PrintParam,     ! function which prints parameters for group FLOW
     &          CRE_PrintParam,     ! function which prints parameters for group CREEP (standard)
     &          PEAB_NonlPrintParam, ! function which prints parameters for group NONL
     &          HEA_PrintParam,     ! function which prints parameters for group HEAT
     &          HUM_PrintParam,     ! function which prints parameters for group HUMI (standard)
     &          PRO_InisPrint,      ! function which prints parameters for group INIS (standard)
     &          PRO_LocStabPrint,   ! function which prints parameters for group LSTAB(standard)
     &          PRO_DampPrint,      ! 
     &          PRO_DummyPrint)     ! 

      return
      end

c==================================================================
      subroutine  PEAB_ElasticPrintParam( ifile,props)
c------------------------------------------------------------------
c print elastic parameters
      use PEAB_module
      include 'nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\prnline.inc'

      integer*4 :: ifile
      real*8    :: props(*)
      real*8    :: tmp
      real*8    :: PRO_GetFromDAT
      integer*4 :: i
      type (print_line_struct_type) :: line

      do i=1,PEAB_ELAS_MAX
        call IO_BeginLine_ex (line)
        call IO_AddStrToLine_ex  ( line, ElasticProps_PEAB (i),8 )
        tmp = PRO_GetFromDAT  ( props,IPRO_GR_ELAS,i )
        call IO_AddR8ToLine_ex   ( line,tmp )
        call IO_EndLine_ex       ( line,ifile ) 
      end do

      return
      end

c==================================================================
      subroutine  PEAB_NonlPrintParam( ifile,props)
c------------------------------------------------------------------
c print elastic parameters
      use PEAB_module
      include 'nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\prnline.inc'

      integer*4 :: ifile
      real*8    :: props(*)
      real*8    :: tmp
      real*8    :: PRO_GetFromDAT
      integer*4 :: i
      type (print_line_struct_type) :: line

      do i=1,PEAB_NONL_MAX
        call IO_BeginLine_ex (line)
        call IO_AddStrToLine_ex  ( line,NonlProps_PEAB (i),8 )
        tmp = PRO_GetFromDAT  ( props,IPRO_GR_NONL,i )
        call IO_AddR8ToLine_ex   ( line, tmp )
        call IO_EndLine_ex       ( line, ifile ) 
      end do

      return
      end


c==========================================================================
      subroutine  PEAB_Model( order, props, model_buff, InfoIn, InfoOut,
     &                        domain)
c==========================================================================
      use PEAB_module

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /dat_common/   
!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /JOB_common/
!MS$ END IF

!!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
!  !MS$ ATTRIBUTES DLLIMPORT :: /ELE_common/
!!MS$ END IF

!!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
!  !MS$ ATTRIBUTES DLLIMPORT :: /ELE_current/
!!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /CentralPoint_TRA/   
!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /CurrentIntpoint_TRA/ 
!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /pointers_TRA/ 
!MS$ END IF

      include 'nodecl.inc'
      include '..\src\prop.inc'        ! enums for material parameters predefined in
                                       ! original system prior adding user model
                                       ! plus enums for material level actions
      include '..\src\position.inc'    ! enums for stress/strain components
      include '..\src\trans.inc'       ! transfer common block through which the communication, 
                                       ! between finite element and gauss point, is performed
      include '..\src\dat.inc'         ! structure which describes element/gauss points storage
      include '..\src\job.inc'         ! parametrization parameters like nr of stress 
                                       ! components for all job types like (3D, plane strain etc...) 
                                       ! plus job enums

      integer*4, intent (in)    :: order
      real*8,    intent (in)    :: props      (*)
      integer*4, intent (inout) :: model_buff (*)
      integer*4, intent (in)    :: infoIn     (*)
      integer*4, intent (inout) :: infoOut    (*)
      integer*4, intent (inout) :: domain     (*)
     

      type (StateParameters_PEAB) :: StateN
      type (StateParameters_PEAB) :: StateNx1
      integer*4                   :: StateOffsInStorage
      integer*4                   :: Nstre,StorageSize,j

      type (MatProperties_PEAB)   :: Mat

      real*8                      :: E
      integer*4                   :: k,orderTmp2

      real*8    :: T 
      logical*4 :: TisGiven

      Nstre   = JOB_NrOfStressComp ( Itype_JOB )
      StorageSize = PEAB_StateStorageSizeI4words (nstre)
      StateOffsInStorage = StorageSize / 2

      select case (order)

        ! --------------------
        case( L_GP_UPD_STATE )
        ! --------------------
          j = MODofs_DAT (MOD_ALL_DAT)+1

          call PEAB_repack_state (model_buff(j),0,
     &                    StateN,nstre,
     &                    PEAB_CopyRightToLeft  )
          call PEAB_repack_state (model_buff(j),StateOffsInStorage,
     &                    StateNx1,nstre,
     &                    PEAB_CopyRightToLeft)

          call PEAB_UpdateState ( StateN,StateNx1,nstre )

          call PEAB_repack_state (model_buff(j),0,
     &                    StateN,nstre,
     &                    PEAB_CopyLeftToRight)
          call PEAB_repack_state (model_buff(j),StateOffsInStorage,
     &                    StateNx1,nstre,
     &                    PEAB_CopyLeftToRight)

        ! --------------------
        case( L_GP_NEW_STATE )
        ! --------------------
          j = MODofs_DAT (MOD_ALL_DAT)+1
          call PEAB_repack_state (model_buff(j),0,
     &                    StateN,nstre,
     &                    PEAB_CopyRightToLeft  )
          call PEAB_repack_state (model_buff(j),StateOffsInStorage,
     &                    StateNx1,nstre,
     &                    PEAB_CopyRightToLeft)

          TisGiven = (T_err_TRA == 0)
          T = 0.0d0
          if ( T_err_TRA == 0 ) then
            T = T_TRA
          end if

          call PEAB_NewState (dE_TRA,dSig0_TRA,nstre,
     &                        StateN,StateNx1,Dev_TRA,Dep_TRA,Mat,
     &                        domain)
          Sact_TRA (1:nstre) = StateNx1 % Stress (1:nstre)

          call PEAB_repack_state (model_buff(j),StateOffsInStorage,
     &                    StateNx1,nstre,
     &                    PEAB_CopyLeftToRight)

        ! --------------------
        case( L_GP_INI_STATE )
        ! --------------------
          j = MODofs_DAT (MOD_ALL_DAT)+1
          call PEAB_repack_state (model_buff(j),0,
     &                    StateN,nstre,
     &                    PEAB_CopyRightToLeft  )
          call PEAB_repack_state (model_buff(j),StateOffsInStorage,
     &                    StateNx1,nstre,
     &                    PEAB_CopyRightToLeft  )

          call PEAB_unpack_props (props,Mat)         
          call PEAB_InitStateParameters (StateN,StateNx1,nstre,
     &                                   Sig0init_TRA,
     &                                   Mat)

          call PEAB_repack_state (model_buff(j),0,
     &                    StateN,nstre,
     &                    PEAB_CopyLeftToRight )
          call PEAB_repack_state (model_buff(j),StateOffsInStorage,
     &                    StateNx1,nstre,
     &                    PEAB_CopyLeftToRight )

        ! --------------------
        case( L_GP_SIZE      )
        ! --------------------
          InfoOut (MOD_ALL_DAT) = StorageSize

        ! --------------------
        case( L_GP_IFSYM     )
        ! --------------------
          InfoOut(1) = 0        ! symmetric

        ! --------------------
        case( L_GP_SETDELA   )
        ! --------------------
          j = MODofs_DAT (MOD_ALL_DAT)+1
          call PEAB_repack_state (model_buff(j),StateOffsInStorage,
     &                    StateNx1,nstre,
     &                    PEAB_CopyRightToLeft  )
          call PEAB_unpack_props (props,Mat)
          E = PEAB_getE (StateNx1 % Stress,nstre,
     &                   StateNx1%p0,StateNx1%q0,
     &                   StateNx1%initialized,Mat )
          ! compute elastic stiffness matrix based on E & v (in this case)
          ! and return in via -> InfoOut buffer
          call ELA_EvaluateDmatr ( E,Mat % v,InfoOut(1),Nstre )

        ! --------------------
        case( L_GP_SETCELA   )
        ! --------------------
          j = MODofs_DAT (MOD_ALL_DAT)+1
          call PEAB_repack_state (model_buff(j),StateOffsInStorage,
     &                    StateNx1,nstre,
     &                    PEAB_CopyRightToLeft  )
          call PEAB_unpack_props (props,Mat)
          E = PEAB_getE (StateNx1 % Stress,nstre,
     &                   StateNx1%p0,StateNx1%q0,
     &                   StateNx1%initialized,Mat )
          call ELA_EvaluateCmatr ( E,Mat % v,InfoOut(1),Nstre )

        ! --------------------
        case( L_GP_PRINTPARAM )
        ! --------------------
          call PEAB_PrintProps(Props, InfoIn)

        ! --------------------
        case (L_GP_GET_INFO)
        ! --------------------
          call PEAB_unpack_props (props,Mat)
          j = MODofs_DAT (MOD_ALL_DAT)+1
          call PEAB_repack_state (model_buff(j),StateOffsInStorage,
     &                    StateNx1,nstre,
     &                    PEAB_CopyRightToLeft  )
          k = 1
          do while (k.le.ITRA_NR_OF_ITEM)
            orderTmp2 = ishft(1,k-1)
            if( iand(InfoIn(1), orderTmp2) .ne. 0 ) then
              select case (orderTmp2)
                case ( ITRA_GP_SACT )
                  Sact_TRA (1:nstre) = StateNx1 % Stress (1:Nstre)

                case ( ITRA_GP_POISS )
                  v_TRA = Mat % v

                case ( ITRA_GP_IPLA )
                  Iplas_TRA = StateNx1%plasticFlag
                  StatusChar_TRA ='  E  '

                case ( ITRA_GP_SLEV )
                  SLev_TRA = PEAB_StrLevel (Mat,StateNx1 % Stress,nstre)

                case ( ITRA_GP_YOUNG)
                  E_TRA = PEAB_getE (StateNx1 % Stress,nstre,
     &                               StateNx1%p0,StateNx1%q0,
     &                               StateNx1%initialized,Mat )
                case ( ITRA_GP_YOUNG_ET)
                  YoungET_TRA=PEAB_getE (StateNx1 % Stress,nstre,
     &                               StateNx1%p0,StateNx1%q0,
     &                               StateNx1%initialized,Mat )
                case ( ITRA_GP_YOUNG_E0)
                  YoungE0_TRA=PEAB_getE (StateNx1 % Stress,nstre,
     &                               StateNx1%p0,StateNx1%q0,
     &                               StateNx1%initialized,Mat )
                case default
                  continue 
              end select
            end if
            k=k+1
          end do

        ! --------------------
        case ( L_GP_MODIFPARAM )
        ! --------------------
          ! do nothing for elastic model

        ! --------------------
        case ( L_GP_SET_INCOMP)
        ! --------------------
          ! do nothing for elastic model

        ! --------------------
        case ( L_GP_FORM_DESCR ) ! describe formulation type
        ! --------------------

        ! --------------------
        case default
        ! --------------------

      end select


      return
      end




      subroutine PEAB_debug (Mat)
      use PEAB_module
      include 'nodecl.inc'
      type (MatProperties_PEAB) :: Mat
      real*8 :: po,qo,p,q,Ksec,Gsec,depsv,depsd,deps1,deps3,
     &          tmpG,tmpK,Esec,pend,eps3,eps1,epsd,epsv,pl,ql,w1,
     &          Eo,Es,Gs,Ks,eta,etaMAX
      integer*4 :: N,i

      real*8    :: Hess(2,2)

      po = 100.0d0
      qo = 0.0d0
      p = po+600.0d0/3.0d0
      q = qo+600.0d0
      w1 = 0.0d0


      Es   = Mat%K1*((p/Mat%pref)**Mat%K2-
     &       Mat%K3*((q-qo)/Mat%pref)**Mat%K4)

      tmpG = 1.0d0/(2.0d0*(1.0d0+Mat%v))
      tmpK = 1.0d0/(3.0d0*(1.0d0-2.0d0*Mat%v))
      Eo = Mat%K1*(dmax1(p,Mat%pL)/Mat%pref)**Mat%K2      
      etaMAX = (1.0d0-Mat%xsi)/Mat%K3
      eta = (q-qo)/Mat%pref
      eta = (eta**2)**(Mat%K4/2.0d0)*
     &        (dmax1(p,Mat%pL)/Mat%pref)**(-Mat%K2)
      eta = dmin1 (eta,etaMAX)
      if ( dabs(eta).le.1.0d-6*Mat%pref ) then
        Es = Eo
      else
        Es = Eo * (1.0d0-Mat%K3*eta)
      end if
      Ks = Es * tmpK
      Gs = Es * tmpG
      epsd = q/(3.0d0*Gs)
      epsv = (p-po)/Ks

      eps1 = q/Es
      eps1 = -(epsd+epsv/3.0d0)
      eps3 = -(epsv-eps1)/2.0d0

c      call PEAB_FinfNew_pq ( po,qo,po,qo,epsd,epsv,w1,Mat,p,q,Gs,Ks,
c     &                       0.0d0,0.0d0)

      end subroutine PEAB_debug



