c -------------------------------------------------------------------------
c here is a constitutive module template 
c Fortran 90/77 syntax is used here 
c
c Huber-Mises model is shown here as an example
c 
c
c statements with comment DON'T EDIT cannot be removed !
c
c state parameters like stresses, plastic strains etc... are kept in a continuos memory 
c block called model_buff (*) which is an INT*4 array (*)
c 
c -------------------------------------------------------------------------



c==========================================================================
      subroutine  USR1_Model (order, props, model_buff, infoIn, infoOut,
     &                        domain)
c--------------------------------------------------------------------------

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /dat_common/   
!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /JOB_common/
!MS$ END IF

!!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
!  !MS$ ATTRIBUTES DLLIMPORT :: /ELE_common/
!!MS$ END IF

!!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
!  !MS$ ATTRIBUTES DLLIMPORT :: /ELE_current/
!!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /CentralPoint_TRA/   
!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /CurrentIntpoint_TRA/ 
!MS$ END IF

!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
  !MS$ ATTRIBUTES DLLIMPORT :: /pointers_TRA/ 
!MS$ END IF



      include '..\src\nodecl.inc'
      include 'usr1.inc'               ! your private common block

      include '..\src\prop.inc'        ! enums for material parameters predefined in
                                       ! original system prior adding user model
                                       ! plus enums for material level actions

      include '..\src\position.inc'    ! enums for stress/strain components

      include '..\src\trans.inc'       ! transfer common block through which the communication, 
                                       ! between finite element and gauss point, is performed

      include '..\src\dat.inc'         ! structure which describes element/gauss points storage

      include '..\src\job.inc'         ! parametrization parameters like nr of stress 
                                ! components for all job types like (3D, plane strain etc...) 
                                ! plus job enums

      integer*4 :: order
      real*8    :: props     (*)   ! property data
      integer*4 :: model_buff (*)   ! model storage 
      
      integer*4 :: infoIn    (*),  ! additonal input (it may change meaning for -> order)
     &             infoOut   (*)   ! additional output
      integer*4 :: domain (*)           ! whole data space

      integer*4 :: nstre, offs, iGpsize
      integer*4 :: USR1_SetGpAdr   ! function which sets up nr of parameters to be kept
                                   ! for single gauss point both for old and new 
                                   ! configuration of equilibrium

      real*8    :: PRO_GetFromDat
      real*8    :: E, v
      integer*4 :: i, k, orderTmp2
      real*8    :: T
      logical*4 :: TisGiven
      integer*4 :: p_ (max_USR1)
                           


      
      nstre = JOB_NrOfStressComp (Itype_JOB) ! sets nr of of stress components for assumed job
                                             ! DON'T EDIT
      iGpsize = USR1_SetGpAdr    ( p_, nstre   ) ! set pointers to state parameters

      select case (order)

        ! --------------------
        case( L_GP_UPD_STATE )
        ! --------------------
          ! here you have to update state parameters like stresses, 
          ! plastic strains, hardening parameters, etc.............

          offs = MODofs_DAT (MOD_ALL_DAT) ! offset in model storage buffer 
                                          ! DON'T EDIT

          ! here update stress state :  old <= new 
          call UTL_move ( model_buff ( offs + p_ (stress_n_USR1)),
     &                    model_buff ( offs + p_ (stress_nx1_USR1)),
     &                    nstre )

          ! here update plastic status parameter :  old <= new 
          call UTL_move ( model_buff ( offs + p_ (plas_code_n_USR1)),
     &                    model_buff ( offs + p_ (plas_code_nx1_USR1)),
     &                    1 )

          ! return actual plastic status (obligatory !) through transfer common block
          ! defined in trans.inc include file
          Iplas_TRA = model_buff ( offs + p_ (plas_code_nx1_USR1)) 

        ! --------------------
        case( L_GP_NEW_STATE )
        ! --------------------
           ! compute new state for given effective strain increment dE_TRA
           !         (dE_TRA = dE - dEo - dEcr)
           !         where dE   - total strain increment
           !         where dE0  - initial strain increment
           !         where dEcr - creep strain increment
           !                             initial stress increment   dSig0_TRA
           !                             initial elastic moduli     Dev_TRA
           ! note : for models with constant elastic stiffness with activated creep
           !        an elastic moduli matrix is modified through creep module
           !        and thus the one given in Dev_TRA (via transfer common block
           !        defined in trans.inc file) should be used here;
           !        however, it is obvious that for models with variable elastic stiffness
           !        the creep (in actual form!) cannot be activated and elastic moduli are not 
           !        constant anymore so this input data should be simply ignored
           !        
           offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT

           TisGiven = (T_err_TRA == 0)
           T = 0.0d0
           if ( T_err_TRA == 0 ) then
             T = T_TRA
           end if

           call USR1_NewState ( Dev_TRA,
     &             model_buff  (offs + p_ (stress_n_USR1)),
     &             model_buff  (offs + p_ (stress_nx1_USR1)),
     &             model_buff  (offs + p_ (plas_code_n_USR1)),
     &             model_buff  (offs + p_ (plas_code_nx1_USR1)),
     &             model_buff  (offs + p_ (stress_lev_USR1)),
     &             dE_TRA, dSig0_TRA, nstre, Dep_TRA, props, 
     &             T, TisGiven, domain )

           ! copy computed new stress state from internal storage to array Sact_TRA 
           ! (which is in common block defined in trans.inc file )
           
           call UTL_move ( Sact_TRA,
     &                     model_buff (offs+p_ (stress_nx1_USR1)),nstre)

        ! --------------------
        case( L_GP_INI_STATE )
        ! --------------------
          offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT

          ! initialization of state parameters
          ! nulify all your arrays

          call UTL_clear ( model_buff ( offs+p_ (stress_nx1_USR1)) ,
     &                     nstre )
          call UTL_clear ( model_buff ( offs+p_ (stress_n_USR1))   ,
     &                     nstre )
          call UTL_iclear( model_buff ( offs+p_ (plas_code_n_USR1)),1)
          call UTL_iclear( model_buff ( offs+p_ (plas_code_nx1_USR1)),1)
          call UTL_clear ( model_buff ( offs+p_ (stress_lev_USR1)),1)

        ! --------------------
        case( L_GP_SIZE      )
        ! --------------------
          
          ! return through output buffer the ammount of INT*4 words needed
          ! to save all your state parameters (the float values keep always
          ! as real*8 words which is equivalent to 2 words of INT*4 

          InfoOut (MOD_ALL_DAT) = iGPsize ! DON'T EDIT

        ! --------------------
        case( L_GP_IFSYM     )
        ! --------------------

          ! return the information whether your tangent stiffness matrix 
          ! is symmetric (if yes put 1 and if not put 0)

          InfoOut (1) = 1    

        ! --------------------
        case( L_GP_SETDELA   )
        ! --------------------
          ! return the actual elastic stiffness  constitutive matrix D
          ! through the output buffer
          ! if the elastic stiffness is a function of stress 
          ! then perform an action:
          !
          ! offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT
          ! compute stiffness matrix based on actual stress
          ! kept in ->         model_buff ( offs+p_ (stress_nx1_USR1))

          E =  PRO_GetFromDat (props,IPRO_GR_ELAS,IPRO_ELAS_DAT_YOUNG)
          v =  PRO_GetFromDat (props,IPRO_GR_ELAS,IPRO_ELAS_DAT_POISS)

          ! compute elastic stiffness matrix based on E & v (in this case)
          ! and return in via -> InfoOut buffer

          call ELA_EvaluateDmatr ( E,v,InfoOut(1),nstre )

        ! --------------------
        case( L_GP_SETCELA   )
        ! --------------------
          ! return the actual elastic compliance constitutive matrix C
          ! through the output buffer

          ! if the elastic stiffness is a function of stress 
          ! then perform an action:
          !
          ! offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT
          ! compute compliance matrix based on actual stress
          ! kept in ->         model_buff ( offs+p_ (stress_nx1_USR1))

          E =  PRO_GetFromDat (props,IPRO_GR_ELAS,IPRO_ELAS_DAT_YOUNG)
          v =  PRO_GetFromDat (props,IPRO_GR_ELAS,IPRO_ELAS_DAT_POISS)

          ! compute elastic compliance matrix based on E & v (in this case)
          ! and return in via -> InfoOut buffer

          call ELA_EvaluateCmatr( E,v,InfoOut(1),nstre )

        ! --------------------
        case( L_GP_PRINTPARAM )
        ! --------------------
          ! print out the input data
          call USR1_Printprops (props, InfoIn)

        ! --------------------
        case (L_GP_GET_INFO)
        ! --------------------
          ! return through transfer common block (see trans.inc file)
          ! all requested requested results/data
          k = 1
          do while (k.le.ITRA_NR_OF_ITEM)
            orderTmp2 = ishft(1,k-1)
            if( iand(InfoIn(1), orderTmp2) .ne. 0 ) then
              select case (orderTmp2)

                case ( ITRA_GP_SACT )
                  ! return actual stress state copying it from internal storage
                  ! to Sact_TRA array (from transfer coomon block)
                  offs  = MODofs_DAT (MOD_ALL_DAT)
                  call UTL_move ( Sact_TRA,
     &                     model_buff (offs+p_ (stress_nx1_USR1)),nstre)

                case ( ITRA_GP_POISS )
                  ! return actual value of Poisson coefficient
                  ! by copying its value to v_TRA variable
                  ! (from transfer coomon block)
                  v_TRA = PRO_GetFromDat(props,IPRO_GR_ELAS,
     &                                   IPRO_ELAS_DAT_POISS  )
                case ( ITRA_GP_IPLA )
                  ! return actual value of plastic status+
                  ! by copying its value to Iplas_TRA variable
                  ! (from transfer coomon block)
                  offs = MODofs_DAT (MOD_ALL_DAT) ! DON'T EDIT

                  Iplas_TRA = model_buff ( offs+p_ (plas_code_nx1_USR1))
                  StatusChar_TRA ='  E  '

                case ( ITRA_GP_SLEV )
                  ! return actual value of stress level
                  ! by copying its value to SLev_TRA variable
                  ! (from transfer coomon block)
                  call UTL_move ( Slev_TRA,
     &                     model_buff (offs+p_ (stress_lev_USR1)),1 )
                case ( ITRA_GP_YOUNG)
                  ! return actual value of Young modulus
                  ! by copying its value to E_TRA variable
                  ! (from transfer coomon block)
                  E_TRA = PRO_GetFromDat(props,IPRO_GR_ELAS,
     &                                   IPRO_ELAS_DAT_YOUNG  )
                case default
                  continue 
              end select
            end if
            k=k+1
          end do

        ! --------------------
        case ( L_GP_MODIFPARAM )
        ! --------------------
          ! here you can make modification of material parameters due to
          ! stability analysis
          call USR1_ModifParam ( props,InfoIn )

        ! --------------------
        case ( L_GP_SET_INCOMP)
        ! --------------------
          ! do nothing here 

        ! --------------------
        case ( L_GP_FORM_DESCR ) 
        ! --------------------
          ! do nothing here 

        ! --------------------
        case default
        ! --------------------
          ! do nothing here 

      end select

      return
      end subroutine USR1_Model


c=====================================================================
      integer*4 function USR1_SetGpAdr( p_, nstre)
c---------------------------------------------------------------------
c  returns size of single gauss point GP storage for this material model
c  sets up pointers to certain information likestress arrays etc...
c  and saves these pointers in coomon block cpecific for this material model
c  called usr1.inc
c---------------------------------------------------------------------
      use LPTR_profiler
      include '..\src\nodecl.inc'
      include 'usr1.inc'           ! your private common block

      integer*4 :: nstre           ! nr of stress components     (IN)
      integer*4 :: size            ! storage size in INT*4 words (AUX)
      integer*4 :: p_ (max_USR1)
      type (LPTR_PtrsOrganizer) :: myPtrs

      ! pointer to array of new stress state with size -> nstre of REAL*8 words 
      ! as the state parameters storage is always expressed in INT*4 words
      ! in call to function MEM_NextPos we put first parameter equal to nstre
      ! and the second equal to 2 which indicates that each value ocuppies 
      ! 2 x INT*4 words (which is equal to 1 REAL*8 word)

      call LPTR_new (myPtrs)

      p_ (stress_nx1_USR1)  = LPTR_next (myPtrs, nstre * 2)
      ! pointer to array of old stress state
      p_ (stress_n_USR1)    = LPTR_next (myPtrs, nstre * 2)

      ! pointer to "new" plastic status parameter (1 x INT*4 ) word
      p_ (plas_code_nx1_USR1) = LPTR_next (myPtrs, 1)

      ! pointer to "old" plastic status parameter (1 x INT*4 ) word
      p_ (plas_code_n_USR1)   = LPTR_next (myPtrs, 1)

      ! pointer to stress level
      p_ (stress_lev_USR1) = LPTR_next (myPtrs, 2)

      ! retrieve size of requested storage for state parameters
      size            = LPTR_size (myPtrs)  ! DON'T EDIT

      USR1_SetGpAdr   = size

      return
      end function USR1_SetGpAdr


c=================================================================
      subroutine USR1_NewState( De,Sold,Snew,iPlasOld,iPlasNew,
     &                 StressLevel,
     &                 dEps,dSig0,nstre,Dep,props,T,TisGiven,M )
c-----------------------------------------------------------------
c this routine computes new stress Snew 
c and corresponding tangent matrix Dep for simple J2 plasticity model
c of form   F = sqrt(J2) - c = 0
c with plastic potential Q = sqrt(J2)

      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include 'usr1.inc'
  
      integer*4 :: nstre

      integer*4 :: iPlasOld           ! old plastic status (IN)
      integer*4 :: iPlasNew           ! new plastic status (OUT)

      real*8    ::  De   (nstre,*),   ! elastic const. matrix (IN)
     &              Sold (nstre  ),   ! old stress state (IN)
     &              Snew (nstre  ),   ! new stress state (OUT)
     &              dEps (nstre  ),   ! strain increment (IN)
     &              dSig0(nstre  ),   ! initial stress increment (IN)
     &              Dep  (nstre,*),   ! tangent constitutive matrix (Dep) (OUT)
     &              props(*),         ! array with properties (IN)
     &              T       ,         ! actual temperature
     &              StressLevel       ! actual stress level (OUT)

      logical*4 ::  TisGiven
      integer*4 ::  M(*)

      ! work arrays and variables
      real*8    ::  sTrial (6)  ! trial stress state
      real*8    ::  S      (6)  ! stress deviator
      real*8    ::  depsp  (6)  ! plastic strain increment
      real*8    ::  fplast,fRef ! plasticity condition value
      real*8    ::  aTDb        ! auxiliary value
      real*8    ::  dlambda     ! plastic multiplier
      real*8    ::  dFdSig (6),dQdSig (6) ! F,Q gradients
      real*8    ::  tmp (6),Db (6), Da (6)  ! auxilairy arrays
      real*8    ::  sqrtJ2,cohesion

      real*8    ::  USR1_plasticity,get_j2


      ! compute trial stress increment : De * dEps
      call MAT_axb ( De,nstre,nstre,dEps,1,sTrial )

      ! compute trial stress state  SigT = De * dEps + SigOld  
      call MAT_addvec ( Sold,sTrial,sTrial,nstre  )
 
      ! add initial stress increment SigT = De * dEps + SigOld + dSig0
      call MAT_addvec ( sTrial,dSig0,sTrial,nstre )

      ! check plasticity condition
      fplast = USR1_plasticity ( sTrial,nstre,props,S,sqrtJ2,T,
     &                           TisGiven,M,cohesion )
      
      if ( fplast.le.0.0d0 ) then
        ! elastic or unloading state
        ! Dep = De
        ! new stress = sTrial
        call UTL_move ( Snew,sTrial,nstre  )
        call UTL_move ( Dep,De,nstre*nstre )
        iPlasNew = 0 ! means elastic
      else

        ! plastic state
        iPlasNew = 1 ! means plastic

        ! compute F & Q gradients over stress components
        call USR1_gradients ( S,sqrtJ2,nstre,dFdSig,dQdSig,props )

        !                 T
        ! compute (dFdSig)  De  (dQdSig)
        call MAT_aTxBxC ( dFdSig,nstre,1,De,nstre,dQdSig,1,aTDb )

        ! compute plastic multiplier value
        dlambda = fplast / aTDb

        ! compute plastic strain increment
        call MAT_axfactor ( dQdSig,nstre,dlambda,depsp )

        ! compute "plastic" stress increment
	  call MAT_axb ( De,nstre,nstre,depsp,1,tmp )

        ! compute final stress
        call MAT_subtrvec ( sTrial,tmp,Snew,nstre )

        ! for J2 plasticity in plane strain or 3D a single iteration 
        ! is enough for perfect elasto-plastic models (yields exact solution)

        ! compute elasto-plastic tangent operator  Dep

        call MAT_axb      ( De,nstre,nstre,dQdSig,1,Db )
        call MAT_axb      ( De,nstre,nstre,dFdSig,1,Da )
        call MAT_axfactor ( Da,nstre,1.0d0/aTDb    ,Da )
        call MAT_axbT     ( Db,nstre,1,Da,nstre,Dep    )
        call MAT_subtrvec ( De,Dep,Dep,nstre*nstre     )
        
      end if

      ! deduce plastic behavior type
      !  0  - elastic
      !  1  - plastic
      ! -1  - unloaded

      if ( iPlasOld.gt.0 ) then ! was plastic
        if ( iPlasNew.le.0 ) then
           iPlasNew = -iPlasOld ! ===> unloading point
        end if
      else if ( iPlasOld.lt.0 ) then ! was unloaded
        if ( iPlasNew.le.0 ) iPlasNew = iPlasOld ! ===> still unloaded
      else ! was elastic
        continue
      end if

      StressLevel = sqrt(get_j2(Snew,S,nstre))/cohesion

      end subroutine USR1_NewState


c========================================================================
      real*8 function USR1_plasticity ( stress,nstre,props,S,sqrtJ2,T,
     &                                  TisGiven,M,c )
c========================================================================
c this function computes the value of plasticity condition
c for given stress state
c     use M_module
      include '..\src\nodecl.inc'
      include 'usr1.inc'
      include '..\src\prop.inc'  
      include '..\src\anal_enu.inc'

      integer*4 :: nstre          ! (IN)
      real*8    :: stress (nstre) ! (IN)
      real*8    :: props (*)      ! (IN)
      real*8    :: S (nstre)      ! (OUT)
      real*8    :: sqrtJ2         ! (OUT)
      real*8    :: T              ! (IN)
      logical*4 :: TisGiven       ! (IN)  ! flag wheter temeparture is given
      integer*4 :: M(*)           ! (IN)
      real*8    :: c              ! (OUT) ! cohesion
      ! work arrays
      real*8    :: j2,TemperatureMultiplier,Time,SL
      ! functions definitions
      real*8    :: PRO_GetFromDat,get_J2,RLTF_Value,ANA_RealInfo
      integer*4 :: ltf
      
      ! get cohesion from NONL group of parameters on position USR1_NONL_C (=1 here)
      c = PRO_GetFromDat (props,IPRO_GR_NONL,USR1_NONL_C)

      if ( TisGiven ) then
        ! here make cohesion temperature dependent
        ltf  = PRO_GetFromDat (props,IPRO_GR_NONL,USR1_NONL_LTF_C)
        if ( ltf.le.0 ) then 
          TemperatureMultiplier = 1.0d0
        else
          TemperatureMultiplier = RLTF_Value( T,ltf,M )
        end if
        c = c * TemperatureMultiplier
      end if

      j2 = get_J2 ( stress,S,nstre )
      sqrtJ2 = sqrt(j2)
      USR1_plasticity = sqrtj2 - c


      return
      end


c========================================================================
      subroutine USR1_gradients ( S,sqrtJ2,nstre,dFdSig,dQdSig,props )
c========================================================================
c compute dF/dSig     dQ/dSig   gradients
      include '..\src\nodecl.inc'
      include 'usr1.inc'
      include '..\src\prop.inc'  

      integer*4 :: nstre       ! (IN) - stress space size  (4/6)
      real*8    :: props (*)   ! (IN) - array with properties
      real*8    :: S(nstre)    ! (IN) -  deviatoric stress
      real*8    :: dFdSig (nstre) ! (OUT)
      real*8    :: dQdSig (nstre) ! (OUT) 
      real*8    :: sqrtJ2         ! (IN)
      ! work arrays and variables
      real*8    :: dJ2dSig(6)    
      real*8    :: tmp

      
      call get_dJ2dSig ( dJ2dSig,S,nstre )      
      tmp = 0.5d0 / sqrtJ2
      call MAT_axfactor ( dJ2dSig,nstre,tmp,dFdSig )
      ! associated flow 
      call UTL_move     ( dQdSig,dFdSig,nstre )

      return
      end



c========================================================================
      subroutine USR1_Printprops( props, InfoConst )
c------------------------------------------------------------------------
c calls functions to print parameters for all material data groups
c for nonactive groups use dummy PRO_DummyPrint   function

      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\propname.inc'

      real*8    :: props     (*)
      integer*4 :: InfoConst (*)

  ! function to deal with each group of properties in this model
      external  PRO_MainPrint,
     &          PRO_DensPrint,
     &          USR1_ElasticPrintParam,
     &          PRO_DummyPrint,
     &          USR1_FlowPrintParam,
     &          CRE_PrintParam,
     &          USR1_NonlPrintParam,
     &          USR1_HeatPrintParam,
     &          HUM_PrintParam,
     &          PRO_InisPrint,
     &          PRO_LocStabPrint,
     &          PRO_DampPrint

       call PRO_PrintParam( props, InfoConst ,
     &          'USER MODEL Nr 1 - J2 PLASTICITY',
     &          PRO_MainPrint,      ! function which prints parameters from group MAIN (standard)
     &          PRO_DensPrint,      ! function which prints parameters from group DENS (standard)
     &          USR1_ElasticPrintParam,! function which prints parameters from group ELAS
     &          PRO_DummyPrint,     ! dummy function which does nothing
     &          USR1_FlowPrintParam,! function which prints parameters for group FLOW
     &          CRE_PrintParam,     ! function which prints parameters for group CREEP (standard)
     &          USR1_NonlPrintParam,! function which prints parameters for group NONL
     &          USR1_HeatPrintParam,! function which prints parameters for group HEAT
     &          HUM_PrintParam,     ! function which prints parameters for group HUMI (standard)
     &          PRO_InisPrint,      ! function which prints parameters for group INIS (standard)
     &          PRO_LocStabPrint,   ! function which prints parameters for group LSTAB(standard)
     &          PRO_DampPrint,      ! 
     &          PRO_DummyPrint)     ! 

      return
      end

c==================================================================
      subroutine  USR1_ElasticPrintParam( ifile,props)
c------------------------------------------------------------------
c print elastic parameters
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'

      integer*4 :: ifile
      real*8    :: props(*)

      ! here we use standard elastic parameters so we can call standard method
      call ELA_PrintParam (ifile,props )      

      return
      end

c==================================================================
      subroutine  USR1_FlowPrintParam( ifile,props)
c------------------------------------------------------------------
c print flow parameters
c------------------------------------------------------------------
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'

      integer*4 :: ifile
      real*8    :: props(*),tmp
      real*8    :: PRO_GetFromDAT 

      ! here we add some parameters to FLOW data so first we print standard 
      ! parameters and then ours
      call FLU_PrintParam (ifile,props )      

      return
      end

c==================================================================
      subroutine  USR1_HeatPrintParam( ifile,props)
c------------------------------------------------------------------
c print heat parameters
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\heat.inc'

      integer*4 :: ifile
      real*8    :: props(*),tmp
      real*8    :: PRO_GetFromDAT 

      ! here we add some parameters to HEAT data so first we print standard 
      ! parameters and then ours
      call HEA_PrintParam (ifile,props )      

      ! here we put our extra parameters

      return
      end


c==================================================================
      subroutine  USR1_NonlPrintParam( ifile,props)
c------------------------------------------------------------------
c print nonlinear parameters
      include '..\src\nodecl.inc'
      include '..\src\prop.inc'
      include '..\src\prnline.inc'
      include 'usr1.inc'

      integer*4 :: ifile
      real*8    :: props(*),tmp
      real*8    :: PRO_GetFromDAT 
      type (print_line_struct_type) :: line

      ! nonlinear parameters

      ! here we put our parameters
      call IO_BeginLine_ex (line)
      call IO_AddStrToLine_ex  (line, 'Cohesion = ',11 ) ! add string of length 11 chars
      tmp = PRO_GetFromDAT  ( props,IPRO_GR_NONL,USR1_NONL_C)
      call IO_AddR8ToLine_ex   (line, tmp )
      call IO_EndLine_ex       (line, ifile ) ! flush the line

      ! ..... and so on

      return
      end


c ===================================================================
      subroutine USR1_ModifParam ( props,Coeff  )
c ===================================================================
c this routine makes modification of plastic parameters like c,phi,psi
c in case of stability analysis
c please make modifications only after ! HERE MAKE AN ACTION comments

      use LocalStabilityStorage

c!MS$ IF DEFINED (__BUILD_DLL_ZCALC)
c  !MS$ ATTRIBUTES DLLIMPORT :: IPRO_GetStabilityTypeForMaterial,DATA  
c!MS$ END IF

      include '..\src\nodecl.inc'
      include 'usr1.inc'

      include '..\src\prop.inc'
      include '..\src\math.inc'
      include '..\src\anal_enu.inc'

      real*8    :: props(*)
      real*8    :: Coeff         ! global SF factor
      integer*4 :: IANA_IntInfo
      real*8    :: PRO_GetFromDat,PRO_GetParamNonl
      integer*4 :: iSFtype
c     integer*4 :: IPRO_GetStabilityTypeForMaterial
      real*8    :: MultForCandSL,MultForTgPHI
      real*8    :: cohes

      if ( IANA_IntInfo ( IANA_PROCESS_ACT ).eq.IANA_STABILITY ) then
        iSFtype = IPRO_GetStabilityTypeForMaterial ( props,Coeff,
     &                                      MultForCandSL,MultForTgPHI)
        select case ( iSFtype)
          case (IANA_SF_STRLEV)    ! stress-level based
            ! HERE MAKE AN ACTION

            ! get cohesion from nonlinear group multiply by SF or 1/SF
            ! coefficient and save in data again

            cohes = PRO_GetParamNonl( props,USR1_NONL_C )
            call PRO_PutParamNonl(props,USR1_NONL_C,MultForCandSL*cohes)

          case (IANA_SF_TGPHIC)    ! tan(phi)-c based
            ! HERE MAKE AN ACTION

            ! get cohesion from nonlinear group multiply by SF or 1/SF
            ! coefficient and save in data again

            cohes = PRO_GetParamNonl( props,USR1_NONL_C )
            call PRO_PutParamNonl(props,USR1_NONL_C,MultForCandSL*cohes)

          case (IANA_SF_COHES)     ! c-only based
            ! HERE MAKE AN ACTION

            ! get cohesion from nonlinear group multiply by factor
            ! coefficient and save in data again
            cohes = PRO_GetParamNonl( props,USR1_NONL_C )
            call PRO_PutParamNonl(props,USR1_NONL_C,MultForCandSL*cohes)

        end select
      end if

      return
      end


