#include "stdafx.h"

#include "../UserExtraData.h"
#include "../../zutl/zunits.h"

// Unit labels
// force:
//"kN" "g"  "N"  "lbf" "kp" "daN" "t" "MN" "GN" 

// length:
// "m"  "mm" "cm" "in" "ft" "yd"

//angle:
//"deg" "gr" "rad"  

//time: 
//"s"  "ms"  "min" "h"  "day" "week"  "month" "year" 

//temperature 
//"C" "K"  "F" 

// =======================================================================================
static int get_pos (std::vector <CString> & csv_strings, CString & str)
// =======================================================================================
{
for (int i=0;i<csv_strings.size();i++)
  {
  CString tmp = csv_strings [i];
  tmp = tmp.TrimLeft();
  tmp = tmp.TrimRight();
  if ( tmp == str )
    return i;
  }
return -1;
}


// =======================================================================================
void ExtraData_MakeUserAction ( UserExtraData* usr_data,BOOL replace_in_csv_doubles,UNIT_manager* umngr) 
// =======================================================================================
{
   // here csv file is given as table of strings in csv_strings
   // user may convert strings to double data and put it to csv_double
   // both vectors will be transferred to user functions in which extra output is produced

    if (usr_data==NULL)
       return;

    if (!replace_in_csv_doubles)
      {
      std::vector<CString> tmp;
      for (int i=0;i<(usr_data->csv).size();i++)
        {
        if ( (usr_data->csv)[i].size () > 0 )
          tmp.push_back ((usr_data->csv)[i][0]);
        }

      int row_fck     = get_pos (tmp,CString("fck"));
      int row_fctm    = get_pos (tmp,CString("fctm"));
      int row_fctk    = get_pos (tmp,CString("fctk"));
      int row_gamma_c = get_pos (tmp,CString("gamma_c"));
      int row_gamma_s = get_pos (tmp,CString("gamma_s"));
      int row_fyk     = get_pos (tmp,CString("fyk"));
      int row_eps_cu3 = get_pos (tmp,CString("epsilon_cu3"));
      int row_eps_c3  = get_pos (tmp,CString("epsilon_c3"));
      int row_a1      = get_pos (tmp,CString("a1"));
      int row_a2      = get_pos (tmp,CString("a2"));
      int row_lambda  = get_pos (tmp,CString("lambda"));
      int row_eta     = get_pos (tmp,CString("eta"));
      int row_rho_min = get_pos (tmp,CString("rho_min"));

      // keep it in vector to avoid time consuming searches
      usr_data->my_aux_data.push_back (row_eta);    
      usr_data->my_aux_data.push_back (row_lambda);
      usr_data->my_aux_data.push_back (row_rho_min);
      usr_data->my_aux_data.push_back (row_fck);
      usr_data->my_aux_data.push_back (row_fyk);
      usr_data->my_aux_data.push_back (row_a1);
      usr_data->my_aux_data.push_back (row_a2);
      usr_data->my_aux_data.push_back (row_gamma_c);
      usr_data->my_aux_data.push_back (row_fctk);
      usr_data->my_aux_data.push_back (row_gamma_s);
   
     // here I will convert data in second column of the csv file to double precision floats
      for (int i=0;i<(usr_data->csv).size();i++)
        {
        std::vector <double> aux;
        double value = 0.0;
        if ( usr_data->csv [i].size() > 1 )
          {
          try
            {
            value = atof (usr_data->csv [i][1]);
            }
          catch(CString tmp_string)
            {
            AfxMessageBox (CString("Exception during user data conversion:")+tmp_string);
            }
          }
        aux.push_back (value);
        (usr_data->csv_double).push_back (aux);
        }
     }

   int row_eta    = usr_data->my_aux_data [0];
   int row_lambda = usr_data->my_aux_data [1];
   int row_rho_min= usr_data->my_aux_data [2];
   int row_fck    = usr_data->my_aux_data [3];
   int row_fyk    = usr_data->my_aux_data [4];
   int row_a1     = usr_data->my_aux_data [5];
   int row_a2     = usr_data->my_aux_data [6];
   int row_gamma_c= usr_data->my_aux_data [7];
   int row_fctk   = usr_data->my_aux_data [8];
   int row_gamma_s= usr_data->my_aux_data [9];


   //get temporary units. DO NOT CHANGE 2 LINES BELOW
   CString tempUnits;
   umngr->GetLabelForTemporaryUnits (tempUnits);
 
   CString u_m ("m");
   CString u_MN ("MN");

   //here we do create temporary units changing basic unit for force (MN) and length (m)
   UNIT_Set unitTMP (UNIT_Simple(u_MN),
                     UNIT_Simple(u_m),
                     umngr->Glo.Base[UNIT_BASE_ANGLE],
                     umngr->Glo.Base[UNIT_BASE_TIME],
                     umngr->Glo.Base[UNIT_BASE_TEMP]);


   //now we do set our internal units system as temporary 
   umngr->SetTemporary (unitTMP);

   //here we get multipliers to convert our data to the postprocessing system
   double uForceMult       = umngr->MultFromTempToGlob (UNIT_FORCE); 
   double uLengthMult      = umngr->MultFromTempToGlob (UNIT_LENGTH); 
   double uAngleMult       = umngr->MultFromTempToGlob (UNIT_ANGLE); 
   double uTimeMult        = umngr->MultFromTempToGlob (UNIT_TIME); 
   double uTemperatureMult = umngr->MultFromTempToGlob (UNIT_TEMP); 

   double uStressMult = uForceMult/uLengthMult/uLengthMult; 

   //compute fcd
   double fcd = usr_data->csv_double [row_fck][0] / usr_data->csv_double [row_gamma_c][0];
   //fcd is in MPa and now we want to recalculate it to the postprocesing units
   fcd = fcd * uStressMult;
   //we add this value to the vector to memorize it
   if ( replace_in_csv_doubles )
     (usr_data->csv_double [row_fck])[1] = fcd;
   else
     (usr_data->csv_double [row_fck]).push_back (fcd);

   //compute fctd
   double fctd = usr_data->csv_double [row_fctk][0] / usr_data->csv_double [row_gamma_c][0];
   //fctd is in MPa and now we want to recalculate it to the user units
   fctd = fctd * uStressMult;
   //we add this value to the vector to memorize it
   if ( replace_in_csv_doubles )
     (usr_data->csv_double [row_fctk])[1] = fctd;
   else
     (usr_data->csv_double [row_fctk]).push_back (fctd);

   //compute fyd
   double fyd = usr_data->csv_double [row_fyk][0] / usr_data->csv_double [row_gamma_s][0];
   //fyd is in MPa and now we want to recalculate it to the postprocessing units
   fyd = fyd * uStressMult;
   //we add this value to the vector to memorize it
   if ( replace_in_csv_doubles )
     (usr_data->csv_double [row_fyk])[1] = fyd;
   else  
     (usr_data->csv_double [row_fyk]).push_back (fyd);


   //restore temporary units DO NOT CHANGE LINE BELOW
   umngr->SetTemporary(tempUnits);
}



