#include "stdafx.h"
#include "QuadReinforcement.h"
#include "../GPRslBeamUser.h"
#include "../UserExtraData.h"
#include "../../zmate\CrossSection.h"
#include "../../zutl/zunits.h"



// ===============================================================================
   double GPRslBeamUser_give (int      user_item,//USER_1=0,USER_2.....
                                       CString & item_string,
                                       int       user_material_number,
                                       UserExtraData* usr_data,
                                       double    *F, //NX,QY,QZ --> note that it can be NULL !
                                       double    *M, //MX,MY,MZ --> note that it can be NULL !
                                       std::vector <GPRslBeamLayersUser>  & layers_core_info ,
                                       std::vector <GPRslBeamLayersUser>  & layers_reinf_info,
                                       int       *ret,
                                       CrossSection *sect)   //return 1 if ok 
// ===============================================================================
{
   double h = 0.0;
   double b = 0.0;

   switch (sect->type())
     {
     case CrossSection::CROSS_SECTION_RECT :
       {
       CrossSection_RECT *sectRect = (CrossSection_RECT*)sect;
       b = sectRect->b;
       h = sectRect->h;

       switch(user_item)
         {
         case 0://reinforcement XX-bottom 
           {
           double MEd = M [2];
           *ret = 1;
           if ( MEd < 0.0 )
             return 0.0;
           else
             return QuadReinforcement::Quad1 (usr_data,b,h,MEd,QuadReinforcement::BOTTOM);
           }
           break;
         case 1://
           *ret = 1;
           return 0.0;       
         case 2://
           *ret = 1;
           return 0.0;       
         default:
           *ret = 0;
           return 0.0;
           break;
         }
       }
     break;

     case CrossSection::CROSS_SECTION_UNDEFINED :
     case CrossSection::CROSS_SECTION_RECT_TUBE :
     case CrossSection::CROSS_SECTION_CIRCLE :
     case CrossSection::CROSS_SECTION_CIRC_TUBE :
     case CrossSection::CROSS_SECTION_RECT_BOX :
     case CrossSection::CROSS_SECTION_I_SHAPE_S :
     case CrossSection::CROSS_SECTION_I_SHAPE_NS :
     case CrossSection::CROSS_SECTION_T_SHAPE :
     case CrossSection::CROSS_SECTION_RECT_AXI :
     default :
      *ret = 0;
       return 0.0;
     break;
     } 

}


// ===============================================================================
   double GPRslBeamUser_filter (int        user_item,//USER_1=0,USER_2.....
                                   CString &  item_string,
                                   double     rsl)
// ===============================================================================
// this function filters user result after extrapolating it to the nodes (via superconvergent patch recovery)
   {
   switch (user_item)
     {
     case 0:
     case 1:
     case 2:
     case 3:
       return max(rsl,0.0); //reinforcement must be positive
     default:
       return rsl;
     }
   }

// ===============================================================================
   int GPRslBeamUser_get_unit (int user_item,CString &  item_string,UNIT_manager* umngr)
// ===============================================================================
   {
   switch(user_item)
     {
     case 0://reinforcement XX-bottom 
       {
       return UNIT_AREA;
       }
       break;
     case 1://reinforcement YY-bottom
       {
       return UNIT_AREA;
       }
       break;
     case 2://reinforcement XX-top
       {
       return UNIT_AREA;
       }
       break;
     case 3://reinforcement YY-top
       {
       return UNIT_AREA;
       }
       break;
     default:
       return UNIT_DIMLESS;
       break;
     }
   }
