#include "stdafx.h"
#include "../UserExtraData.h"
#include "../../zutl/zunits.h"


// ===============================================================================
 double GPRslContinuumUser_give (int        user_item,//USER_1=0,SER_2.....
                                     CString &  item_string,
                                     int        user_material_number,
                                     UserExtraData* usr_data,
                                     double*    stress,// sig-xx,sig-yy,tau-xy  ,sig-zz + < tau-xz  , tau-yz   >
                                     double*    strain,// eps-xx,eps-yy,gamma-xy,eps-zz + < gamma-xz, gamma-yz >
                                     int        nstre, //size of stress/strain array
                                     double*    SL,    //stress level
                                     double*    p,     //pore pressure from consolidation or seepage analysis
                                     double*    S,     //saturation ratio
                                     double*    du,    //excess pore water pressure from undrained driver
                                     double*    pc,    //preconsolidation stress
                                     int       *ret)   //return 1 if ok 
// ===============================================================================
   {
   switch(user_item)
     {
     case 0://as an example we will compute here   saturation * pore pressure (from seepage or consolidation driver) (S*p)
       if ( S && p )
         {
         *ret = 1;
         return (*S) * (*p);
         }
       *ret = 0;
       return 0.0;
       break;
     default:
       *ret = 0;
       return 0.0;
       break;
     }
   }


// ===============================================================================
   double GPRslContinuumUser_filter (int user_item,//USER_1=0,USER_2.....
                                        CString &  item_string,
                                        double     rsl)
// ===============================================================================
// this function filters user result after extrapolating it to the nodes (via superconvergent patch recovery)
   {
   switch (user_item)
     {
     case 0:
       return rsl; // to filter the result one may use for instance max(rsl,0.0) or min(rsl,0.0)
     default:
       return rsl;
     }
   }

// ===============================================================================
int GPRslContinuumUser_get_unit (int user_item,CString &  item_string,UNIT_manager* umngr)
// ===============================================================================
   {
   switch(user_item)
     {
     case 0:
       {
       return UNIT_STRESS;//see zunits.h" for unit menmonics
       }
       break;
     default:
       return UNIT_DIMLESS;
       break;
     }
   }
