#include "stdafx.h"
#include "../GPRslShellUser.h"
#include "QuadReinforcement.h"
#include "../UserExtraData.h"
#include "../../zutl/zunits.h"




// ===============================================================================
double Wood_Armer_XXT (double* M,int* ret)
// ===============================================================================
   {
   if ( !M)
     {
     *ret = 0;   // error
     return 0.0;
     }
   double Mxx = M [0];
   double Myy = M [1];
   double Mxy = M [2];
   double EPS = 1.0e-10;

    //let us compute Wood-Armer moment for top layer on XX direction

   double M_red_xxT = Mxx+fabs(Mxy);
   if ( Myy+fabs(Mxy) < -EPS )
     M_red_xxT = Mxx+Mxy*Mxy/fabs(Myy);
   if ( M_red_xxT < 0.0 )
     M_red_xxT = 0.0; 

   *ret = 1;
   return M_red_xxT;
   }


// ===============================================================================
double Wood_Armer_YYT (double* M,int* ret)
// ===============================================================================
   {
   if ( !M)
     {
     *ret = 0;   // error
     return 0.0;
     }
   double Mxx = M [0];
   double Myy = M [1];
   double Mxy = M [2];
   double EPS = 1.0e-10;

    //let us compute Wood-Armer moment for top layer on XX direction

   double M_red_yyT = Myy+fabs(Mxy);
   if ( Mxx+fabs(Mxy) < -EPS )
     M_red_yyT = Myy+Mxy*Mxy/fabs(Mxx);
   if ( M_red_yyT < 0.0 )
     M_red_yyT = 0.0; 

   *ret = 1;
   return M_red_yyT;
   }



// ===============================================================================
double Wood_Armer_XXB (double* M,int* ret)
// ===============================================================================
   {
   if ( !M)
     {
     *ret = 0;   // error
     return 0.0;
     }
   double Mxx = M [0];
   double Myy = M [1];
   double Mxy = M [2];
   double EPS = 1.0e-10;

    //let us compute Wood-Armer moment for top layer on XX direction
   double M_red_XXB = Mxx-fabs(Mxy);
   if ( Myy-fabs(Mxy) > EPS )
     M_red_XXB = Mxx-Mxy*Mxy/fabs(Myy);
   if ( M_red_XXB > 0.0 )
     M_red_XXB = 0.0; 

   *ret = 1;
   return M_red_XXB;
   }


// ===============================================================================
   double Wood_Armer_YYB (double* M,int* ret)
// ===============================================================================
   {
   if ( !M)
     {
     *ret = 0;   // error
     return 0.0;
     }
   double Mxx = M [0];
   double Myy = M [1];
   double Mxy = M [2];
   double EPS = 1.0e-10;

    //let us compute Wood-Armer moment for top layer on XX direction

   double M_red_YYB = Myy-fabs(Mxy);
   if ( Mxx-fabs(Mxy) > EPS )
     M_red_YYB = Myy-Mxy*Mxy/fabs(Mxx);
   if ( M_red_YYB > 0.0 )
     M_red_YYB = 0.0; 

   *ret = 1;
   return M_red_YYB;
   }



// ===============================================================================
double GPRslShellUser_give (int user_item,//USER_1=0,USER_2.....
                                       CString &  item_string,
                                       int        user_material_number,
                                       UserExtraData* usr_data,
                                       double     thick, //shell thickness
                                       double    *N, //NXX,NYY,NXY --> note that it can be NULL !
                                       double    *M, //MXX,MYY,MXY --> note that it can be NULL !
                                       double    *Q, //QX,QY       --> note that it can be NULL !
                                       std::vector <GPRslShellLayersUser>  & layers_core_info ,
                                       std::vector <GPRslShellLayersUser>  & layers_reinf_info,
                                       double     xsi,
                                       int       *ret)   //return 1 if ok 
// ===============================================================================
   {
   switch(user_item)
     {
     case 0://reinforcement XX-bottom 
       {
       double MEd = fabs(Wood_Armer_XXB (M,ret));
       if (*ret ==0)
         return 0.0;
       return QuadReinforcement::Quad1 (usr_data,1.0,thick,MEd,QuadReinforcement::BOTTOM);
       }
       break;
     case 1://reinforcement YY-bottom
       {
       double MEd = fabs(Wood_Armer_YYB (M,ret));
       if (*ret ==0)
         return 0.0;
       return QuadReinforcement::Quad1 (usr_data,1.0,thick,MEd,QuadReinforcement::BOTTOM);
       }
       break;
     case 2://reinforcement XX-top
       {
       double MEd = fabs(Wood_Armer_XXT (M,ret));
       if (*ret ==0)
         return 0.0;
       return QuadReinforcement::Quad1 (usr_data,1.0,thick,MEd,QuadReinforcement::TOP);
       }
       break;
     case 3://reinforcement YY-top
       {
       double MEd = fabs(Wood_Armer_YYT (M,ret));
       if (*ret ==0)
         return 0.0;
       return QuadReinforcement::Quad1 (usr_data,1.0,thick,MEd,QuadReinforcement::TOP);
       }
       break;
     default:
       *ret = 0;
       return 0.0;
       break;
     }
   }


// ===============================================================================
double GPRslShellUser_filter (int user_item,//USER_1=0,USER_2.....
                                    CString &  item_string,
                                    double     rsl)
// ===============================================================================
// this function filters user result after extrapolating it to the nodes (via superconvergent patch recovery)
   {
   switch (user_item)
     {
     case 0:
     case 1:
     case 2:
     case 3:
       return max(rsl,0.0); //reinforcement must be positive
     default:
       return rsl;
     }
   }



// ===============================================================================
int GPRslShellUser_get_unit (int user_item,CString &  item_string,UNIT_manager* umngr)
// ===============================================================================
   {
   switch(user_item)
     {
     case 0://reinforcement XX-bottom 
       {
       return UNIT_AREA;
       }
       break;
     case 1://reinforcement YY-bottom
       {
       return UNIT_AREA;
       }
       break;
     case 2://reinforcement XX-top
       {
       return UNIT_AREA;
       }
       break;
     case 3://reinforcement YY-top
       {
       return UNIT_AREA;
       }
       break;
     default:
       return UNIT_DIMLESS;
       break;
     }
   }





