#include "stdafx.h"
#include "QuadReinforcement.h"
#include "../UserExtraData.h"


double QuadReinforcement::Quad1 (UserExtraData* usr_data,double b,double h,double MEd,int position)
{
//this function computes reinforcemenet needed for a quadrilateral cross section  b x h
//concrete and steel data is given in usr_data
//dimensioning moment is MEd

double a = 0.0;
if ( position == TOP )
  a = usr_data->csv_double [usr_data->my_aux_data [6]][0];
else
  a = usr_data->csv_double [usr_data->my_aux_data [5]][0];

double eta = usr_data->csv_double [usr_data->my_aux_data [0]][0];
double fcd = usr_data->csv_double [usr_data->my_aux_data [3]][1];
double fyd = usr_data->csv_double [usr_data->my_aux_data [4]][1];
double rho_min = usr_data->csv_double [usr_data->my_aux_data [2]][0];

double d = h - a;

double mi_eff  = MEd/(eta*fcd*b*d*d);
double aux     = 1.0-2.0*mi_eff;
if ( aux < 0.0 )
  {  
  return rho_min * b * d;
  }
double xsi_eff = 1.0-sqrt(aux);
double x_eff = d*xsi_eff;
double As1 = eta*fcd*b*x_eff/fyd;

return As1; 
}