#pragma once

#include <vector>
#include "t3dpoint.h"
#include "t3dvector.h"
#include "T3DPLAN.H"


class MeshGeom
{
public:
 std::vector<T3DPoint> pts;
 std::vector<std::vector<int>> elems;

public:
 void Extrude(T3DVector& v, T3DVector& normalAtEnd)
 {
  int offset = (int)pts.size();
  if (v == normalAtEnd)
  {
   for (int i = 0; i < offset; i++)
    pts.push_back(pts[i] + v);
  }
  else
  {
   T3DPoint pt = v; // 0,0,0 + v
   T3DPlan pl(pt, normalAtEnd);
   for (int i = 0; i < offset; i++)
   {
    T3DPoint ret;
    if (pl.ProjectPointInDir(pts[i],v,ret))
      pts.push_back(ret);
   }

   for (auto &e : elems)
   {
    int siz = (int)e.size();
    for (int inode = 0; inode < siz; inode++)
     e.push_back(e[inode] + offset);
   }
  }
 }

 int GetMaxNen()
 {
  int maxN = 0;
  for (auto &e : elems)
  {
   int siz = (int)e.size();
   if (siz > maxN)
    maxN = siz;
  }

  return maxN;
 }

 void move(T3DVector& v)
 {
   for (auto &pt : pts)
    pt += v;
 }

};