#ifndef INCLUDE_T3DPLAN
#define INCLUDE_T3DPLAN

#include "..\zutl\zutl_hdr.h"

#include "t3dsurface.h"
#include "t3dpoint.h"
#include "t3dvector.h"

#include "..\H\constant.h"

class T3DPoint;
class T3DVector ;
class T3DSegmentLine;
class Hexaedron8 ;
class T3DLine ;

//////////////////////////////////////////////////////////////////////////
class _ZUTL_CLASS T3DPlan : public T3DSurface
//////////////////////////////////////////////////////////////////////////
{
public:
 enum ePlanDefWay
 {
 P_NOT_DEF,
 P_COEFF,
 P_POINTS,
 P_P_VECT,
 };
 
 enum ePlanDefWay defWay;
 T3DPoint p[3];

protected :
	double A,B,C,D;

public :
	T3DPlan(void);
	T3DPlan(const T3DPoint&,const T3DVector&);
	T3DPlan(const T3DPlan& plan);
	T3DPlan(double a, double b, double c, double d);
	T3DPlan(const T3DPoint&,const T3DPoint&,const T3DPoint&);
	~T3DPlan() { ; } ;
	T3DVector GiveNormal() const;
	T3DPoint GiveT3DPoint() const;
	
	T3DSurface & getCopy() const;

	T3DPoint ProjectInT3DPlan(const T3DPoint&) const;
	double DistanceToT3DPoint(const T3DPoint&) const;
	T3DPoint ComputeSymetricToPoint(const T3DPoint &) const ;
	T3DPlan * Rotate(const T3DLine &, double) ;
	
	T3DPoint * Intersect(const T3DPlan & , const T3DPlan &, const T3DPlan &) const;
	T3DPoint * Intersect(const T3DPlan & , const T3DPlan &) const ;

	int IntersectWithInfiniteLine(const T3DSegmentLine& ,T3DPoint&)	const ;
	int IntersectWithLine(const T3DLine &, T3DPoint &) const ;
	int IntersectWithPoint(const T3DPoint&) const ;
 double AxByCzD ( T3DPoint & X ){return A * X[0] + B * X [1] + C * X [2] + D;}
 double AxByCzD ( double X [3] ){return A * X[0] + B * X [1] + C * X [2] + D;}
 double giveCoeff (int i);
 void   giveCoeff (double &a,double &b,double &c,double &d);

 int ProjectPointInDir  (T3DPoint &p,T3DVector & v,T3DPoint &ret);
 int IntersectWithPlane (T3DPlan & Pi2,T3DPoint & Px,T3DVector & v);
 int IntersectWithSegment(T3DPoint &p1,T3DPoint &p2,T3DPoint &ret);
};



#endif /*  INCLUDE_T3DPLAN  */ 


