#ifndef INCLUDE_T3DSURFACE
#define INCLUDE_T3DSURFACE

#include "zutl_hdr.h"
#include "t3dpoint.h"
#include "t3dvector.h"

class T3DPoint;
class T3DVector ;
class T3DSegmentLine;
class T3DLine ;

//////////////////////////////////////////////////////////////////////////
class  _ZUTL_CLASS T3DSurface
//////////////////////////////////////////////////////////////////////////
{
public :
	T3DSurface(void) { ; }
	virtual ~T3DSurface() { ; }
 	
	virtual T3DSurface & getCopy() const {  return *(new T3DSurface()) ; } ;

	virtual int IntersectWithSegmentLine(const T3DSegmentLine &,T3DPoint&) const ;
	virtual int IntersectWithInfiniteLine(const T3DSegmentLine& ,T3DPoint&)	const ;
	virtual int IntersectWithPoint(const T3DPoint&) const ;

	T3DPoint ** cutHexaedron(T3DPoint *hexaPts,int *, int *) ;

	friend class T3DSegmentLine;
	friend class T3DVector ;
};



#endif /*  INCLUDE_T3DSURFACE  */ 


