#ifndef T3DVECTOR
#define T3DVECTOR

#include "zutl_hdr.h"

#include <math.h>
#include "t3dpoint.h"

class T3DPoint;

//////////////////////////////////////////////////////////////////////////
class _ZUTL_CLASS T3DVector
	//////////////////////////////////////////////////////////////////////////
{
	friend class zLine;
	friend class T3DMatrix;
	friend class T3DPoint;
	friend class T3DPlan;
	friend class T3DPlanPh;
protected:
	double X[3];
public:
	T3DVector() { X[0] = X[1] = X[2] = 0.f; }
	T3DVector(const Vector& v) { X[0] = v.x; X[1] = v.y; X[2] = v.z; }
	T3DVector(const T3DVector& v) { X[0] = v.X[0]; X[1] = v.X[1]; X[2] = v.X[2]; }
	T3DVector(const T3DPoint& p) { X[0] = p.X[0]; X[1] = p.X[1]; X[2] = p.X[2]; }
	T3DVector(const double x, const double y, const double z) { X[0] = x; X[1] = y; X[2] = z; }
	T3DVector(const double* p) { X[0] = p[0]; X[1] = p[1]; X[2] = p[2]; }
	T3DVector(const T3DPoint& p1, const T3DPoint& p2)
	{
		X[0] = p2.X[0] - p1.X[0]; X[1] = p2.X[1] - p1.X[1]; X[2] = p2.X[2] - p1.X[2];
	}

	//T3DVector (CString str);
	T3DVector::T3DVector(char* str, int size);

	//	operator=(T3DVector&);
	double GiveCoordX() const { return X[0]; }
	double GiveCoordY() const { return X[1]; }
	double GiveCoordZ() const { return X[2]; }
	double* GiveCoord() { return X; }
	double& operator[](int n) { return X[n]; }
	double operator[](int n) const { return X[n]; }
	void SetValues(const double x, const double y, const double z) { X[0] = x; X[1] = y; X[2] = z; }
	void SetValues(const Vector);
	void SetValues(const T3DPoint p);
	void SetValues(const double* p) { X[0] = p[0]; X[1] = p[1]; X[2] = p[2]; }
	void SetNthValue(const int i, const double x) { X[i] = x; }
	T3DVector operator-()	const
	{
		return T3DVector(-X[0], -X[1], -X[2]);
	}
	T3DVector operator/(double) const;

	double Normaliser(void);

	double operator*(const T3DVector& vec) const
	{
		return (X[0] * vec.X[0] + X[1] * vec.X[1] + X[2] * vec.X[2]);
	}
	T3DVector operator*(double a) const {
		return T3DVector(a * X[0], a * X[1], a * X[2]);
	}
	T3DVector operator+(const T3DVector a) const {
		return T3DVector(a.X[0] + X[0], a.X[1] + X[1], a.X[2] + X[2]);
	}

	T3DVector operator-(const T3DVector& vec) {
		return T3DVector(X[0] - vec.X[0], X[1] - vec.X[1], X[2] - vec.X[2]);
	}
	double Modulus() const { return  sqrt((*this) * (*this)); }
	int operator==(const T3DVector& v) const;
	T3DVector ProdVect(const T3DVector&) const;
	T3DVector MultEleByEle(const T3DVector&) const;
	const double* GiveT3DPointer() { return X; }
	friend T3DVector ProdVect(const T3DVector& v1, const T3DVector& v2) { return v1.ProdVect(v2); }
	Vector asVector();
	int isNull();
	T3DVector* SplitWithRegression(int n, double q);

	int GivePosOfMinValue();
	double GetMax() const;
	double GetAbsMax() const;
};

#endif
